// ui/webui/resources/cr_components/app_management/app_management.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_WEBUI_RESOURCES_CR_COMPONENTS_APP_MANAGEMENT_APP_MANAGEMENT_MOJOM_DATA_VIEW_H_
#define UI_WEBUI_RESOURCES_CR_COMPONENTS_APP_MANAGEMENT_APP_MANAGEMENT_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "ui/webui/resources/cr_components/app_management/app_management.mojom-shared-internal.h"
#include "url/mojom/url.mojom-shared.h"


namespace app_management::mojom {
class PermissionDataView;

class RunOnOsLoginDataView;

class LocaleDataView;

class AppDataView;

class ExtensionAppPermissionMessageDataView;

class FileHandlingStateDataView;

class PermissionValueDataView;


}  // app_management::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::app_management::mojom::PermissionDataView> {
  using Data = ::app_management::mojom::internal::Permission_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::app_management::mojom::RunOnOsLoginDataView> {
  using Data = ::app_management::mojom::internal::RunOnOsLogin_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::app_management::mojom::LocaleDataView> {
  using Data = ::app_management::mojom::internal::Locale_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::app_management::mojom::AppDataView> {
  using Data = ::app_management::mojom::internal::App_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::app_management::mojom::ExtensionAppPermissionMessageDataView> {
  using Data = ::app_management::mojom::internal::ExtensionAppPermissionMessage_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::app_management::mojom::FileHandlingStateDataView> {
  using Data = ::app_management::mojom::internal::FileHandlingState_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::app_management::mojom::PermissionValueDataView> {
  using Data = ::app_management::mojom::internal::PermissionValue_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace app_management::mojom {


enum class AppType : int32_t {
  
  kUnknown = 0,
  
  kArc = 1,
  
  kCrostini = 2,
  
  kChromeApp = 3,
  
  kWeb = 4,
  
  kPluginVm = 5,
  
  kRemote = 6,
  
  kBorealis = 7,
  
  kSystemWeb = 8,
  
  kExtension = 9,
  
  kBruschetta = 10,
  kMinValue = 0,
  kMaxValue = 10,
};

 std::ostream& operator<<(std::ostream& os, AppType value);
inline bool IsKnownEnumValue(AppType value) {
  return internal::AppType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class PermissionType : int32_t {
  
  kUnknown = 0,
  
  kCamera = 1,
  
  kLocation = 2,
  
  kMicrophone = 3,
  
  kNotifications = 4,
  
  kContacts = 5,
  
  kStorage = 6,
  
  kPrinting = 7,
  
  kFileHandling = 8,
  kMinValue = 0,
  kMaxValue = 8,
};

 std::ostream& operator<<(std::ostream& os, PermissionType value);
inline bool IsKnownEnumValue(PermissionType value) {
  return internal::PermissionType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class TriState : int32_t {
  
  kAllow = 0,
  
  kBlock = 1,
  
  kAsk = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, TriState value);
inline bool IsKnownEnumValue(TriState value) {
  return internal::TriState_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class InstallReason : int32_t {
  
  kUnknown = 0,
  
  kSystem = 1,
  
  kPolicy = 2,
  
  kOem = 3,
  
  kDefault = 4,
  
  kSync = 5,
  
  kUser = 6,
  
  kSubApp = 7,
  
  kKiosk = 8,
  
  kCommandLine = 9,
  kMinValue = 0,
  kMaxValue = 9,
};

 std::ostream& operator<<(std::ostream& os, InstallReason value);
inline bool IsKnownEnumValue(InstallReason value) {
  return internal::InstallReason_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class InstallSource : int32_t {
  
  kUnknown = 0,
  
  kSystem = 1,
  
  kSync = 2,
  
  kPlayStore = 3,
  
  kChromeWebStore = 4,
  
  kBrowser = 5,
  kMinValue = 0,
  kMaxValue = 5,
};

 std::ostream& operator<<(std::ostream& os, InstallSource value);
inline bool IsKnownEnumValue(InstallSource value) {
  return internal::InstallSource_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class WindowMode : int32_t {
  
  kUnknown = 0,
  
  kWindow = 1,
  
  kBrowser = 2,
  
  kTabbedWindow = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, WindowMode value);
inline bool IsKnownEnumValue(WindowMode value) {
  return internal::WindowMode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class RunOnOsLoginMode : int32_t {
  
  kUnknown = 0,
  
  kNotRun = 1,
  
  kWindowed = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, RunOnOsLoginMode value);
inline bool IsKnownEnumValue(RunOnOsLoginMode value) {
  return internal::RunOnOsLoginMode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class PageHandlerFactoryInterfaceBase {};

using PageHandlerFactoryPtrDataView =
    mojo::InterfacePtrDataView<PageHandlerFactoryInterfaceBase>;
using PageHandlerFactoryRequestDataView =
    mojo::InterfaceRequestDataView<PageHandlerFactoryInterfaceBase>;
using PageHandlerFactoryAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PageHandlerFactoryInterfaceBase>;
using PageHandlerFactoryAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PageHandlerFactoryInterfaceBase>;
class PageHandlerInterfaceBase {};

using PageHandlerPtrDataView =
    mojo::InterfacePtrDataView<PageHandlerInterfaceBase>;
using PageHandlerRequestDataView =
    mojo::InterfaceRequestDataView<PageHandlerInterfaceBase>;
using PageHandlerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PageHandlerInterfaceBase>;
using PageHandlerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PageHandlerInterfaceBase>;
class PageInterfaceBase {};

using PagePtrDataView =
    mojo::InterfacePtrDataView<PageInterfaceBase>;
using PageRequestDataView =
    mojo::InterfaceRequestDataView<PageInterfaceBase>;
using PageAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PageInterfaceBase>;
using PageAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PageInterfaceBase>;


class PermissionDataView {
 public:
  PermissionDataView() = default;

  PermissionDataView(
      internal::Permission_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadPermissionType(UserType* output) const {
    auto data_value = data_->permission_type;
    return mojo::internal::Deserialize<::app_management::mojom::PermissionType>(
        data_value, output);
  }
  PermissionType permission_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::app_management::mojom::PermissionType>(data_->permission_type));
  }
  inline void GetValueDataView(
      PermissionValueDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadValue(UserType* output) {
    
    auto* pointer = !data_->value.is_null() ? &data_->value : nullptr;
    return mojo::internal::Deserialize<::app_management::mojom::PermissionValueDataView>(
        pointer, output, message_);
  }
  bool is_managed() const {
    return data_->is_managed;
  }
  inline void GetDetailsDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDetails(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `details` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDetails` instead "
    "of `ReadDetails if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->details.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::Permission_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class RunOnOsLoginDataView {
 public:
  RunOnOsLoginDataView() = default;

  RunOnOsLoginDataView(
      internal::RunOnOsLogin_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadLoginMode(UserType* output) const {
    auto data_value = data_->login_mode;
    return mojo::internal::Deserialize<::app_management::mojom::RunOnOsLoginMode>(
        data_value, output);
  }
  RunOnOsLoginMode login_mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::app_management::mojom::RunOnOsLoginMode>(data_->login_mode));
  }
  bool is_managed() const {
    return data_->is_managed;
  }
 private:
  internal::RunOnOsLogin_Data* data_ = nullptr;
};


class LocaleDataView {
 public:
  LocaleDataView() = default;

  LocaleDataView(
      internal::Locale_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetLocaleTagDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLocaleTag(UserType* output) {
    
    auto* pointer = data_->locale_tag.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetDisplayNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDisplayName(UserType* output) {
    
    auto* pointer = data_->display_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetNativeDisplayNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNativeDisplayName(UserType* output) {
    
    auto* pointer = data_->native_display_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::Locale_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AppDataView {
 public:
  AppDataView() = default;

  AppDataView(
      internal::App_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::app_management::mojom::AppType>(
        data_value, output);
  }
  AppType type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::app_management::mojom::AppType>(data_->type));
  }
  inline void GetTitleDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTitle(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `title` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTitle` instead "
    "of `ReadTitle if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->title.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetDescriptionDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDescription(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `description` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDescription` instead "
    "of `ReadDescription if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->description.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  std::optional<bool> is_pinned() const {

    return data_->is_pinned_$flag
        ? std::make_optional(!!data_->is_pinned_$value)
        : std::nullopt;
  }
  std::optional<bool> is_policy_pinned() const {

    return data_->is_policy_pinned_$flag
        ? std::make_optional(!!data_->is_policy_pinned_$value)
        : std::nullopt;
  }
  inline void GetVersionDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadVersion(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `version` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadVersion` instead "
    "of `ReadVersion if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->version.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetSizeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSize(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `size` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSize` instead "
    "of `ReadSize if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->size.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetPermissionsDataView(
      mojo::MapDataView<PermissionType, PermissionDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPermissions(UserType* output) {
    
    auto* pointer = data_->permissions.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::app_management::mojom::PermissionType, ::app_management::mojom::PermissionDataView>>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadInstallReason(UserType* output) const {
    auto data_value = data_->install_reason;
    return mojo::internal::Deserialize<::app_management::mojom::InstallReason>(
        data_value, output);
  }
  InstallReason install_reason() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::app_management::mojom::InstallReason>(data_->install_reason));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadInstallSource(UserType* output) const {
    auto data_value = data_->install_source;
    return mojo::internal::Deserialize<::app_management::mojom::InstallSource>(
        data_value, output);
  }
  InstallSource install_source() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::app_management::mojom::InstallSource>(data_->install_source));
  }
  bool hide_more_settings() const {
    return data_->hide_more_settings;
  }
  bool hide_pin_to_shelf() const {
    return data_->hide_pin_to_shelf;
  }
  bool is_preferred_app() const {
    return data_->is_preferred_app;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadWindowMode(UserType* output) const {
    auto data_value = data_->window_mode;
    return mojo::internal::Deserialize<::app_management::mojom::WindowMode>(
        data_value, output);
  }
  WindowMode window_mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::app_management::mojom::WindowMode>(data_->window_mode));
  }
  bool hide_window_mode() const {
    return data_->hide_window_mode;
  }
  bool resize_locked() const {
    return data_->resize_locked;
  }
  bool hide_resize_locked() const {
    return data_->hide_resize_locked;
  }
  inline void GetSupportedLinksDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSupportedLinks(UserType* output) {
    
    auto* pointer = data_->supported_links.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
  inline void GetRunOnOsLoginDataView(
      RunOnOsLoginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRunOnOsLogin(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::app_management::mojom::RunOnOsLoginDataView, UserType>(),
    "Attempting to read the optional `run_on_os_login` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadRunOnOsLogin` instead "
    "of `ReadRunOnOsLogin if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->run_on_os_login.Get();
    return mojo::internal::Deserialize<::app_management::mojom::RunOnOsLoginDataView>(
        pointer, output, message_);
  }
  inline void GetFileHandlingStateDataView(
      FileHandlingStateDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFileHandlingState(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::app_management::mojom::FileHandlingStateDataView, UserType>(),
    "Attempting to read the optional `file_handling_state` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFileHandlingState` instead "
    "of `ReadFileHandlingState if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->file_handling_state.Get();
    return mojo::internal::Deserialize<::app_management::mojom::FileHandlingStateDataView>(
        pointer, output, message_);
  }
  inline void GetAppSizeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAppSize(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `app_size` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAppSize` instead "
    "of `ReadAppSize if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->app_size.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetDataSizeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDataSize(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `data_size` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDataSize` instead "
    "of `ReadDataSize if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->data_size.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetPublisherIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPublisherId(UserType* output) {
    
    auto* pointer = data_->publisher_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetFormattedOriginDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFormattedOrigin(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `formatted_origin` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFormattedOrigin` instead "
    "of `ReadFormattedOrigin if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->formatted_origin.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetScopeExtensionsDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScopeExtensions(UserType* output) {
    
    auto* pointer = data_->scope_extensions.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
  inline void GetSupportedLocalesDataView(
      mojo::ArrayDataView<LocaleDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSupportedLocales(UserType* output) {
    
    auto* pointer = data_->supported_locales.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::app_management::mojom::LocaleDataView>>(
        pointer, output, message_);
  }
  inline void GetSelectedLocaleDataView(
      LocaleDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSelectedLocale(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::app_management::mojom::LocaleDataView, UserType>(),
    "Attempting to read the optional `selected_locale` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSelectedLocale` instead "
    "of `ReadSelectedLocale if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->selected_locale.Get();
    return mojo::internal::Deserialize<::app_management::mojom::LocaleDataView>(
        pointer, output, message_);
  }
  bool show_system_notifications_settings_link() const {
    return data_->show_system_notifications_settings_link;
  }
  bool allow_uninstall() const {
    return data_->allow_uninstall;
  }
  bool disable_user_choice_navigation_capturing() const {
    return data_->disable_user_choice_navigation_capturing;
  }
 private:
  internal::App_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ExtensionAppPermissionMessageDataView {
 public:
  ExtensionAppPermissionMessageDataView() = default;

  ExtensionAppPermissionMessageDataView(
      internal::ExtensionAppPermissionMessage_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetMessageDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMessage(UserType* output) {
    
    auto* pointer = data_->message.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetSubmessagesDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSubmessages(UserType* output) {
    
    auto* pointer = data_->submessages.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
 private:
  internal::ExtensionAppPermissionMessage_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class FileHandlingStateDataView {
 public:
  FileHandlingStateDataView() = default;

  FileHandlingStateDataView(
      internal::FileHandlingState_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  bool enabled() const {
    return data_->enabled;
  }
  bool is_managed() const {
    return data_->is_managed;
  }
  inline void GetUserVisibleTypesDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUserVisibleTypes(UserType* output) {
    
    auto* pointer = data_->user_visible_types.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetUserVisibleTypesLabelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUserVisibleTypesLabel(UserType* output) {
    
    auto* pointer = data_->user_visible_types_label.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetLearnMoreUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLearnMoreUrl(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::UrlDataView, UserType>(),
    "Attempting to read the optional `learn_more_url` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadLearnMoreUrl` instead "
    "of `ReadLearnMoreUrl if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->learn_more_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
 private:
  internal::FileHandlingState_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PermissionValueDataView {
 public:
  using Tag = internal::PermissionValue_Data::PermissionValue_Tag;

  PermissionValueDataView() = default;

  PermissionValueDataView(
      internal::PermissionValue_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_bool_value() const { return data_->tag == Tag::kBoolValue; }
  bool bool_value() const {
    CHECK(is_bool_value());
    return data_->data.f_bool_value;
  }
  bool is_tristate_value() const { return data_->tag == Tag::kTristateValue; }
  template <typename UserType>
  [[nodiscard]] bool ReadTristateValue(UserType* output) const {
    CHECK(is_tristate_value());
    return mojo::internal::Deserialize<::app_management::mojom::TriState>(
        data_->data.f_tristate_value, output);
  }
  TriState tristate_value() const {
    CHECK(is_tristate_value());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::app_management::mojom::TriState>(data_->data.f_tristate_value));
  }

 private:
  internal::PermissionValue_Data* data_ = nullptr;
};



}  // app_management::mojom

#endif  // UI_WEBUI_RESOURCES_CR_COMPONENTS_APP_MANAGEMENT_APP_MANAGEMENT_MOJOM_DATA_VIEW_H_