// Copyright 2017 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// vector_icons.cc.template is used to generate vector_icons.cc. Edit the former
// rather than the latter.

#include "ui/views/vector_icons.h"

#include "components/vector_icons/cc_macros.h"
#include "ui/gfx/vector_icon_types.h"

#define DECLARE_VECTOR_COMMAND(x) using gfx::x;
DECLARE_VECTOR_COMMANDS

namespace views {

VECTOR_ICON_REP_TEMPLATE(kAccountBoxPath, CANVAS_DIMENSIONS, 12,
FILL_RULE_NONZERO,
MOVE_TO, 1.6, 9.52,
CUBIC_TO, 2.22, 9.01, 2.91, 8.63, 3.67, 8.38,
CUBIC_TO, 4.42, 8.13, 5.2, 8, 6, 8,
CUBIC_TO, 6.8, 8, 7.58, 8.12, 8.33, 8.37,
CUBIC_TO, 9.09, 8.61, 9.78, 8.99, 10.4, 9.52,
V_LINE_TO, 1.6,
H_LINE_TO, 1.6,
V_LINE_TO, 9.52,
CLOSE,
MOVE_TO, 6, 7.2,
CUBIC_TO, 6.67, 7.2, 7.23, 6.97, 7.7, 6.5,
CUBIC_TO, 8.17, 6.03, 8.4, 5.47, 8.4, 4.8,
CUBIC_TO, 8.4, 4.13, 8.17, 3.57, 7.7, 3.1,
CUBIC_TO, 7.23, 2.63, 6.67, 2.4, 6, 2.4,
CUBIC_TO, 5.33, 2.4, 4.77, 2.63, 4.3, 3.1,
CUBIC_TO, 3.83, 3.57, 3.6, 4.13, 3.6, 4.8,
CUBIC_TO, 3.6, 5.47, 3.83, 6.03, 4.3, 6.5,
CUBIC_TO, 4.77, 6.97, 5.33, 7.2, 6, 7.2,
CLOSE,
MOVE_TO, 1.6, 11.6,
CUBIC_TO, 1.27, 11.6, 0.98, 11.48, 0.75, 11.25,
CUBIC_TO, 0.52, 11.02, 0.4, 10.73, 0.4, 10.4,
V_LINE_TO, 1.6,
CUBIC_TO, 0.4, 1.27, 0.52, 0.98, 0.75, 0.75,
CUBIC_TO, 0.98, 0.52, 1.27, 0.4, 1.6, 0.4,
H_LINE_TO, 10.4,
CUBIC_TO, 10.73, 0.4, 11.02, 0.52, 11.25, 0.75,
CUBIC_TO, 11.48, 0.98, 11.6, 1.27, 11.6, 1.6,
V_LINE_TO, 10.4,
CUBIC_TO, 11.6, 10.73, 11.48, 11.02, 11.25, 11.25,
CUBIC_TO, 11.02, 11.48, 10.73, 11.6, 10.4, 11.6,
H_LINE_TO, 1.6,
CLOSE,
MOVE_TO, 2.42, 10.4,
H_LINE_TO, 9.58,
CUBIC_TO, 9.07, 10.01, 8.51, 9.72, 7.9, 9.52,
CUBIC_TO, 7.29, 9.31, 6.66, 9.2, 6, 9.2,
CUBIC_TO, 5.34, 9.2, 4.71, 9.31, 4.1, 9.52,
CUBIC_TO, 3.5, 9.72, 2.94, 10.01, 2.42, 10.4,
CLOSE,
MOVE_TO, 6, 6,
CUBIC_TO, 5.67, 6, 5.38, 5.88, 5.15, 5.65,
CUBIC_TO, 4.92, 5.42, 4.8, 5.13, 4.8, 4.8,
CUBIC_TO, 4.8, 4.47, 4.92, 4.18, 5.15, 3.95,
CUBIC_TO, 5.38, 3.72, 5.67, 3.6, 6, 3.6,
CUBIC_TO, 6.33, 3.6, 6.62, 3.72, 6.85, 3.95,
CUBIC_TO, 7.08, 4.18, 7.2, 4.47, 7.2, 4.8,
CUBIC_TO, 7.2, 5.13, 7.08, 5.42, 6.85, 5.65,
CUBIC_TO, 6.62, 5.88, 6.33, 6, 6, 6,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kAccountBoxRepList, kAccountBoxIcon, {kAccountBoxPath})
VECTOR_ICON_REP_TEMPLATE(kArrowDropDownPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 10, 12,
LINE_TO, 6, 8,
R_H_LINE_TO, 8,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kArrowDropDownRepList, kArrowDropDownIcon, {kArrowDropDownPath})
VECTOR_ICON_REP_TEMPLATE(kCheckboxActivePath, CANVAS_DIMENSIONS, 16,
MOVE_TO, 12.996, 14,
H_LINE_TO, 3.004,
CUBIC_TO, 2.449, 14, 2, 13.551, 2, 12.996,
V_LINE_TO, 3.004,
CUBIC_TO, 2, 2.449, 2.449, 2, 3.004, 2,
R_H_LINE_TO, 9.993,
CUBIC_TO, 13.551, 2, 14, 2.449, 14, 3.004,
R_V_LINE_TO, 9.993,
CUBIC_TO, 14, 13.551, 13.551, 14, 12.996, 14,
CLOSE,
MOVE_TO, 6.5, 11,
LINE_TO, 3.5, 8,
LINE_TO, 4.5, 7,
LINE_TO, 6.5, 9,
LINE_TO, 11.5, 4.5,
LINE_TO, 12.5, 5.5,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kCheckboxActiveRepList, kCheckboxActiveIcon, {kCheckboxActivePath})
VECTOR_ICON_REP_TEMPLATE(kCheckboxCheckCr2023Path, CANVAS_DIMENSIONS, 16,
NEW_PATH,
MOVE_TO, 12.19, 4.12,
LINE_TO, 6.18, 10.13,
LINE_TO, 4.06, 8.01,
LINE_TO, 3, 9.07,
R_LINE_TO, 2.12, 2.12,
R_LINE_TO, 0.71, 0.71,
R_LINE_TO, 0.35, 0.35,
R_LINE_TO, 7.07, -7.07,
R_LINE_TO, -1.06, -1.06,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kCheckboxCheckCr2023RepList, kCheckboxCheckCr2023Icon, {kCheckboxCheckCr2023Path})
VECTOR_ICON_REP_TEMPLATE(kCheckboxNormalPath, CANVAS_DIMENSIONS, 16,
MOVE_TO, 12.5, 3.5,
R_V_LINE_TO, 9,
R_H_LINE_TO, -9,
R_V_LINE_TO, -9,
H_LINE_TO, 12.5,
MOVE_TO, 12.996, 2,
H_LINE_TO, 3.004,
CUBIC_TO, 2.449, 2, 2, 2.449, 2, 3.004,
R_V_LINE_TO, 9.993,
CUBIC_TO, 2, 13.551, 2.449, 14, 3.004, 14,
R_H_LINE_TO, 9.993,
CUBIC_TO, 13.551, 14, 14, 13.551, 14, 12.996,
V_LINE_TO, 3.004,
CUBIC_TO, 14, 2.449, 13.551, 2, 12.996, 2,
LINE_TO, 12.996, 2,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kCheckboxNormalRepList, kCheckboxNormalIcon, {kCheckboxNormalPath})
VECTOR_ICON_REP_TEMPLATE(kCheckboxNormalCr2023Path, CANVAS_DIMENSIONS, 16,
NEW_PATH,
ROUND_RECT, 0, 0, 16, 16, 2,
MOVE_TO, 12.996, 2,
H_LINE_TO, 3.004,
CUBIC_TO, 2.449, 2, 2, 2.449, 2, 3.004,
R_V_LINE_TO, 9.993,
CUBIC_TO, 2, 13.551, 2.449, 14, 3.004, 14,
R_H_LINE_TO, 9.993,
CUBIC_TO, 13.551, 14, 14, 13.551, 14, 12.996,
V_LINE_TO, 3.004,
CUBIC_TO, 14, 2.449, 13.551, 2, 12.996, 2,
LINE_TO, 12.996, 2,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kCheckboxNormalCr2023RepList, kCheckboxNormalCr2023Icon, {kCheckboxNormalCr2023Path})
VECTOR_ICON_REP_TEMPLATE(kClosePath, CANVAS_DIMENSIONS, 20,
MOVE_TO, 12.07, 6.8,
LINE_TO, 10, 8.87,
LINE_TO, 7.93, 6.8,
LINE_TO, 6.8, 7.93,
LINE_TO, 8.87, 10,
LINE_TO, 6.8, 12.07,
LINE_TO, 7.93, 13.2,
LINE_TO, 10, 11.13,
R_LINE_TO, 2.07, 2.07,
R_LINE_TO, 1.13, -1.13,
LINE_TO, 11.13, 10,
LINE_TO, 13.2, 7.93,
LINE_TO, 12.07, 6.8,
CLOSE,
MOVE_TO, 10, 2,
R_CUBIC_TO, -4.42, 0, -8, 3.58, -8, 8,
R_CUBIC_TO, 0, 4.42, 3.58, 8, 8, 8,
R_CUBIC_TO, 4.42, 0, 8, -3.58, 8, -8,
R_CUBIC_TO, 0, -4.42, -3.58, -8, -8, -8,
CLOSE,
R_MOVE_TO, 0, 14,
R_CUBIC_TO, -3.31, 0, -6, -2.69, -6, -6,
R_CUBIC_TO, 0, -3.31, 2.69, -6, 6, -6,
R_CUBIC_TO, 3.31, 0, 6, 2.69, 6, 6,
R_CUBIC_TO, 0, 3.31, -2.69, 6, -6, 6,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kCloseRepList, kCloseIcon, {kClosePath})
VECTOR_ICON_REP_TEMPLATE(kDragGeneralSelectionPath, CANVAS_DIMENSIONS, 20,
MOVE_TO, 12.5, 4.5,
R_H_LINE_TO, -1.67,
V_LINE_TO, 2.83,
H_LINE_TO, 12.5,
V_LINE_TO, 4.5,
CLOSE,
R_MOVE_TO, 1.67, 3.33,
R_H_LINE_TO, 1.67,
V_LINE_TO, 6.17,
R_H_LINE_TO, -1.67,
R_V_LINE_TO, 1.67,
CLOSE,
R_MOVE_TO, 0, 3.33,
R_H_LINE_TO, 1.67,
V_LINE_TO, 9.5,
R_H_LINE_TO, -1.67,
R_V_LINE_TO, 1.67,
CLOSE,
MOVE_TO, 7.5, 17.83,
R_H_LINE_TO, 1.67,
R_V_LINE_TO, -1.67,
H_LINE_TO, 7.5,
R_V_LINE_TO, 1.67,
CLOSE,
MOVE_TO, 4.17, 4.5,
R_H_LINE_TO, 1.67,
V_LINE_TO, 2.83,
H_LINE_TO, 4.17,
V_LINE_TO, 4.5,
CLOSE,
R_MOVE_TO, -3.33, 10,
H_LINE_TO, 2.5,
R_V_LINE_TO, -1.67,
H_LINE_TO, 0.83,
V_LINE_TO, 14.5,
CLOSE,
MOVE_TO, 2.5, 17.83,
R_V_LINE_TO, -1.67,
H_LINE_TO, 0.83,
R_CUBIC_TO, 0, 0.92, 0.75, 1.67, 1.67, 1.67,
CLOSE,
R_MOVE_TO, 11.67, -15,
V_LINE_TO, 4.5,
R_H_LINE_TO, 1.67,
R_CUBIC_TO, 0, -0.92, -0.75, -1.67, -1.67, -1.67,
CLOSE,
MOVE_TO, 7.5, 4.5,
R_H_LINE_TO, 1.67,
V_LINE_TO, 2.83,
H_LINE_TO, 7.5,
V_LINE_TO, 4.5,
CLOSE,
MOVE_TO, 0.83, 7.83,
H_LINE_TO, 2.5,
V_LINE_TO, 6.17,
H_LINE_TO, 0.83,
R_V_LINE_TO, 1.67,
CLOSE,
R_MOVE_TO, 3.33, 10,
R_H_LINE_TO, 1.67,
R_V_LINE_TO, -1.67,
H_LINE_TO, 4.17,
R_V_LINE_TO, 1.67,
CLOSE,
MOVE_TO, 0.83, 11.17,
H_LINE_TO, 2.5,
V_LINE_TO, 9.5,
H_LINE_TO, 0.83,
R_V_LINE_TO, 1.67,
CLOSE,
R_MOVE_TO, 0, -6.67,
H_LINE_TO, 2.5,
V_LINE_TO, 2.83,
R_CUBIC_TO, -0.92, 0, -1.67, 0.75, -1.67, 1.67,
CLOSE,
MOVE_TO, 10.83, 16.17,
R_V_LINE_TO, 1.67,
R_H_LINE_TO, 3.34,
R_LINE_TO, -0.01, 3.33,
R_H_LINE_TO, 1.67,
R_LINE_TO, 0.01, -3.32,
R_LINE_TO, 3.33, -0.01,
R_V_LINE_TO, -1.67,
R_LINE_TO, -3.33, 0.01,
R_V_LINE_TO, -3.33,
R_H_LINE_TO, -1.67,
R_V_LINE_TO, 3.33,
R_H_LINE_TO, -3.33,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kDragGeneralSelectionRepList, kDragGeneralSelectionIcon, {kDragGeneralSelectionPath})
VECTOR_ICON_REP_TEMPLATE(kEyePath, CANVAS_DIMENSIONS, 16,
MOVE_TO, 8, 5.67,
CUBIC_TO, 7.47, 5.67, 6.96, 5.88, 6.59, 6.25,
CUBIC_TO, 6.21, 6.63, 6, 7.14, 6, 7.67,
CUBIC_TO, 6, 8.2, 6.21, 8.71, 6.59, 9.08,
CUBIC_TO, 6.96, 9.46, 7.47, 9.67, 8, 9.67,
CUBIC_TO, 8.53, 9.67, 9.04, 9.46, 9.41, 9.08,
CUBIC_TO, 9.79, 8.71, 10, 8.2, 10, 7.67,
CUBIC_TO, 10, 7.14, 9.79, 6.63, 9.41, 6.25,
CUBIC_TO, 9.04, 5.88, 8.53, 5.67, 8, 5.67,
CLOSE,
MOVE_TO, 8, 11,
CUBIC_TO, 7.12, 11, 6.27, 10.65, 5.64, 10.02,
CUBIC_TO, 5.02, 9.4, 4.67, 8.55, 4.67, 7.67,
CUBIC_TO, 4.67, 6.78, 5.02, 5.93, 5.64, 5.31,
CUBIC_TO, 6.27, 4.68, 7.12, 4.33, 8, 4.33,
CUBIC_TO, 8.88, 4.33, 9.73, 4.68, 10.36, 5.31,
CUBIC_TO, 10.98, 5.93, 11.33, 6.78, 11.33, 7.67,
CUBIC_TO, 11.33, 8.55, 10.98, 9.4, 10.36, 10.02,
CUBIC_TO, 9.73, 10.65, 8.88, 11, 8, 11,
V_LINE_TO, 11,
CLOSE,
MOVE_TO, 8, 2.67,
CUBIC_TO, 4.67, 2.67, 1.82, 4.74, 0.67, 7.67,
CUBIC_TO, 1.82, 10.59, 4.67, 12.67, 8, 12.67,
CUBIC_TO, 11.33, 12.67, 14.18, 10.59, 15.33, 7.67,
CUBIC_TO, 14.18, 4.74, 11.33, 2.67, 8, 2.67,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kEyeRepList, kEyeIcon, {kEyePath})
VECTOR_ICON_REP_TEMPLATE(kEyeCrossedPath, CANVAS_DIMENSIONS, 16,
MOVE_TO, 2.53, 1.47,
LINE_TO, 14.53, 13.47,
LINE_TO, 13.47, 14.53,
LINE_TO, 11.01, 12.07,
CUBIC_TO, 10.08, 12.45, 9.07, 12.67, 8, 12.67,
CUBIC_TO, 4.67, 12.67, 1.82, 10.59, 0.67, 7.67,
CUBIC_TO, 1.2, 6.32, 2.09, 5.15, 3.22, 4.28,
LINE_TO, 1.47, 2.53,
LINE_TO, 2.53, 1.47,
CLOSE,
MOVE_TO, 5.05, 6.11,
CUBIC_TO, 4.8, 6.59, 4.67, 7.12, 4.67, 7.67,
CUBIC_TO, 4.67, 8.55, 5.02, 9.4, 5.64, 10.02,
CUBIC_TO, 6.27, 10.65, 7.12, 11, 8, 11,
CUBIC_TO, 8.55, 11, 9.08, 10.87, 9.55, 10.62,
LINE_TO, 8.53, 9.59,
CUBIC_TO, 8.36, 9.64, 8.18, 9.67, 8, 9.67,
CUBIC_TO, 7.47, 9.67, 6.96, 9.46, 6.59, 9.08,
CUBIC_TO, 6.21, 8.71, 6, 8.2, 6, 7.67,
CUBIC_TO, 6, 7.48, 6.02, 7.31, 6.07, 7.13,
LINE_TO, 5.05, 6.11,
CLOSE,
MOVE_TO, 7.44, 4.38,
LINE_TO, 5.99, 2.93,
CUBIC_TO, 6.63, 2.76, 7.3, 2.67, 8, 2.67,
CUBIC_TO, 11.33, 2.67, 14.18, 4.74, 15.33, 7.67,
CUBIC_TO, 14.92, 8.72, 14.29, 9.66, 13.49, 10.43,
LINE_TO, 11.29, 8.23,
CUBIC_TO, 11.32, 8.04, 11.33, 7.86, 11.33, 7.67,
CUBIC_TO, 11.33, 6.78, 10.98, 5.93, 10.36, 5.31,
CUBIC_TO, 9.73, 4.68, 8.88, 4.33, 8, 4.33,
CUBIC_TO, 7.81, 4.33, 7.62, 4.35, 7.44, 4.38,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kEyeCrossedRepList, kEyeCrossedIcon, {kEyeCrossedPath})
VECTOR_ICON_REP_TEMPLATE(kEyeCrossedRefreshPath, CANVAS_DIMENSIONS, 20,
R_MOVE_TO, 13.3, 11.06,
R_LINE_TO, -1.51, -1.51,
R_ARC_TO, 1.24, 1.24, 0, 0, 0, -0.38, -1.03,
R_ARC_TO, 1.25, 1.25, 0, 0, 0, -1.01, -0.37,
LINE_TO, 8.94, 6.68,
R_CUBIC_TO, 0.17, -0.06, 0.35, -0.11, 0.53, -0.14,
R_CUBIC_TO, 0.18, -0.03, 0.36, -0.04, 0.53, -0.04,
R_CUBIC_TO, 0.97, 0, 1.8, 0.34, 2.48, 1.02,
R_CUBIC_TO, 0.68, 0.68, 1.02, 1.51, 1.02, 2.48,
R_CUBIC_TO, 0, 0.16, -0.02, 0.34, -0.04, 0.53,
R_ARC_TO, 2.15, 2.15, 0, 0, 1, -0.16, 0.53,
CLOSE,
R_MOVE_TO, 2.9, 2.91,
R_LINE_TO, -1.18, -1.2,
R_CUBIC_TO, 0.48, -0.38, 0.91, -0.8, 1.3, -1.25,
ARC_TO, 7.41, 7.41, 0, 0, 0, 17.34, 10,
R_ARC_TO, 7.81, 7.81, 0, 0, 0, -3.01, -3.3,
CUBIC_TO, 13.02, 5.9, 11.57, 5.5, 10, 5.5,
R_CUBIC_TO, -0.36, 0, -0.71, 0.02, -1.03, 0.06,
R_ARC_TO, 6.38, 6.38, 0, 0, 0, -0.96, 0.19,
R_LINE_TO, -1.34, -1.34,
R_ARC_TO, 7.61, 7.61, 0, 0, 1, 1.64, -0.44,
ARC_TO, 11.67, 11.67, 0, 0, 1, 10, 3.84,
R_CUBIC_TO, 2.01, 0, 3.85, 0.55, 5.52, 1.64,
R_CUBIC_TO, 1.68, 1.09, 2.89, 2.6, 3.64, 4.52,
R_ARC_TO, 8.65, 8.65, 0, 0, 1, -1.23, 2.19,
R_ARC_TO, 11.67, 11.67, 0, 0, 1, -1.73, 1.79,
CLOSE,
R_MOVE_TO, -0.26, 4.21,
R_LINE_TO, -2.62, -2.62,
R_ARC_TO, 9.38, 9.38, 0, 0, 1, -1.61, 0.45,
R_ARC_TO, 9.84, 9.84, 0, 0, 1, -1.71, 0.15,
R_ARC_TO, 9.89, 9.89, 0, 0, 1, -5.52, -1.64,
CUBIC_TO, 2.8, 13.41, 1.59, 11.91, 0.84, 10,
R_ARC_TO, 8.99, 8.99, 0, 0, 1, 1.21, -2.18,
ARC_TO, 10.59, 10.59, 0, 0, 1, 3.8, 6.02,
LINE_TO, 1.73, 3.97,
R_LINE_TO, 1.12, -1.12,
LINE_TO, 17.05, 17.07,
CLOSE,
MOVE_TO, 4.98, 7.2,
R_CUBIC_TO, -0.48, 0.4, -0.92, 0.82, -1.32, 1.26,
R_CUBIC_TO, -0.4, 0.45, -0.73, 0.96, -1, 1.54,
R_ARC_TO, 7.7, 7.7, 0, 0, 0, 3, 3.3,
R_ARC_TO, 8.2, 8.2, 0, 0, 0, 5.33, 1.13,
R_ARC_TO, 9.12, 9.12, 0, 0, 0, 1.02, -0.19,
R_LINE_TO, -0.94, -0.94,
ARC_TO, 3.08, 3.08, 0, 0, 1, 10, 13.5,
R_CUBIC_TO, -0.97, 0, -1.8, -0.34, -2.48, -1.02,
R_CUBIC_TO, -0.68, -0.68, -1.02, -1.51, -1.02, -2.48,
R_CUBIC_TO, 0, -0.18, 0.02, -0.35, 0.07, -0.53,
R_CUBIC_TO, 0.04, -0.18, 0.08, -0.36, 0.12, -0.54,
CLOSE,
R_MOVE_TO, 6.1, 1.76,
CLOSE,
MOVE_TO, 8.93, 11.04,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kEyeCrossedRefreshRepList, kEyeCrossedRefreshIcon, {kEyeCrossedRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kEyeRefreshPath, CANVAS_DIMENSIONS, 20,
MOVE_TO, 10, 13.5,
R_CUBIC_TO, 0.97, 0, 1.8, -0.34, 2.48, -1.02,
R_CUBIC_TO, 0.68, -0.68, 1.02, -1.51, 1.02, -2.48,
R_CUBIC_TO, 0, -0.97, -0.34, -1.8, -1.02, -2.48,
R_CUBIC_TO, -0.68, -0.68, -1.51, -1.02, -2.48, -1.02,
R_CUBIC_TO, -0.97, 0, -1.8, 0.34, -2.48, 1.02,
CUBIC_TO, 6.84, 8.2, 6.5, 9.03, 6.5, 10,
R_CUBIC_TO, 0, 0.97, 0.34, 1.8, 1.02, 2.48,
R_CUBIC_TO, 0.68, 0.68, 1.51, 1.02, 2.48, 1.02,
CLOSE,
R_MOVE_TO, 0, -1.6,
R_CUBIC_TO, -0.52, 0, -0.97, -0.18, -1.34, -0.55,
ARC_TO, 1.84, 1.84, 0, 0, 1, 8.11, 10,
R_CUBIC_TO, 0, -0.52, 0.18, -0.97, 0.55, -1.34,
R_CUBIC_TO, 0.37, -0.37, 0.82, -0.55, 1.34, -0.55,
R_CUBIC_TO, 0.52, 0, 0.97, 0.18, 1.34, 0.55,
R_CUBIC_TO, 0.37, 0.37, 0.55, 0.82, 0.55, 1.34,
R_CUBIC_TO, 0, 0.52, -0.18, 0.97, -0.55, 1.34,
R_CUBIC_TO, -0.37, 0.37, -0.82, 0.55, -1.34, 0.55,
CLOSE,
R_MOVE_TO, 0, 4.26,
R_CUBIC_TO, -2.02, 0, -3.85, -0.56, -5.51, -1.69,
CUBIC_TO, 2.84, 13.35, 1.62, 11.86, 0.84, 10,
R_CUBIC_TO, 0.78, -1.85, 1.99, -3.35, 3.65, -4.47,
CUBIC_TO, 6.15, 4.41, 7.98, 3.84, 10, 3.84,
R_CUBIC_TO, 2.02, 0, 3.86, 0.56, 5.51, 1.69,
R_CUBIC_TO, 1.66, 1.12, 2.87, 2.61, 3.65, 4.47,
R_CUBIC_TO, -0.78, 1.86, -1.99, 3.35, -3.65, 4.47,
R_CUBIC_TO, -1.65, 1.13, -3.49, 1.69, -5.51, 1.69,
CLOSE,
MOVE_TO, 10, 10,
CLOSE,
R_MOVE_TO, 0, 4.5,
R_CUBIC_TO, 1.55, 0, 2.99, -0.4, 4.3, -1.21,
ARC_TO, 8.12, 8.12, 0, 0, 0, 17.34, 10,
R_ARC_TO, 8.12, 8.12, 0, 0, 0, -3.04, -3.29,
ARC_TO, 8.06, 8.06, 0, 0, 0, 10, 5.5,
R_CUBIC_TO, -1.55, 0, -2.99, 0.4, -4.3, 1.21,
ARC_TO, 8.12, 8.12, 0, 0, 0, 2.66, 10,
R_ARC_TO, 8.12, 8.12, 0, 0, 0, 3.04, 3.29,
ARC_TO, 8.06, 8.06, 0, 0, 0, 10, 14.5,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kEyeRefreshRepList, kEyeRefreshIcon, {kEyeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kIcClosePath, CANVAS_DIMENSIONS, 48,
MOVE_TO, 38, 12.82,
LINE_TO, 35.18, 10,
LINE_TO, 24, 21.18,
LINE_TO, 12.82, 10,
LINE_TO, 10, 12.82,
LINE_TO, 21.18, 24,
LINE_TO, 10, 35.18,
LINE_TO, 12.82, 38,
LINE_TO, 24, 26.82,
LINE_TO, 35.18, 38,
LINE_TO, 38, 35.18,
LINE_TO, 26.82, 24,
CLOSE)
VECTOR_ICON_REP_TEMPLATE(kIcClose24Path, CANVAS_DIMENSIONS, 24,
MOVE_TO, 19, 6.41,
LINE_TO, 17.59, 5,
LINE_TO, 12, 10.59,
LINE_TO, 6.41, 5,
LINE_TO, 5, 6.41,
LINE_TO, 10.59, 12,
LINE_TO, 5, 17.59,
LINE_TO, 6.41, 19,
LINE_TO, 12, 13.41,
LINE_TO, 17.59, 19,
LINE_TO, 19, 17.59,
LINE_TO, 13.41, 12,
CLOSE)
VECTOR_ICON_REP_TEMPLATE(kIcClose20Path, CANVAS_DIMENSIONS, 20,
MOVE_TO, 16, 5.41,
LINE_TO, 14.59, 4,
LINE_TO, 10, 8.59,
LINE_TO, 5.41, 4,
LINE_TO, 4, 5.41,
LINE_TO, 8.59, 10,
LINE_TO, 4, 14.59,
LINE_TO, 5.41, 16,
LINE_TO, 10, 11.41,
LINE_TO, 14.59, 16,
LINE_TO, 16, 14.59,
LINE_TO, 11.41, 10,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kIcCloseRepList, kIcCloseIcon, {kIcClosePath}, {kIcClose24Path}, {kIcClose20Path})
VECTOR_ICON_REP_TEMPLATE(kInfoPath, CANVAS_DIMENSIONS, 20,
MOVE_TO, 9, 14,
R_H_LINE_TO, 2,
R_V_LINE_TO, -4,
H_LINE_TO, 9,
R_V_LINE_TO, 4,
CLOSE,
R_MOVE_TO, 1, -12,
R_CUBIC_TO, -4.42, 0, -8, 3.58, -8, 8,
R_CUBIC_TO, 0, 4.42, 3.58, 8, 8, 8,
R_CUBIC_TO, 4.42, 0, 8, -3.58, 8, -8,
R_CUBIC_TO, 0, -4.42, -3.58, -8, -8, -8,
CLOSE,
R_MOVE_TO, 0, 14,
R_CUBIC_TO, -3.31, 0, -6, -2.69, -6, -6,
R_CUBIC_TO, 0, -3.31, 2.69, -6, 6, -6,
R_CUBIC_TO, 3.31, 0, 6, 2.69, 6, 6,
R_CUBIC_TO, 0, 3.31, -2.69, 6, -6, 6,
CLOSE,
MOVE_TO, 9, 8,
R_H_LINE_TO, 2,
V_LINE_TO, 6,
H_LINE_TO, 9,
R_V_LINE_TO, 2,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kInfoRepList, kInfoIcon, {kInfoPath})
VECTOR_ICON_REP_TEMPLATE(kInfoChromeRefreshPath, CANVAS_DIMENSIONS, 20,
MOVE_TO, 9.18, 14.07,
R_H_LINE_TO, 1.65,
V_LINE_TO, 9,
H_LINE_TO, 9.18,
CLOSE,
R_MOVE_TO, 0.82, -6.47,
R_ARC_TO, 0.83, 0.83, 0, 0, 0, 0.61, -0.25,
R_ARC_TO, 0.81, 0.81, 0, 0, 0, 0.25, -0.6,
R_ARC_TO, 0.83, 0.83, 0, 0, 0, -0.25, -0.61,
R_ARC_TO, 0.81, 0.81, 0, 0, 0, -0.6, -0.25,
R_ARC_TO, 0.83, 0.83, 0, 0, 0, -0.61, 0.25,
R_ARC_TO, 0.81, 0.81, 0, 0, 0, -0.25, 0.6,
R_CUBIC_TO, 0, 0.24, 0.08, 0.44, 0.25, 0.61,
R_CUBIC_TO, 0.16, 0.16, 0.36, 0.25, 0.6, 0.25,
CLOSE,
R_MOVE_TO, 0.01, 10.57,
R_ARC_TO, 7.99, 7.99, 0, 0, 1, -3.18, -0.64,
R_ARC_TO, 8.22, 8.22, 0, 0, 1, -4.36, -4.36,
R_ARC_TO, 7.99, 7.99, 0, 0, 1, -0.64, -3.18,
R_CUBIC_TO, 0, -1.13, 0.21, -2.19, 0.64, -3.18,
ARC_TO, 8.22, 8.22, 0, 0, 1, 6.82, 2.47,
R_ARC_TO, 7.99, 7.99, 0, 0, 1, 3.18, -0.64,
R_CUBIC_TO, 1.13, 0, 2.19, 0.21, 3.18, 0.64,
R_ARC_TO, 8.22, 8.22, 0, 0, 1, 2.59, 1.75,
R_ARC_TO, 8.2, 8.2, 0, 0, 1, 1.75, 2.6,
R_CUBIC_TO, 0.43, 0.99, 0.64, 2.05, 0.64, 3.18,
R_CUBIC_TO, 0, 1.13, -0.21, 2.19, -0.64, 3.18,
R_ARC_TO, 8.22, 8.22, 0, 0, 1, -4.35, 4.36,
R_ARC_TO, 7.94, 7.94, 0, 0, 1, -3.18, 0.64,
CLOSE,
MOVE_TO, 10, 16.44,
R_CUBIC_TO, 1.79, 0, 3.31, -0.62, 4.56, -1.88,
R_CUBIC_TO, 1.25, -1.25, 1.88, -2.77, 1.88, -4.56,
R_CUBIC_TO, 0, -1.79, -0.62, -3.31, -1.88, -4.56,
CUBIC_TO, 13.31, 4.18, 11.79, 3.56, 10, 3.56,
R_CUBIC_TO, -1.79, 0, -3.31, 0.63, -4.56, 1.88,
CUBIC_TO, 4.18, 6.69, 3.56, 8.21, 3.56, 10,
R_CUBIC_TO, 0, 1.79, 0.63, 3.31, 1.88, 4.56,
R_CUBIC_TO, 1.25, 1.25, 2.77, 1.88, 4.56, 1.88,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kInfoChromeRefreshRepList, kInfoChromeRefreshIcon, {kInfoChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kLaunchPath, CANVAS_DIMENSIONS, 20,
MOVE_TO, 16, 16,
H_LINE_TO, 4,
V_LINE_TO, 4,
R_H_LINE_TO, 6,
V_LINE_TO, 2,
H_LINE_TO, 4,
CUBIC_TO, 3, 2, 2, 3, 2, 4,
R_V_LINE_TO, 12,
R_CUBIC_TO, 0, 1, 1, 2, 2, 2,
R_H_LINE_TO, 12,
R_CUBIC_TO, 1, 0, 2, -1, 2, -2,
R_V_LINE_TO, -6,
R_H_LINE_TO, -2,
R_V_LINE_TO, 6,
CLOSE,
MOVE_TO, 12, 2,
R_V_LINE_TO, 2,
R_H_LINE_TO, 2.5,
LINE_TO, 6, 12.5,
LINE_TO, 7.5, 14,
LINE_TO, 16, 5.5,
V_LINE_TO, 8,
R_H_LINE_TO, 2,
V_LINE_TO, 2,
R_H_LINE_TO, -6,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kLaunchRepList, kLaunchIcon, {kLaunchPath})
VECTOR_ICON_REP_TEMPLATE(kLinuxHighDensityPath, CANVAS_DIMENSIONS, 20,
MOVE_TO, 7, 17,
V_LINE_TO, 7,
R_H_LINE_TO, 10,
R_V_LINE_TO, 10,
CLOSE,
R_MOVE_TO, 8, -2,
V_LINE_TO, 9,
H_LINE_TO, 9,
R_V_LINE_TO, 6,
CLOSE,
R_MOVE_TO, 2, -10,
R_H_LINE_TO, -2,
V_LINE_TO, 3,
R_H_LINE_TO, 2,
CLOSE,
MOVE_TO, 5, 17,
H_LINE_TO, 3,
R_V_LINE_TO, -2,
R_H_LINE_TO, 2,
CLOSE,
R_MOVE_TO, 8, -12,
R_H_LINE_TO, -2,
V_LINE_TO, 3,
R_H_LINE_TO, 2,
CLOSE,
MOVE_TO, 9, 5,
H_LINE_TO, 7,
V_LINE_TO, 3,
R_H_LINE_TO, 2,
CLOSE,
MOVE_TO, 5, 5,
H_LINE_TO, 3,
V_LINE_TO, 3,
R_H_LINE_TO, 2,
CLOSE,
R_MOVE_TO, 0, 4,
H_LINE_TO, 3,
V_LINE_TO, 7,
R_H_LINE_TO, 2,
CLOSE,
R_MOVE_TO, 0, 4,
H_LINE_TO, 3,
R_V_LINE_TO, -2,
R_H_LINE_TO, 2,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kLinuxHighDensityRepList, kLinuxHighDensityIcon, {kLinuxHighDensityPath})
VECTOR_ICON_REP_TEMPLATE(kLinuxLowDensityPath, CANVAS_DIMENSIONS, 20,
MOVE_TO, 9, 17,
H_LINE_TO, 3,
V_LINE_TO, 3,
R_H_LINE_TO, 14,
R_V_LINE_TO, 6,
R_H_LINE_TO, -2,
V_LINE_TO, 5,
H_LINE_TO, 5,
R_V_LINE_TO, 10,
R_H_LINE_TO, 4,
CLOSE,
R_MOVE_TO, 8, 0,
R_H_LINE_TO, -2,
R_V_LINE_TO, -2,
R_H_LINE_TO, 2,
CLOSE,
R_MOVE_TO, -4, 0,
R_H_LINE_TO, -2,
R_V_LINE_TO, -2,
R_H_LINE_TO, 2,
CLOSE,
R_MOVE_TO, -4, -4,
H_LINE_TO, 7,
R_V_LINE_TO, -2,
R_H_LINE_TO, 2,
CLOSE,
R_MOVE_TO, 0, -4,
H_LINE_TO, 7,
V_LINE_TO, 7,
R_H_LINE_TO, 2,
CLOSE,
R_MOVE_TO, 4, 0,
R_H_LINE_TO, -2,
V_LINE_TO, 7,
R_H_LINE_TO, 2,
CLOSE,
R_MOVE_TO, 4, 4,
R_H_LINE_TO, -2,
R_V_LINE_TO, -2,
R_H_LINE_TO, 2,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kLinuxLowDensityRepList, kLinuxLowDensityIcon, {kLinuxLowDensityPath})
VECTOR_ICON_REP_TEMPLATE(kMenuCheckPath, CANVAS_DIMENSIONS, 32,
MOVE_TO, 5, 18.78,
R_LINE_TO, 2.53, -2.57,
R_LINE_TO, 4.48, 4.63,
LINE_TO, 25.48, 7,
LINE_TO, 28, 9.59,
LINE_TO, 12.02, 26,
LINE_TO, 5, 18.78,
CLOSE)
VECTOR_ICON_REP_TEMPLATE(kMenuCheck16Path, CANVAS_DIMENSIONS, 16,
MOVE_TO, 2, 9.22,
R_LINE_TO, 1.36, -1.38,
R_LINE_TO, 2.4, 2.48,
R_LINE_TO, 7.2, -7.4,
R_LINE_TO, 1.35, 1.39,
R_LINE_TO, -8.55, 8.78,
LINE_TO, 2, 9.22,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kMenuCheckRepList, kMenuCheckIcon, {kMenuCheckPath}, {kMenuCheck16Path})
VECTOR_ICON_REP_TEMPLATE(kMenuClosePath, CANVAS_DIMENSIONS, 24,
FILL_RULE_NONZERO,
MOVE_TO, 21, 18,
LINE_TO, 21, 16,
LINE_TO, 8, 16,
LINE_TO, 8, 18,
CLOSE,
MOVE_TO, 4.4f, 17,
LINE_TO, 9.4f, 12,
LINE_TO, 4.4f, 7,
LINE_TO, 3, 8.4f,
LINE_TO, 6.6f, 12,
LINE_TO, 3, 15.6f,
CLOSE,
MOVE_TO, 21, 13,
LINE_TO, 21, 11,
LINE_TO, 11, 11,
LINE_TO, 11, 13,
CLOSE,
MOVE_TO, 21, 8,
LINE_TO, 21, 6,
LINE_TO, 8, 6,
LINE_TO, 8, 8,
CLOSE,
MOVE_TO, 21, 8,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kMenuCloseRepList, kMenuCloseIcon, {kMenuClosePath})
VECTOR_ICON_REP_TEMPLATE(kMenuOpenPath, CANVAS_DIMENSIONS, 24,
FILL_RULE_NONZERO,
MOVE_TO, 3, 18,
LINE_TO, 3, 16,
LINE_TO, 16, 16,
LINE_TO, 16, 18,
CLOSE,
MOVE_TO, 19.6f, 17,
LINE_TO, 14.6f, 12,
LINE_TO, 19.6f, 7,
LINE_TO, 21, 8.4f,
LINE_TO, 17.4f, 12,
LINE_TO, 21, 15.6f,
CLOSE,
MOVE_TO, 3, 13,
LINE_TO, 3, 11,
LINE_TO, 13, 11,
LINE_TO, 13, 13,
CLOSE,
MOVE_TO, 3, 8,
LINE_TO, 3, 6,
LINE_TO, 16, 6,
LINE_TO, 16, 8,
CLOSE,
MOVE_TO, 3, 8,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kMenuOpenRepList, kMenuOpenIcon, {kMenuOpenPath})
VECTOR_ICON_REP_TEMPLATE(kMenuRadioEmptyPath, CANVAS_DIMENSIONS, 32,
CIRCLE, 16, 16, 14,
CIRCLE, 16, 16, 11)
VECTOR_ICON_TEMPLATE_CC(kMenuRadioEmptyRepList, kMenuRadioEmptyIcon, {kMenuRadioEmptyPath})
VECTOR_ICON_REP_TEMPLATE(kMenuRadioSelectedPath, CANVAS_DIMENSIONS, 32,
CIRCLE, 16, 16, 14,
CIRCLE, 16, 16, 11,
CIRCLE, 16, 16, 7)
VECTOR_ICON_TEMPLATE_CC(kMenuRadioSelectedRepList, kMenuRadioSelectedIcon, {kMenuRadioSelectedPath})
VECTOR_ICON_REP_TEMPLATE(kNewIncognitoWindowPath, CANVAS_DIMENSIONS, 20,
MOVE_TO, 8.13, 2.04,
LINE_TO, 10, 2.67,
R_LINE_TO, 1.85, -0.62,
R_ARC_TO, 0.89, 0.89, 0, 0, 1, 1.11, 0.54,
LINE_TO, 15, 8,
H_LINE_TO, 5,
R_LINE_TO, 2.03, -5.42,
R_ARC_TO, 0.89, 0.89, 0, 0, 1, 1.11, -0.54,
CLOSE,
MOVE_TO, 18, 10,
H_LINE_TO, 2,
V_LINE_TO, 9,
R_H_LINE_TO, 16,
R_V_LINE_TO, 1,
CLOSE,
R_MOVE_TO, -4.06, 7,
R_ARC_TO, 3.03, 3.03, 0, 0, 1, -3.03, -2.75,
R_CUBIC_TO, -0.84, -0.53, -1.55, -0.2, -1.8, -0.01,
CUBIC_TO, 8.97, 15.78, 7.67, 17, 6.06, 17,
CUBIC_TO, 4.37, 17, 3, 15.65, 3, 14,
R_CUBIC_TO, 0, -1.65, 1.37, -3, 3.06, -3,
R_CUBIC_TO, 1.45, 0, 2.65, 0.98, 2.98, 2.31,
R_ARC_TO, 2.45, 2.45, 0, 0, 1, 1.92, 0.01,
ARC_TO, 3.04, 3.04, 0, 0, 1, 13.94, 11,
CUBIC_TO, 15.63, 11, 17, 12.35, 17, 14,
R_CUBIC_TO, 0, 1.65, -1.37, 3, -3.06, 3,
CLOSE,
MOVE_TO, 14, 16,
R_ARC_TO, 2, 2, 0, 1, 0, 0, -4,
R_ARC_TO, 2, 2, 0, 0, 0, 0, 4,
CLOSE,
R_MOVE_TO, -8, 0,
R_ARC_TO, 2, 2, 0, 1, 0, 0, -4,
R_ARC_TO, 2, 2, 0, 0, 0, 0, 4,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kNewIncognitoWindowRepList, kNewIncognitoWindowIcon, {kNewIncognitoWindowPath})
VECTOR_ICON_REP_TEMPLATE(kNewTabPath, CANVAS_DIMENSIONS, 20,
MOVE_TO, 4, 2,
R_H_LINE_TO, 12,
R_ARC_TO, 2, 2, 0, 0, 1, 2, 2,
R_V_LINE_TO, 12,
R_ARC_TO, 2, 2, 0, 0, 1, -2, 2,
H_LINE_TO, 4,
R_ARC_TO, 2, 2, 0, 0, 1, -2, -2,
V_LINE_TO, 4,
R_ARC_TO, 2, 2, 0, 0, 1, 2, -2,
CLOSE,
R_MOVE_TO, 0, 2,
R_V_LINE_TO, 12,
R_H_LINE_TO, 12,
V_LINE_TO, 4,
H_LINE_TO, 4,
CLOSE,
R_MOVE_TO, 4, 0,
R_H_LINE_TO, 8,
R_V_LINE_TO, 4,
R_H_LINE_TO, -6,
R_ARC_TO, 2, 2, 0, 0, 1, -2, -2,
V_LINE_TO, 4,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kNewTabRepList, kNewTabIcon, {kNewTabPath})
VECTOR_ICON_REP_TEMPLATE(kNewWindowPath, CANVAS_DIMENSIONS, 20,
MOVE_TO, 15, 5,
R_H_LINE_TO, 3,
R_V_LINE_TO, 2,
R_H_LINE_TO, -3,
R_V_LINE_TO, 3,
R_H_LINE_TO, -2,
V_LINE_TO, 7,
R_H_LINE_TO, -3,
V_LINE_TO, 5,
R_H_LINE_TO, 3,
V_LINE_TO, 2,
R_H_LINE_TO, 2,
R_V_LINE_TO, 3,
CLOSE,
R_MOVE_TO, 1, 11,
R_V_LINE_TO, -4,
R_H_LINE_TO, 2,
R_V_LINE_TO, 4,
R_CUBIC_TO, 0, 1, -1, 2, -2, 2,
H_LINE_TO, 4,
R_CUBIC_TO, -1, 0, -2, -1, -2, -2,
V_LINE_TO, 4,
R_CUBIC_TO, 0, -1, 1, -2, 2, -2,
R_H_LINE_TO, 4,
R_V_LINE_TO, 2,
H_LINE_TO, 4,
R_V_LINE_TO, 12,
R_H_LINE_TO, 12,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kNewWindowRepList, kNewWindowIcon, {kNewWindowPath})
VECTOR_ICON_REP_TEMPLATE(kOpenPath, CANVAS_DIMENSIONS, 20,
MOVE_TO, 6, 4,
R_V_LINE_TO, 2,
R_H_LINE_TO, 6.5,
LINE_TO, 4, 14.5,
LINE_TO, 5.5, 16,
LINE_TO, 14, 7.5,
V_LINE_TO, 14,
R_H_LINE_TO, 2,
V_LINE_TO, 4,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kOpenRepList, kOpenIcon, {kOpenPath})
VECTOR_ICON_REP_TEMPLATE(kOptionsPath, CANVAS_DIMENSIONS, 20,
MOVE_TO, 14, 10,
R_ARC_TO, 2, 2, 0, 1, 1, 4, 0,
ARC_TO, 2, 2, 0, 0, 1, 14, 10,
CLOSE,
R_MOVE_TO, -2, 0,
R_ARC_TO, 2, 2, 0, 1, 1, -4, 0,
ARC_TO, 2, 2, 0, 0, 1, 12, 10,
CLOSE,
R_MOVE_TO, -6, 0,
R_ARC_TO, 2, 2, 0, 1, 1, -4, 0,
ARC_TO, 2, 2, 0, 0, 1, 6, 10,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kOptionsRepList, kOptionsIcon, {kOptionsPath})
VECTOR_ICON_REP_TEMPLATE(kPasswordChangePath, CANVAS_DIMENSIONS, 16,
FILL_RULE_NONZERO,
MOVE_TO, 12.36, 7.13,
CUBIC_TO, 12.35, 7.13, 12.35, 7.12, 12.35, 7.11,
CUBIC_TO, 12.35, 6.62, 12.25, 6.16, 12.06, 5.74,
CUBIC_TO, 11.88, 5.31, 11.63, 4.93, 11.31, 4.62,
CUBIC_TO, 10.99, 4.3, 10.62, 4.05, 10.19, 3.86,
CUBIC_TO, 9.76, 3.68, 9.3, 3.58, 8.82, 3.58,
CUBIC_TO, 8.81, 3.58, 8.8, 3.58, 8.8, 3.56,
CUBIC_TO, 8.8, 3.55, 8.81, 3.55, 8.82, 3.55,
CUBIC_TO, 9.31, 3.55, 9.77, 3.45, 10.19, 3.27,
CUBIC_TO, 10.62, 3.08, 10.99, 2.83, 11.31, 2.51,
CUBIC_TO, 11.63, 2.19, 11.88, 1.82, 12.06, 1.39,
CUBIC_TO, 12.25, 0.96, 12.35, 0.5, 12.35, 0.02,
CUBIC_TO, 12.35, 0.01, 12.35, 0, 12.36, 0,
CUBIC_TO, 12.38, 0, 12.38, 0.01, 12.38, 0.02,
CUBIC_TO, 12.38, 0.51, 12.47, 0.97, 12.65, 1.4,
CUBIC_TO, 12.84, 1.82, 13.1, 2.19, 13.42, 2.51,
CUBIC_TO, 13.73, 2.83, 14.11, 3.08, 14.54, 3.27,
CUBIC_TO, 14.97, 3.45, 15.42, 3.55, 15.91, 3.55,
CUBIC_TO, 15.92, 3.55, 15.93, 3.55, 15.93, 3.56,
CUBIC_TO, 15.93, 3.58, 15.92, 3.58, 15.91, 3.58,
CUBIC_TO, 15.42, 3.58, 14.96, 3.68, 14.53, 3.86,
CUBIC_TO, 14.1, 4.05, 13.73, 4.3, 13.42, 4.62,
CUBIC_TO, 13.1, 4.93, 12.84, 5.31, 12.65, 5.74,
CUBIC_TO, 12.47, 6.17, 12.38, 6.62, 12.38, 7.11,
CUBIC_TO, 12.38, 7.12, 12.38, 7.13, 12.36, 7.13,
CLOSE,
NEW_PATH,
FILL_RULE_NONZERO,
MOVE_TO, 5.42, 11.08,
CUBIC_TO, 5.13, 11.38, 4.78, 11.52, 4.36, 11.52,
CUBIC_TO, 3.95, 11.52, 3.6, 11.38, 3.31, 11.08,
CUBIC_TO, 3.02, 10.79, 2.87, 10.44, 2.87, 10.03,
CUBIC_TO, 2.87, 9.62, 3.02, 9.27, 3.31, 8.98,
CUBIC_TO, 3.6, 8.68, 3.95, 8.54, 4.36, 8.54,
CUBIC_TO, 4.78, 8.54, 5.13, 8.68, 5.42, 8.98,
CUBIC_TO, 5.71, 9.27, 5.85, 9.62, 5.85, 10.03,
CUBIC_TO, 5.85, 10.44, 5.71, 10.79, 5.42, 11.08,
CLOSE,
NEW_PATH,
MOVE_TO, 1.27, 13.12,
CUBIC_TO, 2.12, 13.97, 3.15, 14.39, 4.36, 14.39,
CUBIC_TO, 5.19, 14.39, 5.95, 14.19, 6.65, 13.78,
CUBIC_TO, 7.36, 13.35, 7.88, 12.77, 8.24, 12.03,
H_LINE_TO, 9.87,
V_LINE_TO, 12.98,
CUBIC_TO, 9.87, 13.36, 10.01, 13.7, 10.29, 13.98,
CUBIC_TO, 10.57, 14.25, 10.91, 14.39, 11.31, 14.39,
H_LINE_TO, 14.58,
CUBIC_TO, 14.97, 14.39, 15.3, 14.25, 15.58, 13.98,
CUBIC_TO, 15.86, 13.7, 16, 13.36, 16, 12.98,
V_LINE_TO, 9.45,
CUBIC_TO, 16, 9.06, 15.86, 8.73, 15.58, 8.45,
CUBIC_TO, 15.3, 8.17, 14.97, 8.03, 14.58, 8.03,
H_LINE_TO, 8.24,
CUBIC_TO, 7.87, 7.3, 7.34, 6.73, 6.64, 6.3,
CUBIC_TO, 5.95, 5.88, 5.19, 5.67, 4.36, 5.67,
CUBIC_TO, 3.15, 5.67, 2.12, 6.09, 1.27, 6.94,
CUBIC_TO, 0.42, 7.79, 0, 8.82, 0, 10.03,
CUBIC_TO, 0, 11.24, 0.42, 12.27, 1.27, 13.12,
CLOSE,
MOVE_TO, 11.31, 10.61,
H_LINE_TO, 7.25,
CUBIC_TO, 7.11, 11.3, 6.76, 11.87, 6.22, 12.32,
CUBIC_TO, 5.68, 12.76, 5.07, 12.98, 4.36, 12.98,
CUBIC_TO, 3.55, 12.98, 2.85, 12.69, 2.27, 12.12,
CUBIC_TO, 1.7, 11.54, 1.42, 10.84, 1.42, 10.03,
CUBIC_TO, 1.42, 9.22, 1.7, 8.53, 2.27, 7.96,
CUBIC_TO, 2.85, 7.38, 3.55, 7.08, 4.36, 7.08,
CUBIC_TO, 5.07, 7.08, 5.68, 7.31, 6.22, 7.76,
CUBIC_TO, 6.76, 8.19, 7.11, 8.76, 7.25, 9.45,
H_LINE_TO, 14.58,
V_LINE_TO, 12.98,
H_LINE_TO, 13.49,
V_LINE_TO, 12.05,
CUBIC_TO, 13.49, 11.89, 13.44, 11.76, 13.33, 11.67,
CUBIC_TO, 13.23, 11.56, 13.1, 11.5, 12.95, 11.5,
CUBIC_TO, 12.79, 11.5, 12.65, 11.56, 12.55, 11.67,
CUBIC_TO, 12.45, 11.76, 12.4, 11.89, 12.4, 12.05,
V_LINE_TO, 12.98,
H_LINE_TO, 11.31,
V_LINE_TO, 10.61,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kPasswordChangeRepList, kPasswordChangeIcon, {kPasswordChangePath})
VECTOR_ICON_REP_TEMPLATE(kPinPath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 7, 3,
R_V_LINE_TO, 2,
R_H_LINE_TO, 1,
R_V_LINE_TO, 7,
R_LINE_TO, -2, 2,
R_V_LINE_TO, 2,
R_H_LINE_TO, 5,
R_V_LINE_TO, 6,
R_LINE_TO, 1, 1,
R_LINE_TO, 1, -1,
R_V_LINE_TO, -6,
R_H_LINE_TO, 5,
R_V_LINE_TO, -2,
R_LINE_TO, -2, -2,
V_LINE_TO, 5,
R_H_LINE_TO, 1,
V_LINE_TO, 3,
CLOSE,
R_MOVE_TO, 3, 2,
R_H_LINE_TO, 4,
R_V_LINE_TO, 7.83,
LINE_TO, 15.17, 14,
R_H_LINE_TO, -6.34,
LINE_TO, 10, 12.83,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kPinRepList, kPinIcon, {kPinPath})
VECTOR_ICON_REP_TEMPLATE(kPsychiatryPath, CANVAS_DIMENSIONS, 12,
FILL_RULE_NONZERO,
MOVE_TO, 5.4, 11.6,
V_LINE_TO, 6.65,
H_LINE_TO, 5.25,
CUBIC_TO, 4.62, 6.65, 4.01, 6.53, 3.42, 6.3,
CUBIC_TO, 2.84, 6.06, 2.32, 5.71, 1.87, 5.27,
CUBIC_TO, 1.39, 4.81, 1.02, 4.28, 0.77, 3.68,
CUBIC_TO, 0.52, 3.08, 0.4, 2.46, 0.4, 1.8,
V_LINE_TO, 0.4,
H_LINE_TO, 1.8,
CUBIC_TO, 2.43, 0.4, 3.04, 0.52, 3.62, 0.77,
CUBIC_TO, 4.19, 1, 4.71, 1.34, 5.17, 1.78,
CUBIC_TO, 5.49, 2.09, 5.76, 2.44, 5.97, 2.83,
CUBIC_TO, 6.19, 3.21, 6.36, 3.61, 6.47, 4.03,
CUBIC_TO, 6.89, 3.44, 7.43, 2.99, 8.1, 2.68,
CUBIC_TO, 8.77, 2.36, 9.47, 2.2, 10.2, 2.2,
H_LINE_TO, 11.6,
V_LINE_TO, 3.6,
CUBIC_TO, 11.6, 4.26, 11.47, 4.88, 11.22, 5.48,
CUBIC_TO, 10.97, 6.08, 10.61, 6.61, 10.13, 7.07,
CUBIC_TO, 9.69, 7.46, 9.19, 7.76, 8.65, 7.97,
CUBIC_TO, 8.11, 8.18, 7.54, 8.28, 6.95, 8.28,
H_LINE_TO, 6.6,
V_LINE_TO, 11.6,
H_LINE_TO, 5.4,
CLOSE,
MOVE_TO, 5.4, 5.4,
CUBIC_TO, 5.4, 4.89, 5.31, 4.39, 5.13, 3.92,
CUBIC_TO, 4.97, 3.43, 4.71, 3.01, 4.35, 2.65,
CUBIC_TO, 3.99, 2.29, 3.57, 2.03, 3.08, 1.87,
CUBIC_TO, 2.61, 1.69, 2.11, 1.6, 1.6, 1.6,
CUBIC_TO, 1.6, 2.11, 1.68, 2.61, 1.85, 3.1,
CUBIC_TO, 2.03, 3.58, 2.29, 3.99, 2.65, 4.35,
CUBIC_TO, 3.01, 4.71, 3.42, 4.97, 3.9, 5.15,
CUBIC_TO, 4.39, 5.32, 4.89, 5.4, 5.4, 5.4,
CLOSE,
MOVE_TO, 6.6, 7.2,
CUBIC_TO, 7.11, 7.2, 7.61, 7.12, 8.08, 6.95,
CUBIC_TO, 8.57, 6.77, 8.99, 6.51, 9.35, 6.15,
CUBIC_TO, 9.71, 5.79, 9.97, 5.38, 10.13, 4.9,
CUBIC_TO, 10.31, 4.41, 10.4, 3.91, 10.4, 3.4,
CUBIC_TO, 9.89, 3.4, 9.39, 3.49, 8.9, 3.67,
CUBIC_TO, 8.42, 3.83, 8.01, 4.09, 7.65, 4.45,
CUBIC_TO, 7.29, 4.81, 7.03, 5.23, 6.85, 5.72,
CUBIC_TO, 6.68, 6.19, 6.6, 6.69, 6.6, 7.2,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kPsychiatryRepList, kPsychiatryIcon, {kPsychiatryPath})
VECTOR_ICON_REP_TEMPLATE(kRadioButtonActivePath, CANVAS_DIMENSIONS, 32,
CIRCLE, 16, 16, 14,
CIRCLE, 16, 16, 11,
CIRCLE, 16, 16, 7)
VECTOR_ICON_TEMPLATE_CC(kRadioButtonActiveRepList, kRadioButtonActiveIcon, {kRadioButtonActivePath})
VECTOR_ICON_REP_TEMPLATE(kRadioButtonNormalPath, CANVAS_DIMENSIONS, 32,
CIRCLE, 16, 16, 14,
CIRCLE, 16, 16, 11)
VECTOR_ICON_TEMPLATE_CC(kRadioButtonNormalRepList, kRadioButtonNormalIcon, {kRadioButtonNormalPath})
VECTOR_ICON_REP_TEMPLATE(kUninstallPath, CANVAS_DIMENSIONS, 20,
MOVE_TO, 13, 3,
V_LINE_TO, 2,
H_LINE_TO, 7,
R_V_LINE_TO, 1,
H_LINE_TO, 3,
R_V_LINE_TO, 2,
R_H_LINE_TO, 1,
R_V_LINE_TO, 11,
R_CUBIC_TO, 0, 1.1, 0.9, 2, 2, 2,
R_H_LINE_TO, 8,
R_CUBIC_TO, 1.1, 0, 2, -0.9, 2, -2,
V_LINE_TO, 5,
R_H_LINE_TO, 1,
V_LINE_TO, 3,
R_H_LINE_TO, -4,
CLOSE,
R_MOVE_TO, 1, 13,
H_LINE_TO, 6,
V_LINE_TO, 5,
R_H_LINE_TO, 8,
R_V_LINE_TO, 11,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kUninstallRepList, kUninstallIcon, {kUninstallPath})
VECTOR_ICON_REP_TEMPLATE(kUnpinPath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 7, 3,
R_H_LINE_TO, 10,
R_V_LINE_TO, 2,
R_H_LINE_TO, -1,
R_V_LINE_TO, 7,
R_LINE_TO, 2, 2,
R_V_LINE_TO, 2,
R_H_LINE_TO, -5,
R_V_LINE_TO, 6,
R_LINE_TO, -1, 1,
R_LINE_TO, -1, -1,
R_V_LINE_TO, -6,
H_LINE_TO, 6,
R_V_LINE_TO, -2,
R_LINE_TO, 2, -2,
V_LINE_TO, 5,
H_LINE_TO, 7,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kUnpinRepList, kUnpinIcon, {kUnpinPath})

}
