// ui/latency/mojom/latency_info.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_LATENCY_MOJOM_LATENCY_INFO_MOJOM_SHARED_H_
#define UI_LATENCY_MOJOM_LATENCY_INFO_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/latency/mojom/latency_info.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"




#include "ui/latency/mojom/latency_info.mojom-data-view.h"




namespace std {

template <>
struct hash<::ui::mojom::LatencyComponentType>
    : public mojo::internal::EnumHashImpl<::ui::mojom::LatencyComponentType> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ui::mojom::LatencyComponentType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ui::mojom::LatencyComponentType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::ui::mojom::LatencyComponentType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ui::mojom::LatencyInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::ui::mojom::LatencyInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::ui::mojom::internal::LatencyInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::latency_components(input)) in_latency_components = Traits::latency_components(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->latency_components)::BaseType>
        latency_components_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& latency_components_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayOfEnumsValidator<0, false, ::ui::mojom::internal::LatencyComponentType_Data::Validate>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::MapDataView<::ui::mojom::LatencyComponentType, ::mojo_base::mojom::TimeTicksDataView>>(
      in_latency_components,
      latency_components_fragment,
      &latency_components_validate_params);

    fragment->latency_components.Set(
        latency_components_fragment.is_null() ? nullptr : latency_components_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->latency_components.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null latency_components in LatencyInfo struct");

    fragment->trace_id = Traits::trace_id(input);

    fragment->coalesced = Traits::coalesced(input);

    fragment->began = Traits::began(input);

    fragment->terminated = Traits::terminated(input);

    fragment->gesture_scroll_id = Traits::gesture_scroll_id(input);

    fragment->touch_trace_id = Traits::touch_trace_id(input);
  }

  static bool Deserialize(::ui::mojom::internal::LatencyInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::ui::mojom::LatencyInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace ui::mojom {

inline void LatencyInfoDataView::GetLatencyComponentsDataView(
    mojo::MapDataView<LatencyComponentType, ::mojo_base::mojom::TimeTicksDataView>* output) {
  auto pointer = data_->latency_components.Get();
  *output = mojo::MapDataView<LatencyComponentType, ::mojo_base::mojom::TimeTicksDataView>(pointer, message_);
}



}  // ui::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::ui::mojom::LatencyComponentType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::ui::mojom::LatencyComponentType value);
};

} // namespace perfetto

#endif  // UI_LATENCY_MOJOM_LATENCY_INFO_MOJOM_SHARED_H_