// ui/latency/mojom/latency_info.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_LATENCY_MOJOM_LATENCY_INFO_MOJOM_SEND_VALIDATION_H_
#define UI_LATENCY_MOJOM_LATENCY_INFO_MOJOM_SEND_VALIDATION_H_

#include "ui/latency/mojom/latency_info.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"

#include "ui/latency/mojom/latency_info.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::ui::mojom::LatencyComponentType, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::ui::mojom::LatencyInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::ui::mojom::LatencyInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::ui::mojom::internal::LatencyInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::latency_components(input)) in_latency_components = Traits::latency_components(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->latency_components)::BaseType>
          latency_components_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& latency_components_validate_params =
          mojo::internal::GetMapValidator<*&mojo::internal::GetArrayOfEnumsValidator<0, false, ::ui::mojom::internal::LatencyComponentType_Data::Validate>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::MapDataView<::ui::mojom::LatencyComponentType, ::mojo_base::mojom::TimeTicksDataView>, send_validation>(
        in_latency_components,
        latency_components_fragment,
        &latency_components_validate_params);

      fragment->latency_components.Set(
          latency_components_fragment.is_null() ? nullptr : latency_components_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->latency_components.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null latency_components in LatencyInfo struct");

      fragment->trace_id = Traits::trace_id(input);

      fragment->coalesced = Traits::coalesced(input);

      fragment->began = Traits::began(input);

      fragment->terminated = Traits::terminated(input);

      fragment->gesture_scroll_id = Traits::gesture_scroll_id(input);

      fragment->touch_trace_id = Traits::touch_trace_id(input);
  }
};

}  // namespace mojo::internal

#endif  // UI_LATENCY_MOJOM_LATENCY_INFO_MOJOM_SEND_VALIDATION_H_