// ui/latency/mojom/latency_info.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_LATENCY_MOJOM_LATENCY_INFO_MOJOM_DATA_VIEW_H_
#define UI_LATENCY_MOJOM_LATENCY_INFO_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "ui/latency/mojom/latency_info.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"


namespace ui::mojom {
class LatencyInfoDataView;



}  // ui::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::ui::mojom::LatencyInfoDataView> {
  using Data = ::ui::mojom::internal::LatencyInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace ui::mojom {


enum class LatencyComponentType : int32_t {
  
  INPUT_EVENT_LATENCY_BEGIN_RWH_COMPONENT = 0,
  
  INPUT_EVENT_LATENCY_SCROLL_UPDATE_ORIGINAL_COMPONENT = 1,
  
  INPUT_EVENT_LATENCY_FIRST_SCROLL_UPDATE_ORIGINAL_COMPONENT = 2,
  
  INPUT_EVENT_LATENCY_ORIGINAL_COMPONENT = 3,
  
  INPUT_EVENT_LATENCY_UI_COMPONENT = 4,
  
  INPUT_EVENT_LATENCY_RENDERER_MAIN_COMPONENT = 5,
  
  INPUT_EVENT_LATENCY_RENDERING_SCHEDULED_MAIN_COMPONENT = 6,
  
  INPUT_EVENT_LATENCY_RENDERING_SCHEDULED_IMPL_COMPONENT = 7,
  
  INPUT_EVENT_LATENCY_RENDERER_SWAP_COMPONENT = 8,
  
  DISPLAY_COMPOSITOR_RECEIVED_FRAME_COMPONENT = 9,
  
  INPUT_EVENT_GPU_SWAP_BUFFER_COMPONENT = 10,
  
  INPUT_EVENT_LATENCY_FRAME_SWAP_COMPONENT = 11,
  kMinValue = 0,
  kMaxValue = 11,
};

 std::ostream& operator<<(std::ostream& os, LatencyComponentType value);
inline bool IsKnownEnumValue(LatencyComponentType value) {
  return internal::LatencyComponentType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class LatencyInfoDataView {
 public:
  LatencyInfoDataView() = default;

  LatencyInfoDataView(
      internal::LatencyInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetLatencyComponentsDataView(
      mojo::MapDataView<LatencyComponentType, ::mojo_base::mojom::TimeTicksDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLatencyComponents(UserType* output) {
    
    auto* pointer = data_->latency_components.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::ui::mojom::LatencyComponentType, ::mojo_base::mojom::TimeTicksDataView>>(
        pointer, output, message_);
  }
  int64_t trace_id() const {
    return data_->trace_id;
  }
  bool coalesced() const {
    return data_->coalesced;
  }
  bool began() const {
    return data_->began;
  }
  bool terminated() const {
    return data_->terminated;
  }
  int64_t gesture_scroll_id() const {
    return data_->gesture_scroll_id;
  }
  int64_t touch_trace_id() const {
    return data_->touch_trace_id;
  }
 private:
  internal::LatencyInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // ui::mojom

#endif  // UI_LATENCY_MOJOM_LATENCY_INFO_MOJOM_DATA_VIEW_H_