// ui/gl/mojom/gl_implementation.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "ui/gl/mojom/gl_implementation.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "ui/gl/mojom/gl_implementation.mojom-params-data.h"
namespace gl {
namespace mojom {

NOINLINE static const char* GLImplementationToStringHelper(GLImplementation value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case GLImplementation::kGLImplementationNone:
      return "kGLImplementationNone";
    case GLImplementation::kGLImplementationEGLGLES2:
      return "kGLImplementationEGLGLES2";
    case GLImplementation::kGLImplementationMockGL:
      return "kGLImplementationMockGL";
    case GLImplementation::kGLImplementationStubGL:
      return "kGLImplementationStubGL";
    case GLImplementation::kGLImplementationDisabled:
      return "kGLImplementationDisabled";
    case GLImplementation::kGLImplementationEGLANGLE:
      return "kGLImplementationEGLANGLE";
    default:
      return nullptr;
  }
}

std::string GLImplementationToString(GLImplementation value) {
  const char *str = GLImplementationToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown GLImplementation value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, GLImplementation value) {
  return os << GLImplementationToString(value);
}

NOINLINE static const char* ANGLEImplementationToStringHelper(ANGLEImplementation value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ANGLEImplementation::kNone:
      return "kNone";
    case ANGLEImplementation::kD3D9:
      return "kD3D9";
    case ANGLEImplementation::kD3D11:
      return "kD3D11";
    case ANGLEImplementation::kOpenGL:
      return "kOpenGL";
    case ANGLEImplementation::kOpenGLES:
      return "kOpenGLES";
    case ANGLEImplementation::kNull:
      return "kNull";
    case ANGLEImplementation::kVulkan:
      return "kVulkan";
    case ANGLEImplementation::kSwiftShader:
      return "kSwiftShader";
    case ANGLEImplementation::kMetal:
      return "kMetal";
    case ANGLEImplementation::kD3D11Warp:
      return "kD3D11Warp";
    case ANGLEImplementation::kDefault:
      return "kDefault";
    default:
      return nullptr;
  }
}

std::string ANGLEImplementationToString(ANGLEImplementation value) {
  const char *str = ANGLEImplementationToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ANGLEImplementation value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ANGLEImplementation value) {
  return os << ANGLEImplementationToString(value);
}

namespace internal {


// static
bool GLImplementationParts_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GLImplementationParts_Data* object =
      static_cast<const GLImplementationParts_Data*>(data);


  if (!::gl::mojom::internal::GLImplementation_Data
        ::Validate(object->gl, validation_context))
    return false;


  if (!::gl::mojom::internal::ANGLEImplementation_Data
        ::Validate(object->angle, validation_context))
    return false;

  return true;
}

GLImplementationParts_Data::GLImplementationParts_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace gl

namespace perfetto {

// static
void TraceFormatTraits<::gl::mojom::GLImplementation>::WriteIntoTrace(
   perfetto::TracedValue context, ::gl::mojom::GLImplementation value) {
  return std::move(context).WriteString(::gl::mojom::GLImplementationToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::gl::mojom::ANGLEImplementation>::WriteIntoTrace(
   perfetto::TracedValue context, ::gl::mojom::ANGLEImplementation value) {
  return std::move(context).WriteString(::gl::mojom::ANGLEImplementationToString(value));
}

} // namespace perfetto