// ui/gl/mojom/gl_implementation.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_GL_MOJOM_GL_IMPLEMENTATION_MOJOM_DATA_VIEW_H_
#define UI_GL_MOJOM_GL_IMPLEMENTATION_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "ui/gl/mojom/gl_implementation.mojom-shared-internal.h"


namespace gl::mojom {
class GLImplementationPartsDataView;



}  // gl::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::gl::mojom::GLImplementationPartsDataView> {
  using Data = ::gl::mojom::internal::GLImplementationParts_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace gl::mojom {


enum class GLImplementation : int32_t {
  
  kGLImplementationNone = 0,
  
  kGLImplementationEGLGLES2 = 1,
  
  kGLImplementationMockGL = 2,
  
  kGLImplementationStubGL = 3,
  
  kGLImplementationDisabled = 4,
  
  kGLImplementationEGLANGLE = 5,
  kMinValue = 0,
  kMaxValue = 5,
};

COMPONENT_EXPORT(GL_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, GLImplementation value);
inline bool IsKnownEnumValue(GLImplementation value) {
  return internal::GLImplementation_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ANGLEImplementation : int32_t {
  
  kNone = 0,
  
  kD3D9 = 1,
  
  kD3D11 = 2,
  
  kOpenGL = 3,
  
  kOpenGLES = 4,
  
  kNull = 5,
  
  kVulkan = 6,
  
  kSwiftShader = 7,
  
  kMetal = 8,
  
  kD3D11Warp = 9,
  
  kDefault = 10,
  kMinValue = 0,
  kMaxValue = 10,
};

COMPONENT_EXPORT(GL_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, ANGLEImplementation value);
inline bool IsKnownEnumValue(ANGLEImplementation value) {
  return internal::ANGLEImplementation_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class GLImplementationPartsDataView {
 public:
  GLImplementationPartsDataView() = default;

  GLImplementationPartsDataView(
      internal::GLImplementationParts_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadGl(UserType* output) const {
    auto data_value = data_->gl;
    return mojo::internal::Deserialize<::gl::mojom::GLImplementation>(
        data_value, output);
  }
  GLImplementation gl() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::gl::mojom::GLImplementation>(data_->gl));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadAngle(UserType* output) const {
    auto data_value = data_->angle;
    return mojo::internal::Deserialize<::gl::mojom::ANGLEImplementation>(
        data_value, output);
  }
  ANGLEImplementation angle() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::gl::mojom::ANGLEImplementation>(data_->angle));
  }
 private:
  internal::GLImplementationParts_Data* data_ = nullptr;
};


}  // gl::mojom

#endif  // UI_GL_MOJOM_GL_IMPLEMENTATION_MOJOM_DATA_VIEW_H_