// ui/gfx/mojom/transform.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'ui/gfx/mojom/transform.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('gfx.mojom');
  var geometry$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/geometry/mojom/geometry.mojom', '../geometry/mojom/geometry.mojom.js');
  }



  function Transform(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Transform.prototype.initDefaults_ = function() {
    this.data = null;
  };
  Transform.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Transform.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Transform.data
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, TransformData, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Transform.encodedSize = codec.kStructHeaderSize + 16;

  Transform.decode = function(decoder) {
    var packed;
    var val = new Transform();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.data =
        decoder.decodeStruct(TransformData);
    return val;
  };

  Transform.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Transform.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(TransformData, val.data);
  };

  function TransformData(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  TransformData.Tags = {
    axis2d: 0,
    matrix: 1,
  };

  TransformData.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  TransformData.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "axis2d",
        "matrix",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a TransformData member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(TransformData.prototype, "axis2d", {
    get: function() {
      if (this.$tag != TransformData.Tags.axis2d) {
        throw new ReferenceError(
            "TransformData.axis2d is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = TransformData.Tags.axis2d;
      this.$data = value;
    }
  });
  Object.defineProperty(TransformData.prototype, "matrix", {
    get: function() {
      if (this.$tag != TransformData.Tags.matrix) {
        throw new ReferenceError(
            "TransformData.matrix is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = TransformData.Tags.matrix;
      this.$data = value;
    }
  });


    TransformData.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case TransformData.Tags.axis2d:
          encoder.encodeStructPointer(geometry$.AxisTransform2d, val.axis2d);
          break;
        case TransformData.Tags.matrix:
          encoder.encodeArrayPointer(codec.Double, val.matrix);
          break;
      }
      encoder.align();
    };


    TransformData.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new TransformData();
      var tag = decoder.readUint32();
      switch (tag) {
        case TransformData.Tags.axis2d:
          result.axis2d = decoder.decodeStructPointer(geometry$.AxisTransform2d);
          break;
        case TransformData.Tags.matrix:
          result.matrix = decoder.decodeArrayPointer(codec.Double);
          break;
      }
      decoder.align();

      return result;
    };


    TransformData.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case TransformData.Tags.axis2d:
          

    // validate TransformData.axis2d
    err = messageValidator.validateStructPointer(data_offset, geometry$.AxisTransform2d, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case TransformData.Tags.matrix:
          

    // validate TransformData.matrix
    err = messageValidator.validateArrayPointer(data_offset, 8, codec.Double, false, [16], 0);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  TransformData.encodedSize = 16;
  exports.Transform = Transform;
  exports.TransformData = TransformData;
})();