// ui/gfx/mojom/transform.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_GFX_MOJOM_TRANSFORM_MOJOM_H_
#define UI_GFX_MOJOM_TRANSFORM_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/gfx/mojom/transform.mojom-features.h"  // IWYU pragma: export
#include "ui/gfx/mojom/transform.mojom-shared.h"  // IWYU pragma: export
#include "ui/gfx/mojom/transform.mojom-forward.h"  // IWYU pragma: export
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include <string>
#include <vector>




#include "ui/gfx/mojom/transform_mojom_traits.h"




namespace gfx::mojom {






class  TransformData {
 public:
  using DataView = TransformDataDataView;
  using Data_ = internal::TransformData_Data;
  using Tag = Data_::TransformData_Tag;

  template <typename... Args>
  static TransformDataPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |axis_2d|.
  static TransformDataPtr NewAxis2d(
      const ::gfx::AxisTransform2d& value);
  // Construct an instance holding |matrix|.
  static TransformDataPtr NewMatrix(
      std::vector<double> value);

  template <typename U>
  static TransformDataPtr From(const U& u) {
    return mojo::TypeConverter<TransformDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TransformData>::Convert(*this);
  }
  ~TransformData();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  TransformData(const TransformData& other) = delete;
  TransformData& operator=(const TransformData& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = TransformDataPtr>
  TransformDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, TransformData>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, TransformData>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_axis_2d() const { return tag_ == Tag::kAxis2d; }
  const ::gfx::AxisTransform2d& get_axis_2d() const {
    CHECK(tag_ == Tag::kAxis2d);
    return data_.axis_2d;
  }
  ::gfx::AxisTransform2d& get_axis_2d() {
    CHECK(tag_ == Tag::kAxis2d);
    return data_.axis_2d;
  }
  void set_axis_2d(const ::gfx::AxisTransform2d& axis_2d);

  bool is_matrix() const { return tag_ == Tag::kMatrix; }
  const std::vector<double>& get_matrix() const {
    CHECK(tag_ == Tag::kMatrix);
    return data_.matrix;
  }
  std::vector<double>& get_matrix() {
    CHECK(tag_ == Tag::kMatrix);
    return data_.matrix;
  }
  void set_matrix(std::vector<double> matrix);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TransformData::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<TransformData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kAxis2d)>,
        const ::gfx::AxisTransform2d& value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kMatrix)>,
        std::vector<double> value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    ::gfx::AxisTransform2d axis_2d;
    std::vector<double> matrix;
  };

  TransformData(
      std::in_place_index_t<static_cast<size_t>(Tag::kAxis2d)>,
      const ::gfx::AxisTransform2d& value);
  TransformData(
      std::in_place_index_t<static_cast<size_t>(Tag::kMatrix)>,
      std::vector<double> value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class  Transform {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Transform, T>::value>;
  using DataView = TransformDataView;
  using Data_ = internal::Transform_Data;

  template <typename... Args>
  static TransformPtr New(Args&&... args) {
    return TransformPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TransformPtr From(const U& u) {
    return mojo::TypeConverter<TransformPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Transform>::Convert(*this);
  }


  Transform();

  explicit Transform(
      TransformDataPtr data);

Transform(const Transform&) = delete;
Transform& operator=(const Transform&) = delete;

  ~Transform();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TransformPtr>
  TransformPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Transform::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Transform::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Transform::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Transform::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Transform::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Transform::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Transform_UnserializedMessageContext<
            UserType, Transform::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Transform::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Transform::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Transform_UnserializedMessageContext<
            UserType, Transform::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Transform::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  TransformDataPtr data;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Transform::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Transform::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Transform::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Transform::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
TransformDataPtr TransformData::Clone() const {
  switch (tag_) {
    case Tag::kAxis2d:
      return NewAxis2d(
          mojo::Clone(data_.axis_2d));
    case Tag::kMatrix:
      return NewMatrix(
          mojo::Clone(data_.matrix));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, TransformData>::value>::type*>
bool TransformData::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kAxis2d:
      return mojo::Equals(data_.axis_2d, other.data_.axis_2d);
    case Tag::kMatrix:
      return mojo::Equals(data_.matrix, other.data_.matrix);
  }

  return false;
}
template <typename StructPtrType>
TransformPtr Transform::Clone() const {
  return New(
      mojo::Clone(data)
  );
}

template <typename T, Transform::EnableIfSame<T>*>
bool Transform::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->data, other_struct.data))
    return false;
  return true;
}

template <typename T, Transform::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.data < rhs.data)
    return true;
  if (rhs.data < lhs.data)
    return false;
  return false;
}


}  // gfx::mojom

namespace mojo {


template <>
struct  StructTraits<::gfx::mojom::Transform::DataView,
                                         ::gfx::mojom::TransformPtr> {
  static bool IsNull(const ::gfx::mojom::TransformPtr& input) { return !input; }
  static void SetToNull(::gfx::mojom::TransformPtr* output) { output->reset(); }

  static const decltype(::gfx::mojom::Transform::data)& data(
      const ::gfx::mojom::TransformPtr& input) {
    return input->data;
  }

  static bool Read(::gfx::mojom::Transform::DataView input, ::gfx::mojom::TransformPtr* output);
};


template <>
struct  UnionTraits<::gfx::mojom::TransformData::DataView,
                                        ::gfx::mojom::TransformDataPtr> {
  static bool IsNull(const ::gfx::mojom::TransformDataPtr& input) { return !input; }
  static void SetToNull(::gfx::mojom::TransformDataPtr* output) { output->reset(); }

  static ::gfx::mojom::TransformData::Tag GetTag(const ::gfx::mojom::TransformDataPtr& input) {
    return input->which();
  }

  static const ::gfx::AxisTransform2d& axis_2d(const ::gfx::mojom::TransformDataPtr& input) {
    return input->get_axis_2d();
  }

  static const std::vector<double>& matrix(const ::gfx::mojom::TransformDataPtr& input) {
    return input->get_matrix();
  }

  static bool Read(::gfx::mojom::TransformData::DataView input, ::gfx::mojom::TransformDataPtr* output);
};

}  // namespace mojo

#endif  // UI_GFX_MOJOM_TRANSFORM_MOJOM_H_