// ui/gfx/mojom/transform.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "ui/gfx/mojom/transform.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "ui/gfx/mojom/transform.mojom-params-data.h"
#include "ui/gfx/mojom/transform.mojom-shared-message-ids.h"

#include "ui/gfx/mojom/transform.mojom-import-headers.h"
#include "ui/gfx/mojom/transform.mojom-test-utils.h"


namespace gfx::mojom {
Transform::Transform()
    : data() {}

Transform::Transform(
    TransformDataPtr data_in)
    : data(std::move(data_in)) {}

Transform::~Transform() = default;

void Transform::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "data"), this->data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type TransformDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Transform::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
TransformDataPtr
TransformData::NewAxis2d(
    const ::gfx::AxisTransform2d& value) {
  return TransformDataPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kAxis2d)>,
      std::move(value));
}

TransformDataPtr
TransformData::NewMatrix(
    std::vector<double> value) {
  return TransformDataPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kMatrix)>,
      std::move(value));
}

TransformData::TransformData(
    std::in_place_index_t<static_cast<size_t>(Tag::kAxis2d)>,
    const ::gfx::AxisTransform2d& value)
    : tag_(Tag::kAxis2d),
      data_(std::in_place_index<static_cast<size_t>(Tag::kAxis2d)>,
            std::move(value)) {}

TransformData::TransformData(
    std::in_place_index_t<static_cast<size_t>(Tag::kMatrix)>,
    std::vector<double> value)
    : tag_(Tag::kMatrix),
      data_(std::in_place_index<static_cast<size_t>(Tag::kMatrix)>,
            std::move(value)) {}
TransformData::~TransformData() {
  DestroyActive();
}

void TransformData::set_axis_2d(const ::gfx::AxisTransform2d& axis_2d) {
  if (tag_ == Tag::kAxis2d) {
    data_.axis_2d = std::move(axis_2d);
  } else {
    DestroyActive();
    tag_ = Tag::kAxis2d;
    new (&data_.axis_2d) ::gfx::AxisTransform2d(
        std::move(axis_2d));
  }
}

void TransformData::set_matrix(std::vector<double> matrix) {
  if (tag_ == Tag::kMatrix) {
    data_.matrix = std::move(matrix);
  } else {
    DestroyActive();
    tag_ = Tag::kMatrix;
    new (&data_.matrix) std::vector<double>(
        std::move(matrix));
  }
}


TransformData::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kAxis2d)>,
    const ::gfx::AxisTransform2d& value)
    : axis_2d(std::move(value)) {}

TransformData::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kMatrix)>,
    std::vector<double> value)
    : matrix(std::move(value)) {}

void TransformData::DestroyActive() {
  switch (tag_) {

    case Tag::kAxis2d:
      std::destroy_at(&data_.axis_2d);
      break;
    case Tag::kMatrix:
      std::destroy_at(&data_.matrix);
      break;
  }
}

bool TransformData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}


}  // gfx::mojom


namespace mojo {


// static
bool StructTraits<::gfx::mojom::Transform::DataView, ::gfx::mojom::TransformPtr>::Read(
    ::gfx::mojom::Transform::DataView input,
    ::gfx::mojom::TransformPtr* output) {
  bool success = true;
  ::gfx::mojom::TransformPtr result(::gfx::mojom::Transform::New());
  
      if (success && !input.ReadData(&result->data))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::gfx::mojom::TransformData::DataView, ::gfx::mojom::TransformDataPtr>::Read(
    ::gfx::mojom::TransformData::DataView input,
    ::gfx::mojom::TransformDataPtr* output) {
  using UnionType = ::gfx::mojom::TransformData;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kAxis2d: {
      ::gfx::AxisTransform2d result_axis_2d{};
      if (!input.ReadAxis2d(&result_axis_2d))
        return false;

      *output = UnionType::NewAxis2d(
          std::move(result_axis_2d));
      break;
    }
    case Tag::kMatrix: {
      std::vector<double> result_matrix{};
      if (!input.ReadMatrix(&result_matrix))
        return false;

      *output = UnionType::NewMatrix(
          std::move(result_matrix));
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace gfx::mojom {




}  // gfx::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif