// ui/gfx/mojom/transform.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_GFX_MOJOM_TRANSFORM_MOJOM_SHARED_H_
#define UI_GFX_MOJOM_TRANSFORM_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/gfx/mojom/transform.mojom-shared-internal.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"




#include "ui/gfx/mojom/transform.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gfx::mojom::TransformDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gfx::mojom::TransformDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gfx::mojom::internal::Transform_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::data(input)) in_data = Traits::data(input);
    mojo::internal::MessageFragment<decltype(fragment->data)>
        data_fragment(fragment.message());
    data_fragment.Claim(&fragment->data);
    
    mojo::internal::Serialize<::gfx::mojom::TransformDataDataView>(
      in_data,
      data_fragment,
      true);
  }

  static bool Deserialize(::gfx::mojom::internal::Transform_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gfx::mojom::TransformDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gfx::mojom::TransformDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::gfx::mojom::TransformDataDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::gfx::mojom::internal::TransformData_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::gfx::mojom::TransformDataDataView::Tag::kAxis2d: {
    decltype(Traits::axis_2d(input))
    in_axis_2d = Traits::axis_2d(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_axis_2d)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::gfx::mojom::AxisTransform2dDataView>(
  in_axis_2d,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null axis_2d in TransformData union");
    fragment->data.f_axis_2d.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::gfx::mojom::TransformDataDataView::Tag::kMatrix: {
    decltype(Traits::matrix(input))
    in_matrix = Traits::matrix(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_matrix)::BaseType>
    value_fragment(fragment.message());
        constexpr const mojo::internal::ContainerValidateParams& matrix_validate_params =
            mojo::internal::GetArrayValidator<16, false, nullptr>();
        
mojo::internal::Serialize<mojo::ArrayDataView<double>>(
  in_matrix,
  value_fragment,
  &matrix_validate_params);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null matrix in TransformData union");
    fragment->data.f_matrix.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::gfx::mojom::internal::TransformData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::gfx::mojom::TransformDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace gfx::mojom {

inline void TransformDataView::GetDataDataView(
    TransformDataDataView* output) {
  auto pointer = &data_->data;
  *output = TransformDataDataView(pointer, message_);
}


inline void TransformDataDataView::GetAxis2dDataView(
    ::gfx::mojom::AxisTransform2dDataView* output) const {
  CHECK(is_axis_2d());
  *output = ::gfx::mojom::AxisTransform2dDataView(data_->data.f_axis_2d.Get(), message_);
}
inline void TransformDataDataView::GetMatrixDataView(
    mojo::ArrayDataView<double>* output) const {
  CHECK(is_matrix());
  *output = mojo::ArrayDataView<double>(data_->data.f_matrix.Get(), message_);
}


}  // gfx::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // UI_GFX_MOJOM_TRANSFORM_MOJOM_SHARED_H_