// ui/gfx/mojom/transform.mojom-shared-internal.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_GFX_MOJOM_TRANSFORM_MOJOM_SHARED_INTERNAL_H_
#define UI_GFX_MOJOM_TRANSFORM_MOJOM_SHARED_INTERNAL_H_
#include "mojo/public/cpp/bindings/lib/array_internal.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/map_data_internal.h"
#include "mojo/public/cpp/bindings/lib/message_fragment.h"
#include "mojo/public/c/system/macros.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/native_enum_data.h"
#include "mojo/public/interfaces/bindings/native_struct.mojom-shared-internal.h"



namespace mojo {
namespace internal {
class ValidationContext;
}
}


namespace gfx::mojom {
namespace internal {
class Transform_Data;
class TransformData_Data;

#pragma pack(push, 1)


class  TransformData_Data {
 public:
  // Used to identify Mojom Union Data Classes.
  typedef void MojomUnionDataType;

  TransformData_Data() = default;
  // Do nothing in the destructor since it won't be called when it is a
  // non-inlined union.
  ~TransformData_Data() = default;

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context,
                       bool inlined);

  bool is_null() const { return size == 0; }

  void set_null() {
    size = 0U;
    tag = static_cast<TransformData_Tag>(0);
    data.unknown = 0U;
  }

  // TODO(crbug.com/40731316): SHOUTY_CASE values are being deprecated per C++ code style
  // guidelines (https://google.github.io/styleguide/cppguide.html#Enumerator_Names),
  // please use kCamelCase values instead.  Cleanup NULL_VALUE, BOOL_VALUE, INT_VALUE, etc.
  // generation once codebase is transitioned to kNullValue, kBoolValue, kIntValue, etc.
  enum class TransformData_Tag : uint32_t {

    
    kAxis2d,
    
    kMatrix,
  };

  // A note on layout:
  // "Each non-static data member is allocated as if it were the sole member of
  // a struct." - Section 9.5.2 ISO/IEC 14882:2011 (The C++ Spec)
  union MOJO_ALIGNAS(8) Union_ {
    Union_() : unknown(0) {}
    mojo::internal::Pointer<::gfx::mojom::internal::AxisTransform2d_Data> f_axis_2d;
    mojo::internal::Pointer<mojo::internal::Array_Data<double>> f_matrix;
    uint64_t unknown;
  };

  uint32_t size;
  TransformData_Tag tag;
  Union_ data;
};
static_assert(sizeof(TransformData_Data) == mojo::internal::kUnionDataSize,
              "Bad sizeof(TransformData_Data)");
class  Transform_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  internal::TransformData_Data data;

 private:
  friend class mojo::internal::MessageFragment<Transform_Data>;

  Transform_Data();
  ~Transform_Data() = delete;
};
static_assert(sizeof(Transform_Data) == 24,
              "Bad sizeof(Transform_Data)");
// Used by Transform::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct Transform_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  Transform_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~Transform_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<Transform_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    Transform_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};

#pragma pack(pop)

}  // namespace internal

}  // gfx::mojom

#endif  // UI_GFX_MOJOM_TRANSFORM_MOJOM_SHARED_INTERNAL_H_