// ui/gfx/mojom/transform.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_GFX_MOJOM_TRANSFORM_MOJOM_SEND_VALIDATION_H_
#define UI_GFX_MOJOM_TRANSFORM_MOJOM_SEND_VALIDATION_H_

#include "ui/gfx/mojom/transform.mojom-shared-internal.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"

#include "ui/gfx/mojom/transform.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::gfx::mojom::TransformDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gfx::mojom::TransformDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gfx::mojom::internal::Transform_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::data(input)) in_data = Traits::data(input);
      mojo::internal::MessageFragment<decltype(fragment->data)>
          data_fragment(fragment.message());
      data_fragment.Claim(&fragment->data);
      
      mojo::internal::Serialize<::gfx::mojom::TransformDataDataView, send_validation>(
        in_data,
        data_fragment,
        true);
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::gfx::mojom::TransformDataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::gfx::mojom::TransformDataDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::gfx::mojom::internal::TransformData_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::gfx::mojom::TransformDataDataView::Tag::kAxis2d: {
    decltype(Traits::axis_2d(input))
    in_axis_2d = Traits::axis_2d(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_axis_2d)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::gfx::mojom::AxisTransform2dDataView, send_validation>(
  in_axis_2d,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null axis_2d in TransformData union");
    fragment->data.f_axis_2d.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::gfx::mojom::TransformDataDataView::Tag::kMatrix: {
    decltype(Traits::matrix(input))
    in_matrix = Traits::matrix(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_matrix)::BaseType>
    value_fragment(fragment.message());
        constexpr const mojo::internal::ContainerValidateParams& matrix_validate_params =
            mojo::internal::GetArrayValidator<16, false, nullptr>();
        
mojo::internal::Serialize<mojo::ArrayDataView<double>, send_validation>(
  in_matrix,
  value_fragment,
  &matrix_validate_params);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null matrix in TransformData union");
    fragment->data.f_matrix.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }
};

}  // namespace mojo::internal

#endif  // UI_GFX_MOJOM_TRANSFORM_MOJOM_SEND_VALIDATION_H_