// ui/gfx/mojom/transform.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_GFX_MOJOM_TRANSFORM_MOJOM_DATA_VIEW_H_
#define UI_GFX_MOJOM_TRANSFORM_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "ui/gfx/mojom/transform.mojom-shared-internal.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"


namespace gfx::mojom {
class TransformDataView;

class TransformDataDataView;


}  // gfx::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::gfx::mojom::TransformDataView> {
  using Data = ::gfx::mojom::internal::Transform_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::gfx::mojom::TransformDataDataView> {
  using Data = ::gfx::mojom::internal::TransformData_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace gfx::mojom {


class TransformDataView {
 public:
  TransformDataView() = default;

  TransformDataView(
      internal::Transform_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDataDataView(
      TransformDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gfx::mojom::TransformDataDataView, UserType>(),
    "Attempting to read the optional `data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadData` instead "
    "of `ReadData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->data.is_null() ? &data_->data : nullptr;
    return mojo::internal::Deserialize<::gfx::mojom::TransformDataDataView>(
        pointer, output, message_);
  }
 private:
  internal::Transform_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TransformDataDataView {
 public:
  using Tag = internal::TransformData_Data::TransformData_Tag;

  TransformDataDataView() = default;

  TransformDataDataView(
      internal::TransformData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_axis_2d() const { return data_->tag == Tag::kAxis2d; }
  inline void GetAxis2dDataView(
      ::gfx::mojom::AxisTransform2dDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadAxis2d(UserType* output) const {
    
    CHECK(is_axis_2d());
    return mojo::internal::Deserialize<::gfx::mojom::AxisTransform2dDataView>(
        data_->data.f_axis_2d.Get(), output, message_);
  }
  bool is_matrix() const { return data_->tag == Tag::kMatrix; }
  inline void GetMatrixDataView(
      mojo::ArrayDataView<double>* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadMatrix(UserType* output) const {
    
    CHECK(is_matrix());
    return mojo::internal::Deserialize<mojo::ArrayDataView<double>>(
        data_->data.f_matrix.Get(), output, message_);
  }

 private:
  internal::TransformData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // gfx::mojom

#endif  // UI_GFX_MOJOM_TRANSFORM_MOJOM_DATA_VIEW_H_