// ui/gfx/mojom/swap_timings.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_GFX_MOJOM_SWAP_TIMINGS_MOJOM_H_
#define UI_GFX_MOJOM_SWAP_TIMINGS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/gfx/mojom/swap_timings.mojom-features.h"  // IWYU pragma: export
#include "ui/gfx/mojom/swap_timings.mojom-shared.h"  // IWYU pragma: export
#include "ui/gfx/mojom/swap_timings.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/time.mojom.h"
#include <string>
#include <vector>




#include "ui/gfx/mojom/swap_timings_mojom_traits.h"




namespace gfx::mojom {








class  SwapTimings {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SwapTimings, T>::value>;
  using DataView = SwapTimingsDataView;
  using Data_ = internal::SwapTimings_Data;

  template <typename... Args>
  static SwapTimingsPtr New(Args&&... args) {
    return SwapTimingsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SwapTimingsPtr From(const U& u) {
    return mojo::TypeConverter<SwapTimingsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SwapTimings>::Convert(*this);
  }


  SwapTimings();

  SwapTimings(
      ::base::TimeTicks swap_start,
      ::base::TimeTicks swap_end);


  ~SwapTimings();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SwapTimingsPtr>
  SwapTimingsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SwapTimings::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SwapTimings::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SwapTimings::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SwapTimings::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SwapTimings::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SwapTimings::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SwapTimings_UnserializedMessageContext<
            UserType, SwapTimings::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SwapTimings::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SwapTimings::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SwapTimings_UnserializedMessageContext<
            UserType, SwapTimings::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SwapTimings::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::TimeTicks swap_start;
  
  ::base::TimeTicks swap_end;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SwapTimings::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SwapTimings::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SwapTimings::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SwapTimings::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
SwapTimingsPtr SwapTimings::Clone() const {
  return New(
      mojo::Clone(swap_start),
      mojo::Clone(swap_end)
  );
}

template <typename T, SwapTimings::EnableIfSame<T>*>
bool SwapTimings::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->swap_start, other_struct.swap_start))
    return false;
  if (!mojo::Equals(this->swap_end, other_struct.swap_end))
    return false;
  return true;
}

template <typename T, SwapTimings::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.swap_start < rhs.swap_start)
    return true;
  if (rhs.swap_start < lhs.swap_start)
    return false;
  if (lhs.swap_end < rhs.swap_end)
    return true;
  if (rhs.swap_end < lhs.swap_end)
    return false;
  return false;
}


}  // gfx::mojom

namespace mojo {


template <>
struct  StructTraits<::gfx::mojom::SwapTimings::DataView,
                                         ::gfx::mojom::SwapTimingsPtr> {
  static bool IsNull(const ::gfx::mojom::SwapTimingsPtr& input) { return !input; }
  static void SetToNull(::gfx::mojom::SwapTimingsPtr* output) { output->reset(); }

  static const decltype(::gfx::mojom::SwapTimings::swap_start)& swap_start(
      const ::gfx::mojom::SwapTimingsPtr& input) {
    return input->swap_start;
  }

  static const decltype(::gfx::mojom::SwapTimings::swap_end)& swap_end(
      const ::gfx::mojom::SwapTimingsPtr& input) {
    return input->swap_end;
  }

  static bool Read(::gfx::mojom::SwapTimings::DataView input, ::gfx::mojom::SwapTimingsPtr* output);
};

}  // namespace mojo

#endif  // UI_GFX_MOJOM_SWAP_TIMINGS_MOJOM_H_