// ui/gfx/mojom/selection_bound.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_GFX_MOJOM_SELECTION_BOUND_MOJOM_DATA_VIEW_H_
#define UI_GFX_MOJOM_SELECTION_BOUND_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "ui/gfx/mojom/selection_bound.mojom-shared-internal.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"


namespace gfx::mojom {
class SelectionBoundDataView;



}  // gfx::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::gfx::mojom::SelectionBoundDataView> {
  using Data = ::gfx::mojom::internal::SelectionBound_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace gfx::mojom {


enum class SelectionBoundType : int32_t {
  
  LEFT = 0,
  
  RIGHT = 1,
  
  CENTER = 2,
  
  HIDDEN = 3,
  
  EMPTY = 4,
  
  LAST = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

 std::ostream& operator<<(std::ostream& os, SelectionBoundType value);
inline bool IsKnownEnumValue(SelectionBoundType value) {
  return internal::SelectionBoundType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class SelectionBoundDataView {
 public:
  SelectionBoundDataView() = default;

  SelectionBoundDataView(
      internal::SelectionBound_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::gfx::mojom::SelectionBoundType>(
        data_value, output);
  }
  SelectionBoundType type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::gfx::mojom::SelectionBoundType>(data_->type));
  }
  inline void GetEdgeStartDataView(
      ::gfx::mojom::PointFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEdgeStart(UserType* output) {
    
    auto* pointer = data_->edge_start.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointFDataView>(
        pointer, output, message_);
  }
  inline void GetEdgeEndDataView(
      ::gfx::mojom::PointFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEdgeEnd(UserType* output) {
    
    auto* pointer = data_->edge_end.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointFDataView>(
        pointer, output, message_);
  }
  inline void GetVisibleEdgeStartDataView(
      ::gfx::mojom::PointFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadVisibleEdgeStart(UserType* output) {
    
    auto* pointer = data_->visible_edge_start.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointFDataView>(
        pointer, output, message_);
  }
  inline void GetVisibleEdgeEndDataView(
      ::gfx::mojom::PointFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadVisibleEdgeEnd(UserType* output) {
    
    auto* pointer = data_->visible_edge_end.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointFDataView>(
        pointer, output, message_);
  }
  bool visible() const {
    return data_->visible;
  }
 private:
  internal::SelectionBound_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // gfx::mojom

#endif  // UI_GFX_MOJOM_SELECTION_BOUND_MOJOM_DATA_VIEW_H_