// ui/gfx/mojom/rrect_f.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_GFX_MOJOM_RRECT_F_MOJOM_DATA_VIEW_H_
#define UI_GFX_MOJOM_RRECT_F_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "ui/gfx/mojom/rrect_f.mojom-shared-internal.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"


namespace gfx::mojom {
class RRectFDataView;



}  // gfx::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::gfx::mojom::RRectFDataView> {
  using Data = ::gfx::mojom::internal::RRectF_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace gfx::mojom {


enum class RRectFType : int32_t {
  
  kEmpty = 0,
  
  kRect = 1,
  
  kSingle = 2,
  
  kSimple = 3,
  
  kOval = 4,
  
  kComplex = 5,
  kMinValue = 0,
  kMaxValue = 5,
};

 std::ostream& operator<<(std::ostream& os, RRectFType value);
inline bool IsKnownEnumValue(RRectFType value) {
  return internal::RRectFType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class RRectFDataView {
 public:
  RRectFDataView() = default;

  RRectFDataView(
      internal::RRectF_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::gfx::mojom::RRectFType>(
        data_value, output);
  }
  RRectFType type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::gfx::mojom::RRectFType>(data_->type));
  }
  inline void GetRectDataView(
      ::gfx::mojom::RectFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRect(UserType* output) {
    
    auto* pointer = data_->rect.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectFDataView>(
        pointer, output, message_);
  }
  inline void GetUpperLeftDataView(
      ::gfx::mojom::Vector2dFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUpperLeft(UserType* output) {
    
    auto* pointer = data_->upper_left.Get();
    return mojo::internal::Deserialize<::gfx::mojom::Vector2dFDataView>(
        pointer, output, message_);
  }
  inline void GetUpperRightDataView(
      ::gfx::mojom::Vector2dFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUpperRight(UserType* output) {
    
    auto* pointer = data_->upper_right.Get();
    return mojo::internal::Deserialize<::gfx::mojom::Vector2dFDataView>(
        pointer, output, message_);
  }
  inline void GetLowerRightDataView(
      ::gfx::mojom::Vector2dFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLowerRight(UserType* output) {
    
    auto* pointer = data_->lower_right.Get();
    return mojo::internal::Deserialize<::gfx::mojom::Vector2dFDataView>(
        pointer, output, message_);
  }
  inline void GetLowerLeftDataView(
      ::gfx::mojom::Vector2dFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLowerLeft(UserType* output) {
    
    auto* pointer = data_->lower_left.Get();
    return mojo::internal::Deserialize<::gfx::mojom::Vector2dFDataView>(
        pointer, output, message_);
  }
 private:
  internal::RRectF_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // gfx::mojom

#endif  // UI_GFX_MOJOM_RRECT_F_MOJOM_DATA_VIEW_H_