// ui/gfx/mojom/presentation_feedback.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_GFX_MOJOM_PRESENTATION_FEEDBACK_MOJOM_SEND_VALIDATION_H_
#define UI_GFX_MOJOM_PRESENTATION_FEEDBACK_MOJOM_SEND_VALIDATION_H_

#include "ui/gfx/mojom/presentation_feedback.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "ui/gfx/mojom/ca_layer_result.mojom-shared.h"

#include "ui/gfx/mojom/presentation_feedback.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::gfx::mojom::PresentationFeedbackDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gfx::mojom::PresentationFeedbackDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gfx::mojom::internal::PresentationFeedback_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::timestamp(input)) in_timestamp = Traits::timestamp(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->timestamp)::BaseType> timestamp_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView, send_validation>(
        in_timestamp,
        timestamp_fragment);

      fragment->timestamp.Set(
          timestamp_fragment.is_null() ? nullptr : timestamp_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->timestamp.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null timestamp in PresentationFeedback struct");

      decltype(Traits::interval(input)) in_interval = Traits::interval(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->interval)::BaseType> interval_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_interval,
        interval_fragment);

      fragment->interval.Set(
          interval_fragment.is_null() ? nullptr : interval_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->interval.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null interval in PresentationFeedback struct");

      fragment->flags = Traits::flags(input);

      decltype(Traits::available_timestamp(input)) in_available_timestamp = Traits::available_timestamp(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->available_timestamp)::BaseType> available_timestamp_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView, send_validation>(
        in_available_timestamp,
        available_timestamp_fragment);

      fragment->available_timestamp.Set(
          available_timestamp_fragment.is_null() ? nullptr : available_timestamp_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->available_timestamp.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null available_timestamp in PresentationFeedback struct");

      decltype(Traits::ready_timestamp(input)) in_ready_timestamp = Traits::ready_timestamp(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->ready_timestamp)::BaseType> ready_timestamp_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView, send_validation>(
        in_ready_timestamp,
        ready_timestamp_fragment);

      fragment->ready_timestamp.Set(
          ready_timestamp_fragment.is_null() ? nullptr : ready_timestamp_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->ready_timestamp.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null ready_timestamp in PresentationFeedback struct");

      decltype(Traits::latch_timestamp(input)) in_latch_timestamp = Traits::latch_timestamp(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->latch_timestamp)::BaseType> latch_timestamp_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView, send_validation>(
        in_latch_timestamp,
        latch_timestamp_fragment);

      fragment->latch_timestamp.Set(
          latch_timestamp_fragment.is_null() ? nullptr : latch_timestamp_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->latch_timestamp.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null latch_timestamp in PresentationFeedback struct");

      decltype(Traits::writes_done_timestamp(input)) in_writes_done_timestamp = Traits::writes_done_timestamp(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->writes_done_timestamp)::BaseType> writes_done_timestamp_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView, send_validation>(
        in_writes_done_timestamp,
        writes_done_timestamp_fragment);

      fragment->writes_done_timestamp.Set(
          writes_done_timestamp_fragment.is_null() ? nullptr : writes_done_timestamp_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->writes_done_timestamp.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null writes_done_timestamp in PresentationFeedback struct");

      
      mojo::internal::Serialize<::gfx::mojom::CALayerResult>(
        Traits::ca_layer_error_code(input),
        &fragment->ca_layer_error_code);
      fragment->display_trace_id_$flag = Traits::display_trace_id(input).has_value();
      if (Traits::display_trace_id(input).has_value()) {
        fragment->display_trace_id_$value = Traits::display_trace_id(input).value();
      }
  }
};

}  // namespace mojo::internal

#endif  // UI_GFX_MOJOM_PRESENTATION_FEEDBACK_MOJOM_SEND_VALIDATION_H_