// ui/gfx/mojom/presentation_feedback.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_GFX_MOJOM_PRESENTATION_FEEDBACK_MOJOM_DATA_VIEW_H_
#define UI_GFX_MOJOM_PRESENTATION_FEEDBACK_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "ui/gfx/mojom/presentation_feedback.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "ui/gfx/mojom/ca_layer_result.mojom-shared.h"


namespace gfx::mojom {
class PresentationFeedbackDataView;



}  // gfx::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::gfx::mojom::PresentationFeedbackDataView> {
  using Data = ::gfx::mojom::internal::PresentationFeedback_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace gfx::mojom {


class PresentationFeedbackDataView {
 public:
  PresentationFeedbackDataView() = default;

  PresentationFeedbackDataView(
      internal::PresentationFeedback_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTimestampDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTimestamp(UserType* output) {
    
    auto* pointer = data_->timestamp.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  inline void GetIntervalDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInterval(UserType* output) {
    
    auto* pointer = data_->interval.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  uint32_t flags() const {
    return data_->flags;
  }
  inline void GetAvailableTimestampDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAvailableTimestamp(UserType* output) {
    
    auto* pointer = data_->available_timestamp.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  inline void GetReadyTimestampDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReadyTimestamp(UserType* output) {
    
    auto* pointer = data_->ready_timestamp.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  inline void GetLatchTimestampDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLatchTimestamp(UserType* output) {
    
    auto* pointer = data_->latch_timestamp.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  inline void GetWritesDoneTimestampDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWritesDoneTimestamp(UserType* output) {
    
    auto* pointer = data_->writes_done_timestamp.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadCaLayerErrorCode(UserType* output) const {
    auto data_value = data_->ca_layer_error_code;
    return mojo::internal::Deserialize<::gfx::mojom::CALayerResult>(
        data_value, output);
  }
  ::gfx::mojom::CALayerResult ca_layer_error_code() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::gfx::mojom::CALayerResult>(data_->ca_layer_error_code));
  }
  std::optional<int64_t> display_trace_id() const {

    return data_->display_trace_id_$flag
        ? std::make_optional(data_->display_trace_id_$value)
        : std::nullopt;
  }
 private:
  internal::PresentationFeedback_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // gfx::mojom

#endif  // UI_GFX_MOJOM_PRESENTATION_FEEDBACK_MOJOM_DATA_VIEW_H_