// ui/gfx/mojom/native_handle_types.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_GFX_MOJOM_NATIVE_HANDLE_TYPES_MOJOM_SHARED_H_
#define UI_GFX_MOJOM_NATIVE_HANDLE_TYPES_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/gfx/mojom/native_handle_types.mojom-shared-internal.h"
#include "mojo/public/mojom/base/shared_memory.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "ui/gfx/mojom/native_handle_types.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gfx::mojom::IOSurfaceHandleDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gfx::mojom::IOSurfaceHandleDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gfx::mojom::internal::IOSurfaceHandle_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::mach_send_right(input)) in_mach_send_right = Traits::mach_send_right(input);

    
    mojo::internal::Serialize<mojo::PlatformHandle>(
      in_mach_send_right,
      &fragment->mach_send_right,
      &fragment.message());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(!mojo::internal::IsHandleOrInterfaceValid(fragment->mach_send_right)),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid mach_send_right in IOSurfaceHandle struct");
  }

  static bool Deserialize(::gfx::mojom::internal::IOSurfaceHandle_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gfx::mojom::IOSurfaceHandleDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gfx::mojom::GpuMemoryBufferPlatformHandleDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::gfx::mojom::GpuMemoryBufferPlatformHandleDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::gfx::mojom::internal::GpuMemoryBufferPlatformHandle_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::gfx::mojom::GpuMemoryBufferPlatformHandleDataView::Tag::kSharedMemoryHandle: {
    decltype(Traits::shared_memory_handle(input))
    in_shared_memory_handle = Traits::shared_memory_handle(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_shared_memory_handle)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::mojo_base::mojom::UnsafeSharedMemoryRegionDataView>(
  in_shared_memory_handle,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null shared_memory_handle in GpuMemoryBufferPlatformHandle union");
    fragment->data.f_shared_memory_handle.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::gfx::mojom::GpuMemoryBufferPlatformHandleDataView::Tag::kIoSurfaceHandle: {
    decltype(Traits::io_surface_handle(input))
    in_io_surface_handle = Traits::io_surface_handle(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_io_surface_handle)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::gfx::mojom::IOSurfaceHandleDataView>(
  in_io_surface_handle,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null io_surface_handle in GpuMemoryBufferPlatformHandle union");
    fragment->data.f_io_surface_handle.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::gfx::mojom::internal::GpuMemoryBufferPlatformHandle_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::gfx::mojom::GpuMemoryBufferPlatformHandleDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace gfx::mojom {



inline void GpuMemoryBufferPlatformHandleDataView::GetSharedMemoryHandleDataView(
    ::mojo_base::mojom::UnsafeSharedMemoryRegionDataView* output) const {
  CHECK(is_shared_memory_handle());
  *output = ::mojo_base::mojom::UnsafeSharedMemoryRegionDataView(data_->data.f_shared_memory_handle.Get(), message_);
}
inline void GpuMemoryBufferPlatformHandleDataView::GetIoSurfaceHandleDataView(
    IOSurfaceHandleDataView* output) const {
  CHECK(is_io_surface_handle());
  *output = IOSurfaceHandleDataView(data_->data.f_io_surface_handle.Get(), message_);
}


}  // gfx::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // UI_GFX_MOJOM_NATIVE_HANDLE_TYPES_MOJOM_SHARED_H_