// ui/gfx/mojom/native_handle_types.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_GFX_MOJOM_NATIVE_HANDLE_TYPES_MOJOM_DATA_VIEW_H_
#define UI_GFX_MOJOM_NATIVE_HANDLE_TYPES_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "ui/gfx/mojom/native_handle_types.mojom-shared-internal.h"
#include "mojo/public/mojom/base/shared_memory.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"


namespace gfx::mojom {
class IOSurfaceHandleDataView;

class GpuMemoryBufferPlatformHandleDataView;


}  // gfx::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::gfx::mojom::IOSurfaceHandleDataView> {
  using Data = ::gfx::mojom::internal::IOSurfaceHandle_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::gfx::mojom::GpuMemoryBufferPlatformHandleDataView> {
  using Data = ::gfx::mojom::internal::GpuMemoryBufferPlatformHandle_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace gfx::mojom {


class IOSurfaceHandleDataView {
 public:
  IOSurfaceHandleDataView() = default;

  IOSurfaceHandleDataView(
      internal::IOSurfaceHandle_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  mojo::PlatformHandle TakeMachSendRight() {
    mojo::PlatformHandle result;
    bool ret =
        mojo::internal::Deserialize<mojo::PlatformHandle>(
            &data_->mach_send_right, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::IOSurfaceHandle_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class GpuMemoryBufferPlatformHandleDataView {
 public:
  using Tag = internal::GpuMemoryBufferPlatformHandle_Data::GpuMemoryBufferPlatformHandle_Tag;

  GpuMemoryBufferPlatformHandleDataView() = default;

  GpuMemoryBufferPlatformHandleDataView(
      internal::GpuMemoryBufferPlatformHandle_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_shared_memory_handle() const { return data_->tag == Tag::kSharedMemoryHandle; }
  inline void GetSharedMemoryHandleDataView(
      ::mojo_base::mojom::UnsafeSharedMemoryRegionDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadSharedMemoryHandle(UserType* output) const {
    
    CHECK(is_shared_memory_handle());
    return mojo::internal::Deserialize<::mojo_base::mojom::UnsafeSharedMemoryRegionDataView>(
        data_->data.f_shared_memory_handle.Get(), output, message_);
  }
  bool is_io_surface_handle() const { return data_->tag == Tag::kIoSurfaceHandle; }
  inline void GetIoSurfaceHandleDataView(
      IOSurfaceHandleDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadIoSurfaceHandle(UserType* output) const {
    
    CHECK(is_io_surface_handle());
    return mojo::internal::Deserialize<::gfx::mojom::IOSurfaceHandleDataView>(
        data_->data.f_io_surface_handle.Get(), output, message_);
  }

 private:
  internal::GpuMemoryBufferPlatformHandle_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // gfx::mojom

#endif  // UI_GFX_MOJOM_NATIVE_HANDLE_TYPES_MOJOM_DATA_VIEW_H_