// ui/gfx/mojom/linear_gradient.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_GFX_MOJOM_LINEAR_GRADIENT_MOJOM_SHARED_H_
#define UI_GFX_MOJOM_LINEAR_GRADIENT_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/gfx/mojom/linear_gradient.mojom-shared-internal.h"




#include "ui/gfx/mojom/linear_gradient.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gfx::mojom::StepDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gfx::mojom::StepDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gfx::mojom::internal::Step_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->fraction = Traits::fraction(input);

    fragment->alpha = Traits::alpha(input);
  }

  static bool Deserialize(::gfx::mojom::internal::Step_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gfx::mojom::StepDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gfx::mojom::LinearGradientDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gfx::mojom::LinearGradientDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gfx::mojom::internal::LinearGradient_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->angle = Traits::angle(input);

    fragment->step_count = Traits::step_count(input);

    decltype(Traits::steps(input)) in_steps = Traits::steps(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->steps)::BaseType>
        steps_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& steps_validate_params =
        mojo::internal::GetArrayValidator<8, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::gfx::mojom::StepDataView>>(
      in_steps,
      steps_fragment,
      &steps_validate_params);

    fragment->steps.Set(
        steps_fragment.is_null() ? nullptr : steps_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->steps.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null steps in LinearGradient struct");
  }

  static bool Deserialize(::gfx::mojom::internal::LinearGradient_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gfx::mojom::LinearGradientDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace gfx::mojom {



inline void LinearGradientDataView::GetStepsDataView(
    mojo::ArrayDataView<StepDataView>* output) {
  auto pointer = data_->steps.Get();
  *output = mojo::ArrayDataView<StepDataView>(pointer, message_);
}



}  // gfx::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // UI_GFX_MOJOM_LINEAR_GRADIENT_MOJOM_SHARED_H_