// ui/gfx/mojom/display_color_spaces.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_GFX_MOJOM_DISPLAY_COLOR_SPACES_MOJOM_H_
#define UI_GFX_MOJOM_DISPLAY_COLOR_SPACES_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/gfx/mojom/display_color_spaces.mojom-features.h"  // IWYU pragma: export
#include "ui/gfx/mojom/display_color_spaces.mojom-shared.h"  // IWYU pragma: export
#include "ui/gfx/mojom/display_color_spaces.mojom-forward.h"  // IWYU pragma: export
#include "skia/public/mojom/skcolorspace_primaries.mojom.h"
#include "ui/gfx/mojom/buffer_types.mojom.h"
#include "ui/gfx/mojom/color_space.mojom.h"
#include "ui/gfx/mojom/hdr_static_metadata.mojom-forward.h"
#include <string>
#include <vector>




#include "ui/gfx/mojom/display_color_spaces_mojom_traits.h"




namespace gfx::mojom {








class  DisplayColorSpaces {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DisplayColorSpaces, T>::value>;
  using DataView = DisplayColorSpacesDataView;
  using Data_ = internal::DisplayColorSpaces_Data;

  template <typename... Args>
  static DisplayColorSpacesPtr New(Args&&... args) {
    return DisplayColorSpacesPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DisplayColorSpacesPtr From(const U& u) {
    return mojo::TypeConverter<DisplayColorSpacesPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DisplayColorSpaces>::Convert(*this);
  }


  DisplayColorSpaces();

  DisplayColorSpaces(
      std::vector<::gfx::ColorSpace> color_spaces,
      std::vector<::gfx::BufferFormat> buffer_formats,
      const ::SkColorSpacePrimaries& primaries,
      float sdr_max_luminance_nits,
      float hdr_max_luminance_relative);


  ~DisplayColorSpaces();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DisplayColorSpacesPtr>
  DisplayColorSpacesPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DisplayColorSpaces::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DisplayColorSpaces::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DisplayColorSpaces::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DisplayColorSpaces::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DisplayColorSpaces::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DisplayColorSpaces::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DisplayColorSpaces_UnserializedMessageContext<
            UserType, DisplayColorSpaces::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DisplayColorSpaces::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DisplayColorSpaces::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DisplayColorSpaces_UnserializedMessageContext<
            UserType, DisplayColorSpaces::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DisplayColorSpaces::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<::gfx::ColorSpace> color_spaces;
  
  std::vector<::gfx::BufferFormat> buffer_formats;
  
  ::SkColorSpacePrimaries primaries;
  
  float sdr_max_luminance_nits;
  
  float hdr_max_luminance_relative;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DisplayColorSpaces::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DisplayColorSpaces::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DisplayColorSpaces::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DisplayColorSpaces::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
DisplayColorSpacesPtr DisplayColorSpaces::Clone() const {
  return New(
      mojo::Clone(color_spaces),
      mojo::Clone(buffer_formats),
      mojo::Clone(primaries),
      mojo::Clone(sdr_max_luminance_nits),
      mojo::Clone(hdr_max_luminance_relative)
  );
}

template <typename T, DisplayColorSpaces::EnableIfSame<T>*>
bool DisplayColorSpaces::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->color_spaces, other_struct.color_spaces))
    return false;
  if (!mojo::Equals(this->buffer_formats, other_struct.buffer_formats))
    return false;
  if (!mojo::Equals(this->primaries, other_struct.primaries))
    return false;
  if (!mojo::Equals(this->sdr_max_luminance_nits, other_struct.sdr_max_luminance_nits))
    return false;
  if (!mojo::Equals(this->hdr_max_luminance_relative, other_struct.hdr_max_luminance_relative))
    return false;
  return true;
}

template <typename T, DisplayColorSpaces::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.color_spaces < rhs.color_spaces)
    return true;
  if (rhs.color_spaces < lhs.color_spaces)
    return false;
  if (lhs.buffer_formats < rhs.buffer_formats)
    return true;
  if (rhs.buffer_formats < lhs.buffer_formats)
    return false;
  if (lhs.primaries < rhs.primaries)
    return true;
  if (rhs.primaries < lhs.primaries)
    return false;
  if (lhs.sdr_max_luminance_nits < rhs.sdr_max_luminance_nits)
    return true;
  if (rhs.sdr_max_luminance_nits < lhs.sdr_max_luminance_nits)
    return false;
  if (lhs.hdr_max_luminance_relative < rhs.hdr_max_luminance_relative)
    return true;
  if (rhs.hdr_max_luminance_relative < lhs.hdr_max_luminance_relative)
    return false;
  return false;
}


}  // gfx::mojom

namespace mojo {


template <>
struct  StructTraits<::gfx::mojom::DisplayColorSpaces::DataView,
                                         ::gfx::mojom::DisplayColorSpacesPtr> {
  static bool IsNull(const ::gfx::mojom::DisplayColorSpacesPtr& input) { return !input; }
  static void SetToNull(::gfx::mojom::DisplayColorSpacesPtr* output) { output->reset(); }

  static const decltype(::gfx::mojom::DisplayColorSpaces::color_spaces)& color_spaces(
      const ::gfx::mojom::DisplayColorSpacesPtr& input) {
    return input->color_spaces;
  }

  static const decltype(::gfx::mojom::DisplayColorSpaces::buffer_formats)& buffer_formats(
      const ::gfx::mojom::DisplayColorSpacesPtr& input) {
    return input->buffer_formats;
  }

  static const decltype(::gfx::mojom::DisplayColorSpaces::primaries)& primaries(
      const ::gfx::mojom::DisplayColorSpacesPtr& input) {
    return input->primaries;
  }

  static decltype(::gfx::mojom::DisplayColorSpaces::sdr_max_luminance_nits) sdr_max_luminance_nits(
      const ::gfx::mojom::DisplayColorSpacesPtr& input) {
    return input->sdr_max_luminance_nits;
  }

  static decltype(::gfx::mojom::DisplayColorSpaces::hdr_max_luminance_relative) hdr_max_luminance_relative(
      const ::gfx::mojom::DisplayColorSpacesPtr& input) {
    return input->hdr_max_luminance_relative;
  }

  static bool Read(::gfx::mojom::DisplayColorSpaces::DataView input, ::gfx::mojom::DisplayColorSpacesPtr* output);
};

}  // namespace mojo

#endif  // UI_GFX_MOJOM_DISPLAY_COLOR_SPACES_MOJOM_H_