// ui/gfx/mojom/display_color_spaces.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_GFX_MOJOM_DISPLAY_COLOR_SPACES_MOJOM_SHARED_H_
#define UI_GFX_MOJOM_DISPLAY_COLOR_SPACES_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/gfx/mojom/display_color_spaces.mojom-shared-internal.h"
#include "skia/public/mojom/skcolorspace_primaries.mojom-shared.h"
#include "ui/gfx/mojom/buffer_types.mojom-shared.h"
#include "ui/gfx/mojom/color_space.mojom-shared.h"
#include "ui/gfx/mojom/hdr_static_metadata.mojom-shared.h"




#include "ui/gfx/mojom/display_color_spaces.mojom-data-view.h"




namespace std {

template <>
struct hash<::gfx::mojom::ContentColorUsage>
    : public mojo::internal::EnumHashImpl<::gfx::mojom::ContentColorUsage> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gfx::mojom::ContentColorUsage, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::gfx::mojom::ContentColorUsage, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::gfx::mojom::ContentColorUsage>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gfx::mojom::DisplayColorSpacesDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gfx::mojom::DisplayColorSpacesDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gfx::mojom::internal::DisplayColorSpaces_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::color_spaces(input)) in_color_spaces = Traits::color_spaces(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->color_spaces)::BaseType>
        color_spaces_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& color_spaces_validate_params =
        mojo::internal::GetArrayValidator<6, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::gfx::mojom::ColorSpaceDataView>>(
      in_color_spaces,
      color_spaces_fragment,
      &color_spaces_validate_params);

    fragment->color_spaces.Set(
        color_spaces_fragment.is_null() ? nullptr : color_spaces_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->color_spaces.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null color_spaces in DisplayColorSpaces struct");

    decltype(Traits::buffer_formats(input)) in_buffer_formats = Traits::buffer_formats(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->buffer_formats)::BaseType>
        buffer_formats_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& buffer_formats_validate_params =
        mojo::internal::GetArrayOfEnumsValidator<6, false, ::gfx::mojom::internal::BufferFormat_Data::Validate>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::gfx::mojom::BufferFormat>>(
      in_buffer_formats,
      buffer_formats_fragment,
      &buffer_formats_validate_params);

    fragment->buffer_formats.Set(
        buffer_formats_fragment.is_null() ? nullptr : buffer_formats_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->buffer_formats.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null buffer_formats in DisplayColorSpaces struct");

    decltype(Traits::primaries(input)) in_primaries = Traits::primaries(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->primaries)::BaseType> primaries_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::skia::mojom::SkColorSpacePrimariesDataView>(
      in_primaries,
      primaries_fragment);

    fragment->primaries.Set(
        primaries_fragment.is_null() ? nullptr : primaries_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->primaries.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null primaries in DisplayColorSpaces struct");

    fragment->sdr_max_luminance_nits = Traits::sdr_max_luminance_nits(input);

    fragment->hdr_max_luminance_relative = Traits::hdr_max_luminance_relative(input);
  }

  static bool Deserialize(::gfx::mojom::internal::DisplayColorSpaces_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gfx::mojom::DisplayColorSpacesDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace gfx::mojom {

inline void DisplayColorSpacesDataView::GetColorSpacesDataView(
    mojo::ArrayDataView<::gfx::mojom::ColorSpaceDataView>* output) {
  auto pointer = data_->color_spaces.Get();
  *output = mojo::ArrayDataView<::gfx::mojom::ColorSpaceDataView>(pointer, message_);
}
inline void DisplayColorSpacesDataView::GetBufferFormatsDataView(
    mojo::ArrayDataView<::gfx::mojom::BufferFormat>* output) {
  auto pointer = data_->buffer_formats.Get();
  *output = mojo::ArrayDataView<::gfx::mojom::BufferFormat>(pointer, message_);
}
inline void DisplayColorSpacesDataView::GetPrimariesDataView(
    ::skia::mojom::SkColorSpacePrimariesDataView* output) {
  auto pointer = data_->primaries.Get();
  *output = ::skia::mojom::SkColorSpacePrimariesDataView(pointer, message_);
}



}  // gfx::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::gfx::mojom::ContentColorUsage> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::gfx::mojom::ContentColorUsage value);
};

} // namespace perfetto

#endif  // UI_GFX_MOJOM_DISPLAY_COLOR_SPACES_MOJOM_SHARED_H_