// ui/gfx/mojom/display_color_spaces.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_GFX_MOJOM_DISPLAY_COLOR_SPACES_MOJOM_DATA_VIEW_H_
#define UI_GFX_MOJOM_DISPLAY_COLOR_SPACES_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "ui/gfx/mojom/display_color_spaces.mojom-shared-internal.h"
#include "skia/public/mojom/skcolorspace_primaries.mojom-shared.h"
#include "ui/gfx/mojom/buffer_types.mojom-shared.h"
#include "ui/gfx/mojom/color_space.mojom-shared.h"
#include "ui/gfx/mojom/hdr_static_metadata.mojom-shared.h"


namespace gfx::mojom {
class DisplayColorSpacesDataView;



}  // gfx::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::gfx::mojom::DisplayColorSpacesDataView> {
  using Data = ::gfx::mojom::internal::DisplayColorSpaces_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace gfx::mojom {


enum class ContentColorUsage : int32_t {
  
  kSRGB = 0,
  
  kWideColorGamut = 1,
  
  kHDR = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, ContentColorUsage value);
inline bool IsKnownEnumValue(ContentColorUsage value) {
  return internal::ContentColorUsage_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class DisplayColorSpacesDataView {
 public:
  DisplayColorSpacesDataView() = default;

  DisplayColorSpacesDataView(
      internal::DisplayColorSpaces_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetColorSpacesDataView(
      mojo::ArrayDataView<::gfx::mojom::ColorSpaceDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadColorSpaces(UserType* output) {
    
    auto* pointer = data_->color_spaces.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::gfx::mojom::ColorSpaceDataView>>(
        pointer, output, message_);
  }
  inline void GetBufferFormatsDataView(
      mojo::ArrayDataView<::gfx::mojom::BufferFormat>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBufferFormats(UserType* output) {
    
    auto* pointer = data_->buffer_formats.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::gfx::mojom::BufferFormat>>(
        pointer, output, message_);
  }
  inline void GetPrimariesDataView(
      ::skia::mojom::SkColorSpacePrimariesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPrimaries(UserType* output) {
    
    auto* pointer = data_->primaries.Get();
    return mojo::internal::Deserialize<::skia::mojom::SkColorSpacePrimariesDataView>(
        pointer, output, message_);
  }
  float sdr_max_luminance_nits() const {
    return data_->sdr_max_luminance_nits;
  }
  float hdr_max_luminance_relative() const {
    return data_->hdr_max_luminance_relative;
  }
 private:
  internal::DisplayColorSpaces_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // gfx::mojom

#endif  // UI_GFX_MOJOM_DISPLAY_COLOR_SPACES_MOJOM_DATA_VIEW_H_