// ui/gfx/mojom/color_space.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_GFX_MOJOM_COLOR_SPACE_MOJOM_H_
#define UI_GFX_MOJOM_COLOR_SPACE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/gfx/mojom/color_space.mojom-features.h"  // IWYU pragma: export
#include "ui/gfx/mojom/color_space.mojom-shared.h"  // IWYU pragma: export
#include "ui/gfx/mojom/color_space.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>




#include "ui/gfx/mojom/color_space_mojom_traits.h"




namespace gfx::mojom {








class  ColorSpace {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ColorSpace, T>::value>;
  using DataView = ColorSpaceDataView;
  using Data_ = internal::ColorSpace_Data;

  template <typename... Args>
  static ColorSpacePtr New(Args&&... args) {
    return ColorSpacePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ColorSpacePtr From(const U& u) {
    return mojo::TypeConverter<ColorSpacePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ColorSpace>::Convert(*this);
  }


  ColorSpace();

  ColorSpace(
      ColorSpacePrimaryID primaries,
      ColorSpaceTransferID transfer,
      ColorSpaceMatrixID matrix,
      ColorSpaceRangeID range,
      std::vector<float> custom_primary_matrix,
      std::vector<float> transfer_params);


  ~ColorSpace();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ColorSpacePtr>
  ColorSpacePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ColorSpace::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ColorSpace::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ColorSpace::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ColorSpace::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ColorSpace::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ColorSpace::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ColorSpace_UnserializedMessageContext<
            UserType, ColorSpace::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ColorSpace::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ColorSpace::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ColorSpace_UnserializedMessageContext<
            UserType, ColorSpace::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ColorSpace::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ColorSpacePrimaryID primaries;
  
  ColorSpaceTransferID transfer;
  
  ColorSpaceMatrixID matrix;
  
  ColorSpaceRangeID range;
  
  std::vector<float> custom_primary_matrix;
  
  std::vector<float> transfer_params;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ColorSpace::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ColorSpace::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ColorSpace::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ColorSpace::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
ColorSpacePtr ColorSpace::Clone() const {
  return New(
      mojo::Clone(primaries),
      mojo::Clone(transfer),
      mojo::Clone(matrix),
      mojo::Clone(range),
      mojo::Clone(custom_primary_matrix),
      mojo::Clone(transfer_params)
  );
}

template <typename T, ColorSpace::EnableIfSame<T>*>
bool ColorSpace::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->primaries, other_struct.primaries))
    return false;
  if (!mojo::Equals(this->transfer, other_struct.transfer))
    return false;
  if (!mojo::Equals(this->matrix, other_struct.matrix))
    return false;
  if (!mojo::Equals(this->range, other_struct.range))
    return false;
  if (!mojo::Equals(this->custom_primary_matrix, other_struct.custom_primary_matrix))
    return false;
  if (!mojo::Equals(this->transfer_params, other_struct.transfer_params))
    return false;
  return true;
}

template <typename T, ColorSpace::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.primaries < rhs.primaries)
    return true;
  if (rhs.primaries < lhs.primaries)
    return false;
  if (lhs.transfer < rhs.transfer)
    return true;
  if (rhs.transfer < lhs.transfer)
    return false;
  if (lhs.matrix < rhs.matrix)
    return true;
  if (rhs.matrix < lhs.matrix)
    return false;
  if (lhs.range < rhs.range)
    return true;
  if (rhs.range < lhs.range)
    return false;
  if (lhs.custom_primary_matrix < rhs.custom_primary_matrix)
    return true;
  if (rhs.custom_primary_matrix < lhs.custom_primary_matrix)
    return false;
  if (lhs.transfer_params < rhs.transfer_params)
    return true;
  if (rhs.transfer_params < lhs.transfer_params)
    return false;
  return false;
}


}  // gfx::mojom

namespace mojo {


template <>
struct  StructTraits<::gfx::mojom::ColorSpace::DataView,
                                         ::gfx::mojom::ColorSpacePtr> {
  static bool IsNull(const ::gfx::mojom::ColorSpacePtr& input) { return !input; }
  static void SetToNull(::gfx::mojom::ColorSpacePtr* output) { output->reset(); }

  static decltype(::gfx::mojom::ColorSpace::primaries) primaries(
      const ::gfx::mojom::ColorSpacePtr& input) {
    return input->primaries;
  }

  static decltype(::gfx::mojom::ColorSpace::transfer) transfer(
      const ::gfx::mojom::ColorSpacePtr& input) {
    return input->transfer;
  }

  static decltype(::gfx::mojom::ColorSpace::matrix) matrix(
      const ::gfx::mojom::ColorSpacePtr& input) {
    return input->matrix;
  }

  static decltype(::gfx::mojom::ColorSpace::range) range(
      const ::gfx::mojom::ColorSpacePtr& input) {
    return input->range;
  }

  static const decltype(::gfx::mojom::ColorSpace::custom_primary_matrix)& custom_primary_matrix(
      const ::gfx::mojom::ColorSpacePtr& input) {
    return input->custom_primary_matrix;
  }

  static const decltype(::gfx::mojom::ColorSpace::transfer_params)& transfer_params(
      const ::gfx::mojom::ColorSpacePtr& input) {
    return input->transfer_params;
  }

  static bool Read(::gfx::mojom::ColorSpace::DataView input, ::gfx::mojom::ColorSpacePtr* output);
};

}  // namespace mojo

#endif  // UI_GFX_MOJOM_COLOR_SPACE_MOJOM_H_