// ui/gfx/mojom/ca_layer_params.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_GFX_MOJOM_CA_LAYER_PARAMS_MOJOM_BLINK_H_
#define UI_GFX_MOJOM_CA_LAYER_PARAMS_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/gfx/mojom/ca_layer_params.mojom-features.h"  // IWYU pragma: export
#include "ui/gfx/mojom/ca_layer_params.mojom-shared.h"  // IWYU pragma: export
#include "ui/gfx/mojom/ca_layer_params.mojom-blink-forward.h"  // IWYU pragma: export
#include "ui/gfx/geometry/mojom/geometry.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace gfx::mojom::blink {






class  CALayerContent {
 public:
  using DataView = CALayerContentDataView;
  using Data_ = internal::CALayerContent_Data;
  using Tag = Data_::CALayerContent_Tag;

  template <typename... Args>
  static CALayerContentPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |ca_context_id|.
  static CALayerContentPtr NewCaContextId(
      uint32_t value);
  // Construct an instance holding |io_surface_mach_port|.
  static CALayerContentPtr NewIoSurfaceMachPort(
      ::mojo::PlatformHandle value);

  template <typename U>
  static CALayerContentPtr From(const U& u) {
    return mojo::TypeConverter<CALayerContentPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CALayerContent>::Convert(*this);
  }
  ~CALayerContent();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  CALayerContent(const CALayerContent& other) = delete;
  CALayerContent& operator=(const CALayerContent& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = CALayerContentPtr>
  CALayerContentPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, CALayerContent>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, CALayerContent>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_ca_context_id() const { return tag_ == Tag::kCaContextId; }
  uint32_t get_ca_context_id() const {
    CHECK(tag_ == Tag::kCaContextId);
    return data_.ca_context_id;
  }
  void set_ca_context_id(uint32_t ca_context_id);

  bool is_io_surface_mach_port() const { return tag_ == Tag::kIoSurfaceMachPort; }
  const ::mojo::PlatformHandle& get_io_surface_mach_port() const {
    CHECK(tag_ == Tag::kIoSurfaceMachPort);
    return data_.io_surface_mach_port;
  }
  ::mojo::PlatformHandle& get_io_surface_mach_port() {
    CHECK(tag_ == Tag::kIoSurfaceMachPort);
    return data_.io_surface_mach_port;
  }
  void set_io_surface_mach_port(::mojo::PlatformHandle io_surface_mach_port);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CALayerContent::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<CALayerContent::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kCaContextId)>,
        uint32_t value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kIoSurfaceMachPort)>,
        ::mojo::PlatformHandle value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    uint32_t ca_context_id;
    ::mojo::PlatformHandle io_surface_mach_port;
  };

  CALayerContent(
      std::in_place_index_t<static_cast<size_t>(Tag::kCaContextId)>,
      uint32_t value);
  CALayerContent(
      std::in_place_index_t<static_cast<size_t>(Tag::kIoSurfaceMachPort)>,
      ::mojo::PlatformHandle value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class  CALayerParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CALayerParams, T>::value>;
  using DataView = CALayerParamsDataView;
  using Data_ = internal::CALayerParams_Data;

  template <typename... Args>
  static CALayerParamsPtr New(Args&&... args) {
    return CALayerParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CALayerParamsPtr From(const U& u) {
    return mojo::TypeConverter<CALayerParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CALayerParams>::Convert(*this);
  }


  CALayerParams();

  CALayerParams(
      bool is_empty,
      CALayerContentPtr content,
      const ::gfx::Size& pixel_size,
      float scale_factor);

CALayerParams(const CALayerParams&) = delete;
CALayerParams& operator=(const CALayerParams&) = delete;

  ~CALayerParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CALayerParamsPtr>
  CALayerParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CALayerParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CALayerParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CALayerParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CALayerParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CALayerParams_UnserializedMessageContext<
            UserType, CALayerParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CALayerParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CALayerParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CALayerParams_UnserializedMessageContext<
            UserType, CALayerParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CALayerParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool is_empty;
  
  CALayerContentPtr content;
  
  ::gfx::Size pixel_size;
  
  float scale_factor;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CALayerParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CALayerParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CALayerParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CALayerParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
CALayerContentPtr CALayerContent::Clone() const {
  switch (tag_) {
    case Tag::kCaContextId:
      return NewCaContextId(
          mojo::Clone(data_.ca_context_id));
    case Tag::kIoSurfaceMachPort:
      return NewIoSurfaceMachPort(
          mojo::Clone(data_.io_surface_mach_port));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, CALayerContent>::value>::type*>
bool CALayerContent::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kCaContextId:
      return mojo::Equals(data_.ca_context_id, other.data_.ca_context_id);
    case Tag::kIoSurfaceMachPort:
      return mojo::Equals(data_.io_surface_mach_port, other.data_.io_surface_mach_port);
  }

  return false;
}
template <typename StructPtrType>
CALayerParamsPtr CALayerParams::Clone() const {
  return New(
      mojo::Clone(is_empty),
      mojo::Clone(content),
      mojo::Clone(pixel_size),
      mojo::Clone(scale_factor)
  );
}

template <typename T, CALayerParams::EnableIfSame<T>*>
bool CALayerParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->is_empty, other_struct.is_empty))
    return false;
  if (!mojo::Equals(this->content, other_struct.content))
    return false;
  if (!mojo::Equals(this->pixel_size, other_struct.pixel_size))
    return false;
  if (!mojo::Equals(this->scale_factor, other_struct.scale_factor))
    return false;
  return true;
}

template <typename T, CALayerParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.is_empty < rhs.is_empty)
    return true;
  if (rhs.is_empty < lhs.is_empty)
    return false;
  if (lhs.content < rhs.content)
    return true;
  if (rhs.content < lhs.content)
    return false;
  if (lhs.pixel_size < rhs.pixel_size)
    return true;
  if (rhs.pixel_size < lhs.pixel_size)
    return false;
  if (lhs.scale_factor < rhs.scale_factor)
    return true;
  if (rhs.scale_factor < lhs.scale_factor)
    return false;
  return false;
}


}  // gfx::mojom::blink

namespace mojo {


template <>
struct  StructTraits<::gfx::mojom::blink::CALayerParams::DataView,
                                         ::gfx::mojom::blink::CALayerParamsPtr> {
  static bool IsNull(const ::gfx::mojom::blink::CALayerParamsPtr& input) { return !input; }
  static void SetToNull(::gfx::mojom::blink::CALayerParamsPtr* output) { output->reset(); }

  static decltype(::gfx::mojom::blink::CALayerParams::is_empty) is_empty(
      const ::gfx::mojom::blink::CALayerParamsPtr& input) {
    return input->is_empty;
  }

  static  decltype(::gfx::mojom::blink::CALayerParams::content)& content(
       ::gfx::mojom::blink::CALayerParamsPtr& input) {
    return input->content;
  }

  static const decltype(::gfx::mojom::blink::CALayerParams::pixel_size)& pixel_size(
      const ::gfx::mojom::blink::CALayerParamsPtr& input) {
    return input->pixel_size;
  }

  static decltype(::gfx::mojom::blink::CALayerParams::scale_factor) scale_factor(
      const ::gfx::mojom::blink::CALayerParamsPtr& input) {
    return input->scale_factor;
  }

  static bool Read(::gfx::mojom::blink::CALayerParams::DataView input, ::gfx::mojom::blink::CALayerParamsPtr* output);
};


template <>
struct  UnionTraits<::gfx::mojom::blink::CALayerContent::DataView,
                                        ::gfx::mojom::blink::CALayerContentPtr> {
  static bool IsNull(const ::gfx::mojom::blink::CALayerContentPtr& input) { return !input; }
  static void SetToNull(::gfx::mojom::blink::CALayerContentPtr* output) { output->reset(); }

  static ::gfx::mojom::blink::CALayerContent::Tag GetTag(const ::gfx::mojom::blink::CALayerContentPtr& input) {
    return input->which();
  }

  static  uint32_t ca_context_id(const ::gfx::mojom::blink::CALayerContentPtr& input) {
    return input->get_ca_context_id();
  }

  static  ::mojo::PlatformHandle& io_surface_mach_port( ::gfx::mojom::blink::CALayerContentPtr& input) {
    return input->get_io_surface_mach_port();
  }

  static bool Read(::gfx::mojom::blink::CALayerContent::DataView input, ::gfx::mojom::blink::CALayerContentPtr* output);
};

}  // namespace mojo

#endif  // UI_GFX_MOJOM_CA_LAYER_PARAMS_MOJOM_BLINK_H_