// ui/gfx/mojom/buffer_types.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_GFX_MOJOM_BUFFER_TYPES_MOJOM_SHARED_H_
#define UI_GFX_MOJOM_BUFFER_TYPES_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/gfx/mojom/buffer_types.mojom-shared-internal.h"
#include "ui/gfx/mojom/native_handle_types.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "ui/gfx/mojom/buffer_types.mojom-data-view.h"




namespace std {

template <>
struct hash<::gfx::mojom::BufferFormat>
    : public mojo::internal::EnumHashImpl<::gfx::mojom::BufferFormat> {};

template <>
struct hash<::gfx::mojom::BufferUsage>
    : public mojo::internal::EnumHashImpl<::gfx::mojom::BufferUsage> {};

template <>
struct hash<::gfx::mojom::BufferPlane>
    : public mojo::internal::EnumHashImpl<::gfx::mojom::BufferPlane> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gfx::mojom::BufferFormat, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::gfx::mojom::BufferFormat, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::gfx::mojom::BufferFormat>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gfx::mojom::BufferUsage, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::gfx::mojom::BufferUsage, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::gfx::mojom::BufferUsage>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gfx::mojom::BufferPlane, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::gfx::mojom::BufferPlane, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::gfx::mojom::BufferPlane>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gfx::mojom::BufferUsageAndFormatDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gfx::mojom::BufferUsageAndFormatDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gfx::mojom::internal::BufferUsageAndFormat_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::gfx::mojom::BufferUsage>(
      Traits::usage(input),
      &fragment->usage);

    
    mojo::internal::Serialize<::gfx::mojom::BufferFormat>(
      Traits::format(input),
      &fragment->format);
  }

  static bool Deserialize(::gfx::mojom::internal::BufferUsageAndFormat_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gfx::mojom::BufferUsageAndFormatDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gfx::mojom::GpuMemoryBufferIdDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gfx::mojom::GpuMemoryBufferIdDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gfx::mojom::internal::GpuMemoryBufferId_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->id = Traits::id(input);
  }

  static bool Deserialize(::gfx::mojom::internal::GpuMemoryBufferId_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gfx::mojom::GpuMemoryBufferIdDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gfx::mojom::GpuMemoryBufferHandleDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gfx::mojom::GpuMemoryBufferHandleDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gfx::mojom::internal::GpuMemoryBufferHandle_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->offset = Traits::offset(input);

    fragment->stride = Traits::stride(input);

    decltype(Traits::platform_handle(input)) in_platform_handle = Traits::platform_handle(input);
    mojo::internal::MessageFragment<decltype(fragment->platform_handle)>
        platform_handle_fragment(fragment.message());
    platform_handle_fragment.Claim(&fragment->platform_handle);
    
    mojo::internal::Serialize<::gfx::mojom::GpuMemoryBufferPlatformHandleDataView>(
      in_platform_handle,
      platform_handle_fragment,
      true);
  }

  static bool Deserialize(::gfx::mojom::internal::GpuMemoryBufferHandle_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gfx::mojom::GpuMemoryBufferHandleDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace gfx::mojom {





inline void GpuMemoryBufferHandleDataView::GetPlatformHandleDataView(
    ::gfx::mojom::GpuMemoryBufferPlatformHandleDataView* output) {
  auto pointer = &data_->platform_handle;
  *output = ::gfx::mojom::GpuMemoryBufferPlatformHandleDataView(pointer, message_);
}



}  // gfx::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::gfx::mojom::BufferFormat> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::gfx::mojom::BufferFormat value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::gfx::mojom::BufferUsage> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::gfx::mojom::BufferUsage value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::gfx::mojom::BufferPlane> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::gfx::mojom::BufferPlane value);
};

} // namespace perfetto

#endif  // UI_GFX_MOJOM_BUFFER_TYPES_MOJOM_SHARED_H_