// ui/gfx/image/mojom/image.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_GFX_IMAGE_MOJOM_IMAGE_MOJOM_SHARED_H_
#define UI_GFX_IMAGE_MOJOM_IMAGE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/gfx/image/mojom/image.mojom-shared-internal.h"
#include "skia/public/mojom/bitmap.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "ui/gfx/image/mojom/image.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gfx::mojom::ImageSkiaRepDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gfx::mojom::ImageSkiaRepDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gfx::mojom::internal::ImageSkiaRep_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::bitmap(input)) in_bitmap = Traits::bitmap(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->bitmap)::BaseType> bitmap_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::skia::mojom::BitmapWithArbitraryBppDataView>(
      in_bitmap,
      bitmap_fragment);

    fragment->bitmap.Set(
        bitmap_fragment.is_null() ? nullptr : bitmap_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->bitmap.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null bitmap in ImageSkiaRep struct");

    fragment->scale = Traits::scale(input);
  }

  static bool Deserialize(::gfx::mojom::internal::ImageSkiaRep_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gfx::mojom::ImageSkiaRepDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gfx::mojom::ImageSkiaDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gfx::mojom::ImageSkiaDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gfx::mojom::internal::ImageSkia_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::image_reps(input)) in_image_reps = Traits::image_reps(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->image_reps)::BaseType>
        image_reps_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& image_reps_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::gfx::mojom::ImageSkiaRepDataView>>(
      in_image_reps,
      image_reps_fragment,
      &image_reps_validate_params);

    fragment->image_reps.Set(
        image_reps_fragment.is_null() ? nullptr : image_reps_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->image_reps.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null image_reps in ImageSkia struct");
  }

  static bool Deserialize(::gfx::mojom::internal::ImageSkia_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gfx::mojom::ImageSkiaDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace gfx::mojom {

inline void ImageSkiaRepDataView::GetBitmapDataView(
    ::skia::mojom::BitmapWithArbitraryBppDataView* output) {
  auto pointer = data_->bitmap.Get();
  *output = ::skia::mojom::BitmapWithArbitraryBppDataView(pointer, message_);
}


inline void ImageSkiaDataView::GetImageRepsDataView(
    mojo::ArrayDataView<ImageSkiaRepDataView>* output) {
  auto pointer = data_->image_reps.Get();
  *output = mojo::ArrayDataView<ImageSkiaRepDataView>(pointer, message_);
}



}  // gfx::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // UI_GFX_IMAGE_MOJOM_IMAGE_MOJOM_SHARED_H_