// ui/gfx/image/mojom/image.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_GFX_IMAGE_MOJOM_IMAGE_MOJOM_BLINK_H_
#define UI_GFX_IMAGE_MOJOM_IMAGE_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/gfx/image/mojom/image.mojom-features.h"  // IWYU pragma: export
#include "ui/gfx/image/mojom/image.mojom-shared.h"  // IWYU pragma: export
#include "ui/gfx/image/mojom/image.mojom-blink-forward.h"  // IWYU pragma: export
#include "skia/public/mojom/bitmap.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "ui/gfx/image/mojom/image_skia_mojom_traits.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace gfx::mojom::blink {









class  ImageSkiaRep {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ImageSkiaRep, T>::value>;
  using DataView = ImageSkiaRepDataView;
  using Data_ = internal::ImageSkiaRep_Data;

  template <typename... Args>
  static ImageSkiaRepPtr New(Args&&... args) {
    return ImageSkiaRepPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ImageSkiaRepPtr From(const U& u) {
    return mojo::TypeConverter<ImageSkiaRepPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ImageSkiaRep>::Convert(*this);
  }


  ImageSkiaRep();

  ImageSkiaRep(
      const ::SkBitmap& bitmap,
      float scale);


  ~ImageSkiaRep();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ImageSkiaRepPtr>
  ImageSkiaRepPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ImageSkiaRep::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ImageSkiaRep::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ImageSkiaRep::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ImageSkiaRep::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ImageSkiaRep_UnserializedMessageContext<
            UserType, ImageSkiaRep::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ImageSkiaRep::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ImageSkiaRep::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ImageSkiaRep_UnserializedMessageContext<
            UserType, ImageSkiaRep::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ImageSkiaRep::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::SkBitmap bitmap;
  
  float scale;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ImageSkiaRep::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ImageSkiaRep::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ImageSkiaRep::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ImageSkiaRep::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  ImageSkia {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ImageSkia, T>::value>;
  using DataView = ImageSkiaDataView;
  using Data_ = internal::ImageSkia_Data;

  template <typename... Args>
  static ImageSkiaPtr New(Args&&... args) {
    return ImageSkiaPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ImageSkiaPtr From(const U& u) {
    return mojo::TypeConverter<ImageSkiaPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ImageSkia>::Convert(*this);
  }


  ImageSkia();

  explicit ImageSkia(
      ::blink::Vector<::gfx::ImageSkiaRep> image_reps);


  ~ImageSkia();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ImageSkiaPtr>
  ImageSkiaPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ImageSkia::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ImageSkia::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ImageSkia::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ImageSkia::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ImageSkia_UnserializedMessageContext<
            UserType, ImageSkia::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ImageSkia::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ImageSkia::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ImageSkia_UnserializedMessageContext<
            UserType, ImageSkia::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ImageSkia::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::Vector<::gfx::ImageSkiaRep> image_reps;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ImageSkia::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ImageSkia::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ImageSkia::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ImageSkia::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
ImageSkiaRepPtr ImageSkiaRep::Clone() const {
  return New(
      mojo::Clone(bitmap),
      mojo::Clone(scale)
  );
}

template <typename T, ImageSkiaRep::EnableIfSame<T>*>
bool ImageSkiaRep::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->bitmap, other_struct.bitmap))
    return false;
  if (!mojo::Equals(this->scale, other_struct.scale))
    return false;
  return true;
}

template <typename T, ImageSkiaRep::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.bitmap < rhs.bitmap)
    return true;
  if (rhs.bitmap < lhs.bitmap)
    return false;
  if (lhs.scale < rhs.scale)
    return true;
  if (rhs.scale < lhs.scale)
    return false;
  return false;
}
template <typename StructPtrType>
ImageSkiaPtr ImageSkia::Clone() const {
  return New(
      mojo::Clone(image_reps)
  );
}

template <typename T, ImageSkia::EnableIfSame<T>*>
bool ImageSkia::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->image_reps, other_struct.image_reps))
    return false;
  return true;
}

template <typename T, ImageSkia::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.image_reps < rhs.image_reps)
    return true;
  if (rhs.image_reps < lhs.image_reps)
    return false;
  return false;
}


}  // gfx::mojom::blink

namespace mojo {


template <>
struct  StructTraits<::gfx::mojom::blink::ImageSkiaRep::DataView,
                                         ::gfx::mojom::blink::ImageSkiaRepPtr> {
  static bool IsNull(const ::gfx::mojom::blink::ImageSkiaRepPtr& input) { return !input; }
  static void SetToNull(::gfx::mojom::blink::ImageSkiaRepPtr* output) { output->reset(); }

  static  decltype(::gfx::mojom::blink::ImageSkiaRep::bitmap)& bitmap(
       ::gfx::mojom::blink::ImageSkiaRepPtr& input) {
    return input->bitmap;
  }

  static decltype(::gfx::mojom::blink::ImageSkiaRep::scale) scale(
      const ::gfx::mojom::blink::ImageSkiaRepPtr& input) {
    return input->scale;
  }

  static bool Read(::gfx::mojom::blink::ImageSkiaRep::DataView input, ::gfx::mojom::blink::ImageSkiaRepPtr* output);
};


template <>
struct  StructTraits<::gfx::mojom::blink::ImageSkia::DataView,
                                         ::gfx::mojom::blink::ImageSkiaPtr> {
  static bool IsNull(const ::gfx::mojom::blink::ImageSkiaPtr& input) { return !input; }
  static void SetToNull(::gfx::mojom::blink::ImageSkiaPtr* output) { output->reset(); }

  static  decltype(::gfx::mojom::blink::ImageSkia::image_reps)& image_reps(
       ::gfx::mojom::blink::ImageSkiaPtr& input) {
    return input->image_reps;
  }

  static bool Read(::gfx::mojom::blink::ImageSkia::DataView input, ::gfx::mojom::blink::ImageSkiaPtr* output);
};

}  // namespace mojo

#endif  // UI_GFX_IMAGE_MOJOM_IMAGE_MOJOM_BLINK_H_