// ui/events/mojom/keyboard_codes.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "ui/events/mojom/keyboard_codes.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "ui/events/mojom/keyboard_codes.mojom-params-data.h"
namespace ui {
namespace mojom {

NOINLINE static const char* KeyboardCodeToStringHelper(KeyboardCode value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case KeyboardCode::UNKNOWN:
      return "UNKNOWN";
    case KeyboardCode::BACK:
      return "BACK";
    case KeyboardCode::TAB:
      return "TAB";
    case KeyboardCode::CLEAR:
      return "CLEAR";
    case KeyboardCode::RETURN:
      return "RETURN";
    case KeyboardCode::SHIFT:
      return "SHIFT";
    case KeyboardCode::CONTROL:
      return "CONTROL";
    case KeyboardCode::MENU:
      return "MENU";
    case KeyboardCode::PAUSE:
      return "PAUSE";
    case KeyboardCode::CAPITAL:
      return "CAPITAL";
    case KeyboardCode::KANA:
      return "{KANA, HANGUL}";
    case KeyboardCode::JUNJA:
      return "JUNJA";
    case KeyboardCode::FINAL:
      return "FINAL";
    case KeyboardCode::HANJA:
      return "{HANJA, KANJI}";
    case KeyboardCode::ESCAPE:
      return "ESCAPE";
    case KeyboardCode::CONVERT:
      return "CONVERT";
    case KeyboardCode::NONCONVERT:
      return "NONCONVERT";
    case KeyboardCode::ACCEPT:
      return "ACCEPT";
    case KeyboardCode::MODECHANGE:
      return "MODECHANGE";
    case KeyboardCode::SPACE:
      return "SPACE";
    case KeyboardCode::PRIOR:
      return "PRIOR";
    case KeyboardCode::NEXT:
      return "NEXT";
    case KeyboardCode::END:
      return "END";
    case KeyboardCode::HOME:
      return "HOME";
    case KeyboardCode::LEFT:
      return "LEFT";
    case KeyboardCode::UP:
      return "UP";
    case KeyboardCode::RIGHT:
      return "RIGHT";
    case KeyboardCode::DOWN:
      return "DOWN";
    case KeyboardCode::SELECT:
      return "SELECT";
    case KeyboardCode::PRINT:
      return "PRINT";
    case KeyboardCode::EXECUTE:
      return "EXECUTE";
    case KeyboardCode::SNAPSHOT:
      return "SNAPSHOT";
    case KeyboardCode::INSERT:
      return "INSERT";
    case KeyboardCode::DELETE_KEY:
      return "DELETE_KEY";
    case KeyboardCode::HELP:
      return "HELP";
    case KeyboardCode::NUM_0:
      return "NUM_0";
    case KeyboardCode::NUM_1:
      return "NUM_1";
    case KeyboardCode::NUM_2:
      return "NUM_2";
    case KeyboardCode::NUM_3:
      return "NUM_3";
    case KeyboardCode::NUM_4:
      return "NUM_4";
    case KeyboardCode::NUM_5:
      return "NUM_5";
    case KeyboardCode::NUM_6:
      return "NUM_6";
    case KeyboardCode::NUM_7:
      return "NUM_7";
    case KeyboardCode::NUM_8:
      return "NUM_8";
    case KeyboardCode::NUM_9:
      return "NUM_9";
    case KeyboardCode::A:
      return "A";
    case KeyboardCode::B:
      return "B";
    case KeyboardCode::C:
      return "C";
    case KeyboardCode::D:
      return "D";
    case KeyboardCode::E:
      return "E";
    case KeyboardCode::F:
      return "F";
    case KeyboardCode::G:
      return "G";
    case KeyboardCode::H:
      return "H";
    case KeyboardCode::I:
      return "I";
    case KeyboardCode::J:
      return "J";
    case KeyboardCode::K:
      return "K";
    case KeyboardCode::L:
      return "L";
    case KeyboardCode::M:
      return "M";
    case KeyboardCode::N:
      return "N";
    case KeyboardCode::O:
      return "O";
    case KeyboardCode::P:
      return "P";
    case KeyboardCode::Q:
      return "Q";
    case KeyboardCode::R:
      return "R";
    case KeyboardCode::S:
      return "S";
    case KeyboardCode::T:
      return "T";
    case KeyboardCode::U:
      return "U";
    case KeyboardCode::V:
      return "V";
    case KeyboardCode::W:
      return "W";
    case KeyboardCode::X:
      return "X";
    case KeyboardCode::Y:
      return "Y";
    case KeyboardCode::Z:
      return "Z";
    case KeyboardCode::LWIN:
      return "{LWIN, COMMAND}";
    case KeyboardCode::RWIN:
      return "RWIN";
    case KeyboardCode::APPS:
      return "APPS";
    case KeyboardCode::SLEEP:
      return "SLEEP";
    case KeyboardCode::NUMPAD0:
      return "NUMPAD0";
    case KeyboardCode::NUMPAD1:
      return "NUMPAD1";
    case KeyboardCode::NUMPAD2:
      return "NUMPAD2";
    case KeyboardCode::NUMPAD3:
      return "NUMPAD3";
    case KeyboardCode::NUMPAD4:
      return "NUMPAD4";
    case KeyboardCode::NUMPAD5:
      return "NUMPAD5";
    case KeyboardCode::NUMPAD6:
      return "NUMPAD6";
    case KeyboardCode::NUMPAD7:
      return "NUMPAD7";
    case KeyboardCode::NUMPAD8:
      return "NUMPAD8";
    case KeyboardCode::NUMPAD9:
      return "NUMPAD9";
    case KeyboardCode::MULTIPLY:
      return "MULTIPLY";
    case KeyboardCode::ADD:
      return "ADD";
    case KeyboardCode::SEPARATOR:
      return "SEPARATOR";
    case KeyboardCode::SUBTRACT:
      return "SUBTRACT";
    case KeyboardCode::DECIMAL:
      return "DECIMAL";
    case KeyboardCode::DIVIDE:
      return "DIVIDE";
    case KeyboardCode::F1:
      return "F1";
    case KeyboardCode::F2:
      return "F2";
    case KeyboardCode::F3:
      return "F3";
    case KeyboardCode::F4:
      return "F4";
    case KeyboardCode::F5:
      return "F5";
    case KeyboardCode::F6:
      return "F6";
    case KeyboardCode::F7:
      return "F7";
    case KeyboardCode::F8:
      return "F8";
    case KeyboardCode::F9:
      return "F9";
    case KeyboardCode::F10:
      return "F10";
    case KeyboardCode::F11:
      return "F11";
    case KeyboardCode::F12:
      return "F12";
    case KeyboardCode::F13:
      return "F13";
    case KeyboardCode::F14:
      return "F14";
    case KeyboardCode::F15:
      return "F15";
    case KeyboardCode::F16:
      return "F16";
    case KeyboardCode::F17:
      return "F17";
    case KeyboardCode::F18:
      return "F18";
    case KeyboardCode::F19:
      return "F19";
    case KeyboardCode::F20:
      return "F20";
    case KeyboardCode::F21:
      return "F21";
    case KeyboardCode::F22:
      return "F22";
    case KeyboardCode::F23:
      return "F23";
    case KeyboardCode::F24:
      return "F24";
    case KeyboardCode::NUMLOCK:
      return "NUMLOCK";
    case KeyboardCode::SCROLL:
      return "SCROLL";
    case KeyboardCode::WLAN:
      return "WLAN";
    case KeyboardCode::POWER:
      return "POWER";
    case KeyboardCode::ASSISTANT:
      return "ASSISTANT";
    case KeyboardCode::LSHIFT:
      return "LSHIFT";
    case KeyboardCode::RSHIFT:
      return "RSHIFT";
    case KeyboardCode::LCONTROL:
      return "LCONTROL";
    case KeyboardCode::RCONTROL:
      return "RCONTROL";
    case KeyboardCode::LMENU:
      return "LMENU";
    case KeyboardCode::RMENU:
      return "RMENU";
    case KeyboardCode::BROWSER_BACK:
      return "BROWSER_BACK";
    case KeyboardCode::BROWSER_FORWARD:
      return "BROWSER_FORWARD";
    case KeyboardCode::BROWSER_REFRESH:
      return "BROWSER_REFRESH";
    case KeyboardCode::BROWSER_STOP:
      return "BROWSER_STOP";
    case KeyboardCode::BROWSER_SEARCH:
      return "BROWSER_SEARCH";
    case KeyboardCode::BROWSER_FAVORITES:
      return "BROWSER_FAVORITES";
    case KeyboardCode::BROWSER_HOME:
      return "BROWSER_HOME";
    case KeyboardCode::VOLUME_MUTE:
      return "VOLUME_MUTE";
    case KeyboardCode::VOLUME_DOWN:
      return "VOLUME_DOWN";
    case KeyboardCode::VOLUME_UP:
      return "VOLUME_UP";
    case KeyboardCode::MEDIA_NEXT_TRACK:
      return "MEDIA_NEXT_TRACK";
    case KeyboardCode::MEDIA_PREV_TRACK:
      return "MEDIA_PREV_TRACK";
    case KeyboardCode::MEDIA_STOP:
      return "MEDIA_STOP";
    case KeyboardCode::MEDIA_PLAY_PAUSE:
      return "MEDIA_PLAY_PAUSE";
    case KeyboardCode::MEDIA_LAUNCH_MAIL:
      return "MEDIA_LAUNCH_MAIL";
    case KeyboardCode::MEDIA_LAUNCH_MEDIA_SELECT:
      return "MEDIA_LAUNCH_MEDIA_SELECT";
    case KeyboardCode::MEDIA_LAUNCH_APP1:
      return "MEDIA_LAUNCH_APP1";
    case KeyboardCode::MEDIA_LAUNCH_APP2:
      return "MEDIA_LAUNCH_APP2";
    case KeyboardCode::OEM_1:
      return "OEM_1";
    case KeyboardCode::OEM_PLUS:
      return "OEM_PLUS";
    case KeyboardCode::OEM_COMMA:
      return "OEM_COMMA";
    case KeyboardCode::OEM_MINUS:
      return "OEM_MINUS";
    case KeyboardCode::OEM_PERIOD:
      return "OEM_PERIOD";
    case KeyboardCode::OEM_2:
      return "OEM_2";
    case KeyboardCode::OEM_3:
      return "OEM_3";
    case KeyboardCode::BRIGHTNESS_DOWN:
      return "BRIGHTNESS_DOWN";
    case KeyboardCode::BRIGHTNESS_UP:
      return "BRIGHTNESS_UP";
    case KeyboardCode::KBD_BRIGHTNESS_DOWN:
      return "KBD_BRIGHTNESS_DOWN";
    case KeyboardCode::OEM_4:
      return "OEM_4";
    case KeyboardCode::OEM_5:
      return "OEM_5";
    case KeyboardCode::OEM_6:
      return "OEM_6";
    case KeyboardCode::OEM_7:
      return "OEM_7";
    case KeyboardCode::OEM_8:
      return "OEM_8";
    case KeyboardCode::ALTGR:
      return "ALTGR";
    case KeyboardCode::OEM_102:
      return "OEM_102";
    case KeyboardCode::PROCESSKEY:
      return "PROCESSKEY";
    case KeyboardCode::COMPOSE:
      return "COMPOSE";
    case KeyboardCode::PACKET:
      return "PACKET";
    case KeyboardCode::KBD_BRIGHTNESS_UP:
      return "KBD_BRIGHTNESS_UP";
    case KeyboardCode::DBE_SBCSCHAR:
      return "DBE_SBCSCHAR";
    case KeyboardCode::DBE_DBCSCHAR:
      return "DBE_DBCSCHAR";
    case KeyboardCode::ATTN:
      return "ATTN";
    case KeyboardCode::CRSEL:
      return "CRSEL";
    case KeyboardCode::EXSEL:
      return "EXSEL";
    case KeyboardCode::EREOF:
      return "EREOF";
    case KeyboardCode::PLAY:
      return "PLAY";
    case KeyboardCode::ZOOM:
      return "ZOOM";
    case KeyboardCode::NONAME:
      return "NONAME";
    case KeyboardCode::PA1:
      return "PA1";
    case KeyboardCode::OEM_CLEAR:
      return "OEM_CLEAR";
    default:
      return nullptr;
  }
}

std::string KeyboardCodeToString(KeyboardCode value) {
  const char *str = KeyboardCodeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown KeyboardCode value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, KeyboardCode value) {
  return os << KeyboardCodeToString(value);
}

namespace internal {

}  // namespace internal
}  // namespace mojom
}  // namespace ui

namespace perfetto {

// static
void TraceFormatTraits<::ui::mojom::KeyboardCode>::WriteIntoTrace(
   perfetto::TracedValue context, ::ui::mojom::KeyboardCode value) {
  return std::move(context).WriteString(::ui::mojom::KeyboardCodeToString(value));
}

} // namespace perfetto