// ui/events/mojom/event.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_EVENTS_MOJOM_EVENT_MOJOM_H_
#define UI_EVENTS_MOJOM_EVENT_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/events/mojom/event.mojom-features.h"  // IWYU pragma: export
#include "ui/events/mojom/event.mojom-shared.h"  // IWYU pragma: export
#include "ui/events/mojom/event.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/time.mojom.h"
#include "ui/events/mojom/event_constants.mojom.h"
#include "ui/events/mojom/keyboard_codes.mojom-forward.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include "ui/latency/mojom/latency_info.mojom.h"
#include <string>
#include <vector>




#include "mojo/public/cpp/bindings/lib/native_enum_serialization.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"
#include "ui/events/event.h"




namespace ui::mojom {





class  KeyData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<KeyData, T>::value>;
  using DataView = KeyDataDataView;
  using Data_ = internal::KeyData_Data;

  template <typename... Args>
  static KeyDataPtr New(Args&&... args) {
    return KeyDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static KeyDataPtr From(const U& u) {
    return mojo::TypeConverter<KeyDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, KeyData>::Convert(*this);
  }


  KeyData();

  KeyData(
      int32_t key_code,
      uint32_t dom_code,
      int32_t dom_key,
      bool is_char);


  ~KeyData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = KeyDataPtr>
  KeyDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, KeyData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, KeyData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, KeyData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        KeyData::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        KeyData::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        KeyData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::KeyData_UnserializedMessageContext<
            UserType, KeyData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<KeyData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return KeyData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::KeyData_UnserializedMessageContext<
            UserType, KeyData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<KeyData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t key_code;
  
  uint32_t dom_code;
  
  int32_t dom_key;
  
  bool is_char;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, KeyData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, KeyData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, KeyData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, KeyData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class  GesturePinchData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<GesturePinchData, T>::value>;
  using DataView = GesturePinchDataDataView;
  using Data_ = internal::GesturePinchData_Data;

  template <typename... Args>
  static GesturePinchDataPtr New(Args&&... args) {
    return GesturePinchDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static GesturePinchDataPtr From(const U& u) {
    return mojo::TypeConverter<GesturePinchDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, GesturePinchData>::Convert(*this);
  }


  GesturePinchData();

  explicit GesturePinchData(
      float scale);


  ~GesturePinchData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = GesturePinchDataPtr>
  GesturePinchDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, GesturePinchData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, GesturePinchData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, GesturePinchData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GesturePinchData::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GesturePinchData::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        GesturePinchData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::GesturePinchData_UnserializedMessageContext<
            UserType, GesturePinchData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<GesturePinchData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return GesturePinchData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::GesturePinchData_UnserializedMessageContext<
            UserType, GesturePinchData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<GesturePinchData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  float scale;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, GesturePinchData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, GesturePinchData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, GesturePinchData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, GesturePinchData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  GestureSwipeData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<GestureSwipeData, T>::value>;
  using DataView = GestureSwipeDataDataView;
  using Data_ = internal::GestureSwipeData_Data;

  template <typename... Args>
  static GestureSwipeDataPtr New(Args&&... args) {
    return GestureSwipeDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static GestureSwipeDataPtr From(const U& u) {
    return mojo::TypeConverter<GestureSwipeDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, GestureSwipeData>::Convert(*this);
  }


  GestureSwipeData();

  GestureSwipeData(
      bool left,
      bool right,
      bool up,
      bool down);


  ~GestureSwipeData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = GestureSwipeDataPtr>
  GestureSwipeDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, GestureSwipeData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, GestureSwipeData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, GestureSwipeData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GestureSwipeData::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GestureSwipeData::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        GestureSwipeData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::GestureSwipeData_UnserializedMessageContext<
            UserType, GestureSwipeData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<GestureSwipeData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return GestureSwipeData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::GestureSwipeData_UnserializedMessageContext<
            UserType, GestureSwipeData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<GestureSwipeData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool left;
  
  bool right;
  
  bool up;
  
  bool down;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, GestureSwipeData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, GestureSwipeData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, GestureSwipeData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, GestureSwipeData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}











class  GestureDataDetails {
 public:
  using DataView = GestureDataDetailsDataView;
  using Data_ = internal::GestureDataDetails_Data;
  using Tag = Data_::GestureDataDetails_Tag;

  template <typename... Args>
  static GestureDataDetailsPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |pinch|.
  static GestureDataDetailsPtr NewPinch(
      GesturePinchDataPtr value);
  // Construct an instance holding |swipe|.
  static GestureDataDetailsPtr NewSwipe(
      GestureSwipeDataPtr value);

  template <typename U>
  static GestureDataDetailsPtr From(const U& u) {
    return mojo::TypeConverter<GestureDataDetailsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, GestureDataDetails>::Convert(*this);
  }
  ~GestureDataDetails();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  GestureDataDetails(const GestureDataDetails& other) = delete;
  GestureDataDetails& operator=(const GestureDataDetails& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = GestureDataDetailsPtr>
  GestureDataDetailsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, GestureDataDetails>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, GestureDataDetails>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }
  size_t Hash(size_t seed) const;

  Tag which() const {
    return tag_;
  }

  bool is_pinch() const { return tag_ == Tag::kPinch; }
  const GesturePinchDataPtr& get_pinch() const {
    CHECK(tag_ == Tag::kPinch);
    return data_.pinch;
  }
  GesturePinchDataPtr& get_pinch() {
    CHECK(tag_ == Tag::kPinch);
    return data_.pinch;
  }
  void set_pinch(GesturePinchDataPtr pinch);

  bool is_swipe() const { return tag_ == Tag::kSwipe; }
  const GestureSwipeDataPtr& get_swipe() const {
    CHECK(tag_ == Tag::kSwipe);
    return data_.swipe;
  }
  GestureSwipeDataPtr& get_swipe() {
    CHECK(tag_ == Tag::kSwipe);
    return data_.swipe;
  }
  void set_swipe(GestureSwipeDataPtr swipe);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        GestureDataDetails::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<GestureDataDetails::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kPinch)>,
        GesturePinchDataPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kSwipe)>,
        GestureSwipeDataPtr value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    GesturePinchDataPtr pinch;
    GestureSwipeDataPtr swipe;
  };

  GestureDataDetails(
      std::in_place_index_t<static_cast<size_t>(Tag::kPinch)>,
      GesturePinchDataPtr value);
  GestureDataDetails(
      std::in_place_index_t<static_cast<size_t>(Tag::kSwipe)>,
      GestureSwipeDataPtr value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};






class  LocationData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<LocationData, T>::value>;
  using DataView = LocationDataDataView;
  using Data_ = internal::LocationData_Data;

  template <typename... Args>
  static LocationDataPtr New(Args&&... args) {
    return LocationDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static LocationDataPtr From(const U& u) {
    return mojo::TypeConverter<LocationDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, LocationData>::Convert(*this);
  }


  LocationData();

  LocationData(
      const ::gfx::PointF& relative_location,
      const ::gfx::PointF& root_location);


  ~LocationData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = LocationDataPtr>
  LocationDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, LocationData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, LocationData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, LocationData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        LocationData::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        LocationData::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        LocationData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::LocationData_UnserializedMessageContext<
            UserType, LocationData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<LocationData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return LocationData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::LocationData_UnserializedMessageContext<
            UserType, LocationData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<LocationData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::gfx::PointF relative_location;
  
  ::gfx::PointF root_location;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, LocationData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, LocationData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, LocationData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, LocationData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class  GestureData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<GestureData, T>::value>;
  using DataView = GestureDataDataView;
  using Data_ = internal::GestureData_Data;

  template <typename... Args>
  static GestureDataPtr New(Args&&... args) {
    return GestureDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static GestureDataPtr From(const U& u) {
    return mojo::TypeConverter<GestureDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, GestureData>::Convert(*this);
  }


  GestureData();

  GestureData(
      LocationDataPtr location,
      ::ui::GestureDeviceType device_type,
      GestureDataDetailsPtr details);

GestureData(const GestureData&) = delete;
GestureData& operator=(const GestureData&) = delete;

  ~GestureData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = GestureDataPtr>
  GestureDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, GestureData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, GestureData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, GestureData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GestureData::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GestureData::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        GestureData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::GestureData_UnserializedMessageContext<
            UserType, GestureData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<GestureData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return GestureData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::GestureData_UnserializedMessageContext<
            UserType, GestureData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<GestureData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  LocationDataPtr location;
  
  ::ui::GestureDeviceType device_type;
  
  GestureDataDetailsPtr details;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, GestureData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, GestureData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, GestureData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, GestureData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  ScrollData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ScrollData, T>::value>;
  using DataView = ScrollDataDataView;
  using Data_ = internal::ScrollData_Data;

  template <typename... Args>
  static ScrollDataPtr New(Args&&... args) {
    return ScrollDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ScrollDataPtr From(const U& u) {
    return mojo::TypeConverter<ScrollDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ScrollData>::Convert(*this);
  }


  ScrollData();

  ScrollData(
      LocationDataPtr location,
      float x_offset,
      float y_offset,
      float x_offset_ordinal,
      float y_offset_ordinal,
      int32_t finger_count,
      ::ui::EventMomentumPhase momentum_phase,
      ::ui::ScrollEventPhase scroll_event_phase);

ScrollData(const ScrollData&) = delete;
ScrollData& operator=(const ScrollData&) = delete;

  ~ScrollData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ScrollDataPtr>
  ScrollDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ScrollData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ScrollData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ScrollData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ScrollData::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ScrollData::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ScrollData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ScrollData_UnserializedMessageContext<
            UserType, ScrollData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ScrollData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ScrollData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ScrollData_UnserializedMessageContext<
            UserType, ScrollData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ScrollData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  LocationDataPtr location;
  
  float x_offset;
  
  float y_offset;
  
  float x_offset_ordinal;
  
  float y_offset_ordinal;
  
  int32_t finger_count;
  
  ::ui::EventMomentumPhase momentum_phase;
  
  ::ui::ScrollEventPhase scroll_event_phase;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ScrollData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ScrollData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ScrollData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ScrollData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  PointerDetails {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PointerDetails, T>::value>;
  using DataView = PointerDetailsDataView;
  using Data_ = internal::PointerDetails_Data;

  template <typename... Args>
  static PointerDetailsPtr New(Args&&... args) {
    return PointerDetailsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PointerDetailsPtr From(const U& u) {
    return mojo::TypeConverter<PointerDetailsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PointerDetails>::Convert(*this);
  }


  PointerDetails();

  PointerDetails(
      ::ui::EventPointerType pointer_type,
      float radius_x,
      float radius_y,
      float force,
      float tilt_x,
      float tilt_y,
      float tangential_pressure,
      float twist,
      int32_t id,
      int32_t offset_x,
      int32_t offset_y);


  ~PointerDetails();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PointerDetailsPtr>
  PointerDetailsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PointerDetails::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PointerDetails::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PointerDetails::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PointerDetails::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PointerDetails::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PointerDetails::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PointerDetails_UnserializedMessageContext<
            UserType, PointerDetails::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PointerDetails::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PointerDetails::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PointerDetails_UnserializedMessageContext<
            UserType, PointerDetails::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PointerDetails::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::ui::EventPointerType pointer_type;
  
  float radius_x;
  
  float radius_y;
  
  float force;
  
  float tilt_x;
  
  float tilt_y;
  
  float tangential_pressure;
  
  float twist;
  
  int32_t id;
  
  int32_t offset_x;
  
  int32_t offset_y;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PointerDetails::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PointerDetails::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PointerDetails::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PointerDetails::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  MouseData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<MouseData, T>::value>;
  using DataView = MouseDataDataView;
  using Data_ = internal::MouseData_Data;

  template <typename... Args>
  static MouseDataPtr New(Args&&... args) {
    return MouseDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static MouseDataPtr From(const U& u) {
    return mojo::TypeConverter<MouseDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, MouseData>::Convert(*this);
  }


  MouseData();

  MouseData(
      int32_t changed_button_flags,
      LocationDataPtr location,
      const ::ui::PointerDetails& pointer_details,
      const ::gfx::Vector2d& wheel_offset,
      const ::gfx::Vector2d& tick_120ths);

MouseData(const MouseData&) = delete;
MouseData& operator=(const MouseData&) = delete;

  ~MouseData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = MouseDataPtr>
  MouseDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, MouseData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, MouseData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, MouseData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        MouseData::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        MouseData::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        MouseData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::MouseData_UnserializedMessageContext<
            UserType, MouseData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<MouseData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return MouseData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::MouseData_UnserializedMessageContext<
            UserType, MouseData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<MouseData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t changed_button_flags;
  
  LocationDataPtr location;
  
  ::ui::PointerDetails pointer_details;
  
  ::gfx::Vector2d wheel_offset;
  
  ::gfx::Vector2d tick_120ths;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, MouseData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, MouseData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, MouseData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, MouseData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  TouchData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TouchData, T>::value>;
  using DataView = TouchDataDataView;
  using Data_ = internal::TouchData_Data;

  template <typename... Args>
  static TouchDataPtr New(Args&&... args) {
    return TouchDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TouchDataPtr From(const U& u) {
    return mojo::TypeConverter<TouchDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TouchData>::Convert(*this);
  }


  TouchData();

  TouchData(
      bool may_cause_scrolling,
      bool hovering,
      LocationDataPtr location,
      const ::ui::PointerDetails& pointer_details);

TouchData(const TouchData&) = delete;
TouchData& operator=(const TouchData&) = delete;

  ~TouchData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TouchDataPtr>
  TouchDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TouchData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, TouchData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, TouchData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TouchData::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TouchData::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TouchData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TouchData_UnserializedMessageContext<
            UserType, TouchData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<TouchData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return TouchData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TouchData_UnserializedMessageContext<
            UserType, TouchData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TouchData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool may_cause_scrolling;
  
  bool hovering;
  
  LocationDataPtr location;
  
  ::ui::PointerDetails pointer_details;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TouchData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TouchData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TouchData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TouchData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  Event {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Event, T>::value>;
  using DataView = EventDataView;
  using Data_ = internal::Event_Data;

  template <typename... Args>
  static EventPtr New(Args&&... args) {
    return EventPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static EventPtr From(const U& u) {
    return mojo::TypeConverter<EventPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Event>::Convert(*this);
  }


  Event();

  Event(
      ::ui::mojom::EventType action,
      int32_t flags,
      ::base::TimeTicks time_stamp,
      const ::ui::LatencyInfo& latency,
      KeyDataPtr key_data,
      GestureDataPtr gesture_data,
      ScrollDataPtr scroll_data,
      TouchDataPtr touch_data,
      MouseDataPtr mouse_data,
      const std::optional<base::flat_map<std::string, std::vector<uint8_t>>>& properties);

Event(const Event&) = delete;
Event& operator=(const Event&) = delete;

  ~Event();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = EventPtr>
  EventPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Event::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Event::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Event::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Event::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Event::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Event::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Event_UnserializedMessageContext<
            UserType, Event::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Event::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Event::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Event_UnserializedMessageContext<
            UserType, Event::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Event::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::ui::mojom::EventType action;
  
  int32_t flags;
  
  ::base::TimeTicks time_stamp;
  
  ::ui::LatencyInfo latency;
  
  KeyDataPtr key_data;
  
  GestureDataPtr gesture_data;
  
  ScrollDataPtr scroll_data;
  
  TouchDataPtr touch_data;
  
  MouseDataPtr mouse_data;
  
  std::optional<base::flat_map<std::string, std::vector<uint8_t>>> properties;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Event::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Event::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Event::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Event::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
GestureDataDetailsPtr GestureDataDetails::Clone() const {
  switch (tag_) {
    case Tag::kPinch:
      return NewPinch(
          mojo::Clone(data_.pinch));
    case Tag::kSwipe:
      return NewSwipe(
          mojo::Clone(data_.swipe));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, GestureDataDetails>::value>::type*>
bool GestureDataDetails::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kPinch:
      return mojo::Equals(data_.pinch, other.data_.pinch);
    case Tag::kSwipe:
      return mojo::Equals(data_.swipe, other.data_.swipe);
  }

  return false;
}
template <typename StructPtrType>
KeyDataPtr KeyData::Clone() const {
  return New(
      mojo::Clone(key_code),
      mojo::Clone(dom_code),
      mojo::Clone(dom_key),
      mojo::Clone(is_char)
  );
}

template <typename T, KeyData::EnableIfSame<T>*>
bool KeyData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->key_code, other_struct.key_code))
    return false;
  if (!mojo::Equals(this->dom_code, other_struct.dom_code))
    return false;
  if (!mojo::Equals(this->dom_key, other_struct.dom_key))
    return false;
  if (!mojo::Equals(this->is_char, other_struct.is_char))
    return false;
  return true;
}

template <typename T, KeyData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.key_code < rhs.key_code)
    return true;
  if (rhs.key_code < lhs.key_code)
    return false;
  if (lhs.dom_code < rhs.dom_code)
    return true;
  if (rhs.dom_code < lhs.dom_code)
    return false;
  if (lhs.dom_key < rhs.dom_key)
    return true;
  if (rhs.dom_key < lhs.dom_key)
    return false;
  if (lhs.is_char < rhs.is_char)
    return true;
  if (rhs.is_char < lhs.is_char)
    return false;
  return false;
}
template <typename StructPtrType>
LocationDataPtr LocationData::Clone() const {
  return New(
      mojo::Clone(relative_location),
      mojo::Clone(root_location)
  );
}

template <typename T, LocationData::EnableIfSame<T>*>
bool LocationData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->relative_location, other_struct.relative_location))
    return false;
  if (!mojo::Equals(this->root_location, other_struct.root_location))
    return false;
  return true;
}

template <typename T, LocationData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.relative_location < rhs.relative_location)
    return true;
  if (rhs.relative_location < lhs.relative_location)
    return false;
  if (lhs.root_location < rhs.root_location)
    return true;
  if (rhs.root_location < lhs.root_location)
    return false;
  return false;
}
template <typename StructPtrType>
GesturePinchDataPtr GesturePinchData::Clone() const {
  return New(
      mojo::Clone(scale)
  );
}

template <typename T, GesturePinchData::EnableIfSame<T>*>
bool GesturePinchData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->scale, other_struct.scale))
    return false;
  return true;
}

template <typename T, GesturePinchData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.scale < rhs.scale)
    return true;
  if (rhs.scale < lhs.scale)
    return false;
  return false;
}
template <typename StructPtrType>
GestureSwipeDataPtr GestureSwipeData::Clone() const {
  return New(
      mojo::Clone(left),
      mojo::Clone(right),
      mojo::Clone(up),
      mojo::Clone(down)
  );
}

template <typename T, GestureSwipeData::EnableIfSame<T>*>
bool GestureSwipeData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->left, other_struct.left))
    return false;
  if (!mojo::Equals(this->right, other_struct.right))
    return false;
  if (!mojo::Equals(this->up, other_struct.up))
    return false;
  if (!mojo::Equals(this->down, other_struct.down))
    return false;
  return true;
}

template <typename T, GestureSwipeData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.left < rhs.left)
    return true;
  if (rhs.left < lhs.left)
    return false;
  if (lhs.right < rhs.right)
    return true;
  if (rhs.right < lhs.right)
    return false;
  if (lhs.up < rhs.up)
    return true;
  if (rhs.up < lhs.up)
    return false;
  if (lhs.down < rhs.down)
    return true;
  if (rhs.down < lhs.down)
    return false;
  return false;
}
template <typename StructPtrType>
GestureDataPtr GestureData::Clone() const {
  return New(
      mojo::Clone(location),
      mojo::Clone(device_type),
      mojo::Clone(details)
  );
}

template <typename T, GestureData::EnableIfSame<T>*>
bool GestureData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->location, other_struct.location))
    return false;
  if (!mojo::Equals(this->device_type, other_struct.device_type))
    return false;
  if (!mojo::Equals(this->details, other_struct.details))
    return false;
  return true;
}

template <typename T, GestureData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.location < rhs.location)
    return true;
  if (rhs.location < lhs.location)
    return false;
  if (lhs.device_type < rhs.device_type)
    return true;
  if (rhs.device_type < lhs.device_type)
    return false;
  if (lhs.details < rhs.details)
    return true;
  if (rhs.details < lhs.details)
    return false;
  return false;
}
template <typename StructPtrType>
ScrollDataPtr ScrollData::Clone() const {
  return New(
      mojo::Clone(location),
      mojo::Clone(x_offset),
      mojo::Clone(y_offset),
      mojo::Clone(x_offset_ordinal),
      mojo::Clone(y_offset_ordinal),
      mojo::Clone(finger_count),
      mojo::Clone(momentum_phase),
      mojo::Clone(scroll_event_phase)
  );
}

template <typename T, ScrollData::EnableIfSame<T>*>
bool ScrollData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->location, other_struct.location))
    return false;
  if (!mojo::Equals(this->x_offset, other_struct.x_offset))
    return false;
  if (!mojo::Equals(this->y_offset, other_struct.y_offset))
    return false;
  if (!mojo::Equals(this->x_offset_ordinal, other_struct.x_offset_ordinal))
    return false;
  if (!mojo::Equals(this->y_offset_ordinal, other_struct.y_offset_ordinal))
    return false;
  if (!mojo::Equals(this->finger_count, other_struct.finger_count))
    return false;
  if (!mojo::Equals(this->momentum_phase, other_struct.momentum_phase))
    return false;
  if (!mojo::Equals(this->scroll_event_phase, other_struct.scroll_event_phase))
    return false;
  return true;
}

template <typename T, ScrollData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.location < rhs.location)
    return true;
  if (rhs.location < lhs.location)
    return false;
  if (lhs.x_offset < rhs.x_offset)
    return true;
  if (rhs.x_offset < lhs.x_offset)
    return false;
  if (lhs.y_offset < rhs.y_offset)
    return true;
  if (rhs.y_offset < lhs.y_offset)
    return false;
  if (lhs.x_offset_ordinal < rhs.x_offset_ordinal)
    return true;
  if (rhs.x_offset_ordinal < lhs.x_offset_ordinal)
    return false;
  if (lhs.y_offset_ordinal < rhs.y_offset_ordinal)
    return true;
  if (rhs.y_offset_ordinal < lhs.y_offset_ordinal)
    return false;
  if (lhs.finger_count < rhs.finger_count)
    return true;
  if (rhs.finger_count < lhs.finger_count)
    return false;
  if (lhs.momentum_phase < rhs.momentum_phase)
    return true;
  if (rhs.momentum_phase < lhs.momentum_phase)
    return false;
  if (lhs.scroll_event_phase < rhs.scroll_event_phase)
    return true;
  if (rhs.scroll_event_phase < lhs.scroll_event_phase)
    return false;
  return false;
}
template <typename StructPtrType>
PointerDetailsPtr PointerDetails::Clone() const {
  return New(
      mojo::Clone(pointer_type),
      mojo::Clone(radius_x),
      mojo::Clone(radius_y),
      mojo::Clone(force),
      mojo::Clone(tilt_x),
      mojo::Clone(tilt_y),
      mojo::Clone(tangential_pressure),
      mojo::Clone(twist),
      mojo::Clone(id),
      mojo::Clone(offset_x),
      mojo::Clone(offset_y)
  );
}

template <typename T, PointerDetails::EnableIfSame<T>*>
bool PointerDetails::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->pointer_type, other_struct.pointer_type))
    return false;
  if (!mojo::Equals(this->radius_x, other_struct.radius_x))
    return false;
  if (!mojo::Equals(this->radius_y, other_struct.radius_y))
    return false;
  if (!mojo::Equals(this->force, other_struct.force))
    return false;
  if (!mojo::Equals(this->tilt_x, other_struct.tilt_x))
    return false;
  if (!mojo::Equals(this->tilt_y, other_struct.tilt_y))
    return false;
  if (!mojo::Equals(this->tangential_pressure, other_struct.tangential_pressure))
    return false;
  if (!mojo::Equals(this->twist, other_struct.twist))
    return false;
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->offset_x, other_struct.offset_x))
    return false;
  if (!mojo::Equals(this->offset_y, other_struct.offset_y))
    return false;
  return true;
}

template <typename T, PointerDetails::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.pointer_type < rhs.pointer_type)
    return true;
  if (rhs.pointer_type < lhs.pointer_type)
    return false;
  if (lhs.radius_x < rhs.radius_x)
    return true;
  if (rhs.radius_x < lhs.radius_x)
    return false;
  if (lhs.radius_y < rhs.radius_y)
    return true;
  if (rhs.radius_y < lhs.radius_y)
    return false;
  if (lhs.force < rhs.force)
    return true;
  if (rhs.force < lhs.force)
    return false;
  if (lhs.tilt_x < rhs.tilt_x)
    return true;
  if (rhs.tilt_x < lhs.tilt_x)
    return false;
  if (lhs.tilt_y < rhs.tilt_y)
    return true;
  if (rhs.tilt_y < lhs.tilt_y)
    return false;
  if (lhs.tangential_pressure < rhs.tangential_pressure)
    return true;
  if (rhs.tangential_pressure < lhs.tangential_pressure)
    return false;
  if (lhs.twist < rhs.twist)
    return true;
  if (rhs.twist < lhs.twist)
    return false;
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.offset_x < rhs.offset_x)
    return true;
  if (rhs.offset_x < lhs.offset_x)
    return false;
  if (lhs.offset_y < rhs.offset_y)
    return true;
  if (rhs.offset_y < lhs.offset_y)
    return false;
  return false;
}
template <typename StructPtrType>
MouseDataPtr MouseData::Clone() const {
  return New(
      mojo::Clone(changed_button_flags),
      mojo::Clone(location),
      mojo::Clone(pointer_details),
      mojo::Clone(wheel_offset),
      mojo::Clone(tick_120ths)
  );
}

template <typename T, MouseData::EnableIfSame<T>*>
bool MouseData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->changed_button_flags, other_struct.changed_button_flags))
    return false;
  if (!mojo::Equals(this->location, other_struct.location))
    return false;
  if (!mojo::Equals(this->pointer_details, other_struct.pointer_details))
    return false;
  if (!mojo::Equals(this->wheel_offset, other_struct.wheel_offset))
    return false;
  if (!mojo::Equals(this->tick_120ths, other_struct.tick_120ths))
    return false;
  return true;
}

template <typename T, MouseData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.changed_button_flags < rhs.changed_button_flags)
    return true;
  if (rhs.changed_button_flags < lhs.changed_button_flags)
    return false;
  if (lhs.location < rhs.location)
    return true;
  if (rhs.location < lhs.location)
    return false;
  if (lhs.pointer_details < rhs.pointer_details)
    return true;
  if (rhs.pointer_details < lhs.pointer_details)
    return false;
  if (lhs.wheel_offset < rhs.wheel_offset)
    return true;
  if (rhs.wheel_offset < lhs.wheel_offset)
    return false;
  if (lhs.tick_120ths < rhs.tick_120ths)
    return true;
  if (rhs.tick_120ths < lhs.tick_120ths)
    return false;
  return false;
}
template <typename StructPtrType>
TouchDataPtr TouchData::Clone() const {
  return New(
      mojo::Clone(may_cause_scrolling),
      mojo::Clone(hovering),
      mojo::Clone(location),
      mojo::Clone(pointer_details)
  );
}

template <typename T, TouchData::EnableIfSame<T>*>
bool TouchData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->may_cause_scrolling, other_struct.may_cause_scrolling))
    return false;
  if (!mojo::Equals(this->hovering, other_struct.hovering))
    return false;
  if (!mojo::Equals(this->location, other_struct.location))
    return false;
  if (!mojo::Equals(this->pointer_details, other_struct.pointer_details))
    return false;
  return true;
}

template <typename T, TouchData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.may_cause_scrolling < rhs.may_cause_scrolling)
    return true;
  if (rhs.may_cause_scrolling < lhs.may_cause_scrolling)
    return false;
  if (lhs.hovering < rhs.hovering)
    return true;
  if (rhs.hovering < lhs.hovering)
    return false;
  if (lhs.location < rhs.location)
    return true;
  if (rhs.location < lhs.location)
    return false;
  if (lhs.pointer_details < rhs.pointer_details)
    return true;
  if (rhs.pointer_details < lhs.pointer_details)
    return false;
  return false;
}
template <typename StructPtrType>
EventPtr Event::Clone() const {
  return New(
      mojo::Clone(action),
      mojo::Clone(flags),
      mojo::Clone(time_stamp),
      mojo::Clone(latency),
      mojo::Clone(key_data),
      mojo::Clone(gesture_data),
      mojo::Clone(scroll_data),
      mojo::Clone(touch_data),
      mojo::Clone(mouse_data),
      mojo::Clone(properties)
  );
}

template <typename T, Event::EnableIfSame<T>*>
bool Event::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->action, other_struct.action))
    return false;
  if (!mojo::Equals(this->flags, other_struct.flags))
    return false;
  if (!mojo::Equals(this->time_stamp, other_struct.time_stamp))
    return false;
  if (!mojo::Equals(this->latency, other_struct.latency))
    return false;
  if (!mojo::Equals(this->key_data, other_struct.key_data))
    return false;
  if (!mojo::Equals(this->gesture_data, other_struct.gesture_data))
    return false;
  if (!mojo::Equals(this->scroll_data, other_struct.scroll_data))
    return false;
  if (!mojo::Equals(this->touch_data, other_struct.touch_data))
    return false;
  if (!mojo::Equals(this->mouse_data, other_struct.mouse_data))
    return false;
  if (!mojo::Equals(this->properties, other_struct.properties))
    return false;
  return true;
}

template <typename T, Event::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.action < rhs.action)
    return true;
  if (rhs.action < lhs.action)
    return false;
  if (lhs.flags < rhs.flags)
    return true;
  if (rhs.flags < lhs.flags)
    return false;
  if (lhs.time_stamp < rhs.time_stamp)
    return true;
  if (rhs.time_stamp < lhs.time_stamp)
    return false;
  if (lhs.latency < rhs.latency)
    return true;
  if (rhs.latency < lhs.latency)
    return false;
  if (lhs.key_data < rhs.key_data)
    return true;
  if (rhs.key_data < lhs.key_data)
    return false;
  if (lhs.gesture_data < rhs.gesture_data)
    return true;
  if (rhs.gesture_data < lhs.gesture_data)
    return false;
  if (lhs.scroll_data < rhs.scroll_data)
    return true;
  if (rhs.scroll_data < lhs.scroll_data)
    return false;
  if (lhs.touch_data < rhs.touch_data)
    return true;
  if (rhs.touch_data < lhs.touch_data)
    return false;
  if (lhs.mouse_data < rhs.mouse_data)
    return true;
  if (rhs.mouse_data < lhs.mouse_data)
    return false;
  if (lhs.properties < rhs.properties)
    return true;
  if (rhs.properties < lhs.properties)
    return false;
  return false;
}


}  // ui::mojom

namespace mojo {


template <>
struct  StructTraits<::ui::mojom::KeyData::DataView,
                                         ::ui::mojom::KeyDataPtr> {
  static bool IsNull(const ::ui::mojom::KeyDataPtr& input) { return !input; }
  static void SetToNull(::ui::mojom::KeyDataPtr* output) { output->reset(); }

  static decltype(::ui::mojom::KeyData::key_code) key_code(
      const ::ui::mojom::KeyDataPtr& input) {
    return input->key_code;
  }

  static decltype(::ui::mojom::KeyData::dom_code) dom_code(
      const ::ui::mojom::KeyDataPtr& input) {
    return input->dom_code;
  }

  static decltype(::ui::mojom::KeyData::dom_key) dom_key(
      const ::ui::mojom::KeyDataPtr& input) {
    return input->dom_key;
  }

  static decltype(::ui::mojom::KeyData::is_char) is_char(
      const ::ui::mojom::KeyDataPtr& input) {
    return input->is_char;
  }

  static bool Read(::ui::mojom::KeyData::DataView input, ::ui::mojom::KeyDataPtr* output);
};


template <>
struct  StructTraits<::ui::mojom::LocationData::DataView,
                                         ::ui::mojom::LocationDataPtr> {
  static bool IsNull(const ::ui::mojom::LocationDataPtr& input) { return !input; }
  static void SetToNull(::ui::mojom::LocationDataPtr* output) { output->reset(); }

  static const decltype(::ui::mojom::LocationData::relative_location)& relative_location(
      const ::ui::mojom::LocationDataPtr& input) {
    return input->relative_location;
  }

  static const decltype(::ui::mojom::LocationData::root_location)& root_location(
      const ::ui::mojom::LocationDataPtr& input) {
    return input->root_location;
  }

  static bool Read(::ui::mojom::LocationData::DataView input, ::ui::mojom::LocationDataPtr* output);
};


template <>
struct  StructTraits<::ui::mojom::GesturePinchData::DataView,
                                         ::ui::mojom::GesturePinchDataPtr> {
  static bool IsNull(const ::ui::mojom::GesturePinchDataPtr& input) { return !input; }
  static void SetToNull(::ui::mojom::GesturePinchDataPtr* output) { output->reset(); }

  static decltype(::ui::mojom::GesturePinchData::scale) scale(
      const ::ui::mojom::GesturePinchDataPtr& input) {
    return input->scale;
  }

  static bool Read(::ui::mojom::GesturePinchData::DataView input, ::ui::mojom::GesturePinchDataPtr* output);
};


template <>
struct  StructTraits<::ui::mojom::GestureSwipeData::DataView,
                                         ::ui::mojom::GestureSwipeDataPtr> {
  static bool IsNull(const ::ui::mojom::GestureSwipeDataPtr& input) { return !input; }
  static void SetToNull(::ui::mojom::GestureSwipeDataPtr* output) { output->reset(); }

  static decltype(::ui::mojom::GestureSwipeData::left) left(
      const ::ui::mojom::GestureSwipeDataPtr& input) {
    return input->left;
  }

  static decltype(::ui::mojom::GestureSwipeData::right) right(
      const ::ui::mojom::GestureSwipeDataPtr& input) {
    return input->right;
  }

  static decltype(::ui::mojom::GestureSwipeData::up) up(
      const ::ui::mojom::GestureSwipeDataPtr& input) {
    return input->up;
  }

  static decltype(::ui::mojom::GestureSwipeData::down) down(
      const ::ui::mojom::GestureSwipeDataPtr& input) {
    return input->down;
  }

  static bool Read(::ui::mojom::GestureSwipeData::DataView input, ::ui::mojom::GestureSwipeDataPtr* output);
};


template <>
struct  StructTraits<::ui::mojom::GestureData::DataView,
                                         ::ui::mojom::GestureDataPtr> {
  static bool IsNull(const ::ui::mojom::GestureDataPtr& input) { return !input; }
  static void SetToNull(::ui::mojom::GestureDataPtr* output) { output->reset(); }

  static const decltype(::ui::mojom::GestureData::location)& location(
      const ::ui::mojom::GestureDataPtr& input) {
    return input->location;
  }

  static decltype(::ui::mojom::GestureData::device_type) device_type(
      const ::ui::mojom::GestureDataPtr& input) {
    return input->device_type;
  }

  static const decltype(::ui::mojom::GestureData::details)& details(
      const ::ui::mojom::GestureDataPtr& input) {
    return input->details;
  }

  static bool Read(::ui::mojom::GestureData::DataView input, ::ui::mojom::GestureDataPtr* output);
};


template <>
struct  StructTraits<::ui::mojom::ScrollData::DataView,
                                         ::ui::mojom::ScrollDataPtr> {
  static bool IsNull(const ::ui::mojom::ScrollDataPtr& input) { return !input; }
  static void SetToNull(::ui::mojom::ScrollDataPtr* output) { output->reset(); }

  static const decltype(::ui::mojom::ScrollData::location)& location(
      const ::ui::mojom::ScrollDataPtr& input) {
    return input->location;
  }

  static decltype(::ui::mojom::ScrollData::x_offset) x_offset(
      const ::ui::mojom::ScrollDataPtr& input) {
    return input->x_offset;
  }

  static decltype(::ui::mojom::ScrollData::y_offset) y_offset(
      const ::ui::mojom::ScrollDataPtr& input) {
    return input->y_offset;
  }

  static decltype(::ui::mojom::ScrollData::x_offset_ordinal) x_offset_ordinal(
      const ::ui::mojom::ScrollDataPtr& input) {
    return input->x_offset_ordinal;
  }

  static decltype(::ui::mojom::ScrollData::y_offset_ordinal) y_offset_ordinal(
      const ::ui::mojom::ScrollDataPtr& input) {
    return input->y_offset_ordinal;
  }

  static decltype(::ui::mojom::ScrollData::finger_count) finger_count(
      const ::ui::mojom::ScrollDataPtr& input) {
    return input->finger_count;
  }

  static decltype(::ui::mojom::ScrollData::momentum_phase) momentum_phase(
      const ::ui::mojom::ScrollDataPtr& input) {
    return input->momentum_phase;
  }

  static decltype(::ui::mojom::ScrollData::scroll_event_phase) scroll_event_phase(
      const ::ui::mojom::ScrollDataPtr& input) {
    return input->scroll_event_phase;
  }

  static bool Read(::ui::mojom::ScrollData::DataView input, ::ui::mojom::ScrollDataPtr* output);
};


template <>
struct  StructTraits<::ui::mojom::PointerDetails::DataView,
                                         ::ui::mojom::PointerDetailsPtr> {
  static bool IsNull(const ::ui::mojom::PointerDetailsPtr& input) { return !input; }
  static void SetToNull(::ui::mojom::PointerDetailsPtr* output) { output->reset(); }

  static decltype(::ui::mojom::PointerDetails::pointer_type) pointer_type(
      const ::ui::mojom::PointerDetailsPtr& input) {
    return input->pointer_type;
  }

  static decltype(::ui::mojom::PointerDetails::radius_x) radius_x(
      const ::ui::mojom::PointerDetailsPtr& input) {
    return input->radius_x;
  }

  static decltype(::ui::mojom::PointerDetails::radius_y) radius_y(
      const ::ui::mojom::PointerDetailsPtr& input) {
    return input->radius_y;
  }

  static decltype(::ui::mojom::PointerDetails::force) force(
      const ::ui::mojom::PointerDetailsPtr& input) {
    return input->force;
  }

  static decltype(::ui::mojom::PointerDetails::tilt_x) tilt_x(
      const ::ui::mojom::PointerDetailsPtr& input) {
    return input->tilt_x;
  }

  static decltype(::ui::mojom::PointerDetails::tilt_y) tilt_y(
      const ::ui::mojom::PointerDetailsPtr& input) {
    return input->tilt_y;
  }

  static decltype(::ui::mojom::PointerDetails::tangential_pressure) tangential_pressure(
      const ::ui::mojom::PointerDetailsPtr& input) {
    return input->tangential_pressure;
  }

  static decltype(::ui::mojom::PointerDetails::twist) twist(
      const ::ui::mojom::PointerDetailsPtr& input) {
    return input->twist;
  }

  static decltype(::ui::mojom::PointerDetails::id) id(
      const ::ui::mojom::PointerDetailsPtr& input) {
    return input->id;
  }

  static decltype(::ui::mojom::PointerDetails::offset_x) offset_x(
      const ::ui::mojom::PointerDetailsPtr& input) {
    return input->offset_x;
  }

  static decltype(::ui::mojom::PointerDetails::offset_y) offset_y(
      const ::ui::mojom::PointerDetailsPtr& input) {
    return input->offset_y;
  }

  static bool Read(::ui::mojom::PointerDetails::DataView input, ::ui::mojom::PointerDetailsPtr* output);
};


template <>
struct  StructTraits<::ui::mojom::MouseData::DataView,
                                         ::ui::mojom::MouseDataPtr> {
  static bool IsNull(const ::ui::mojom::MouseDataPtr& input) { return !input; }
  static void SetToNull(::ui::mojom::MouseDataPtr* output) { output->reset(); }

  static decltype(::ui::mojom::MouseData::changed_button_flags) changed_button_flags(
      const ::ui::mojom::MouseDataPtr& input) {
    return input->changed_button_flags;
  }

  static const decltype(::ui::mojom::MouseData::location)& location(
      const ::ui::mojom::MouseDataPtr& input) {
    return input->location;
  }

  static const decltype(::ui::mojom::MouseData::pointer_details)& pointer_details(
      const ::ui::mojom::MouseDataPtr& input) {
    return input->pointer_details;
  }

  static const decltype(::ui::mojom::MouseData::wheel_offset)& wheel_offset(
      const ::ui::mojom::MouseDataPtr& input) {
    return input->wheel_offset;
  }

  static const decltype(::ui::mojom::MouseData::tick_120ths)& tick_120ths(
      const ::ui::mojom::MouseDataPtr& input) {
    return input->tick_120ths;
  }

  static bool Read(::ui::mojom::MouseData::DataView input, ::ui::mojom::MouseDataPtr* output);
};


template <>
struct  StructTraits<::ui::mojom::TouchData::DataView,
                                         ::ui::mojom::TouchDataPtr> {
  static bool IsNull(const ::ui::mojom::TouchDataPtr& input) { return !input; }
  static void SetToNull(::ui::mojom::TouchDataPtr* output) { output->reset(); }

  static decltype(::ui::mojom::TouchData::may_cause_scrolling) may_cause_scrolling(
      const ::ui::mojom::TouchDataPtr& input) {
    return input->may_cause_scrolling;
  }

  static decltype(::ui::mojom::TouchData::hovering) hovering(
      const ::ui::mojom::TouchDataPtr& input) {
    return input->hovering;
  }

  static const decltype(::ui::mojom::TouchData::location)& location(
      const ::ui::mojom::TouchDataPtr& input) {
    return input->location;
  }

  static const decltype(::ui::mojom::TouchData::pointer_details)& pointer_details(
      const ::ui::mojom::TouchDataPtr& input) {
    return input->pointer_details;
  }

  static bool Read(::ui::mojom::TouchData::DataView input, ::ui::mojom::TouchDataPtr* output);
};


template <>
struct  StructTraits<::ui::mojom::Event::DataView,
                                         ::ui::mojom::EventPtr> {
  static bool IsNull(const ::ui::mojom::EventPtr& input) { return !input; }
  static void SetToNull(::ui::mojom::EventPtr* output) { output->reset(); }

  static decltype(::ui::mojom::Event::action) action(
      const ::ui::mojom::EventPtr& input) {
    return input->action;
  }

  static decltype(::ui::mojom::Event::flags) flags(
      const ::ui::mojom::EventPtr& input) {
    return input->flags;
  }

  static const decltype(::ui::mojom::Event::time_stamp)& time_stamp(
      const ::ui::mojom::EventPtr& input) {
    return input->time_stamp;
  }

  static const decltype(::ui::mojom::Event::latency)& latency(
      const ::ui::mojom::EventPtr& input) {
    return input->latency;
  }

  static const decltype(::ui::mojom::Event::key_data)& key_data(
      const ::ui::mojom::EventPtr& input) {
    return input->key_data;
  }

  static const decltype(::ui::mojom::Event::gesture_data)& gesture_data(
      const ::ui::mojom::EventPtr& input) {
    return input->gesture_data;
  }

  static const decltype(::ui::mojom::Event::scroll_data)& scroll_data(
      const ::ui::mojom::EventPtr& input) {
    return input->scroll_data;
  }

  static const decltype(::ui::mojom::Event::touch_data)& touch_data(
      const ::ui::mojom::EventPtr& input) {
    return input->touch_data;
  }

  static const decltype(::ui::mojom::Event::mouse_data)& mouse_data(
      const ::ui::mojom::EventPtr& input) {
    return input->mouse_data;
  }

  static const decltype(::ui::mojom::Event::properties)& properties(
      const ::ui::mojom::EventPtr& input) {
    return input->properties;
  }

  static bool Read(::ui::mojom::Event::DataView input, ::ui::mojom::EventPtr* output);
};


template <>
struct  UnionTraits<::ui::mojom::GestureDataDetails::DataView,
                                        ::ui::mojom::GestureDataDetailsPtr> {
  static bool IsNull(const ::ui::mojom::GestureDataDetailsPtr& input) { return !input; }
  static void SetToNull(::ui::mojom::GestureDataDetailsPtr* output) { output->reset(); }

  static ::ui::mojom::GestureDataDetails::Tag GetTag(const ::ui::mojom::GestureDataDetailsPtr& input) {
    return input->which();
  }

  static const ::ui::mojom::GesturePinchDataPtr& pinch(const ::ui::mojom::GestureDataDetailsPtr& input) {
    return input->get_pinch();
  }

  static const ::ui::mojom::GestureSwipeDataPtr& swipe(const ::ui::mojom::GestureDataDetailsPtr& input) {
    return input->get_swipe();
  }

  static bool Read(::ui::mojom::GestureDataDetails::DataView input, ::ui::mojom::GestureDataDetailsPtr* output);
};

}  // namespace mojo

#endif  // UI_EVENTS_MOJOM_EVENT_MOJOM_H_