// ui/events/mojom/event.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_EVENTS_MOJOM_EVENT_MOJOM_SEND_VALIDATION_H_
#define UI_EVENTS_MOJOM_EVENT_MOJOM_SEND_VALIDATION_H_

#include "ui/events/mojom/event.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "ui/events/mojom/event_constants.mojom-shared.h"
#include "ui/events/mojom/keyboard_codes.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/latency/mojom/latency_info.mojom-shared.h"

#include "ui/events/mojom/event.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::ui::mojom::KeyDataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::ui::mojom::KeyDataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::ui::mojom::internal::KeyData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->key_code = Traits::key_code(input);

      fragment->dom_code = Traits::dom_code(input);

      fragment->dom_key = Traits::dom_key(input);

      fragment->is_char = Traits::is_char(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::ui::mojom::LocationDataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::ui::mojom::LocationDataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::ui::mojom::internal::LocationData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::relative_location(input)) in_relative_location = Traits::relative_location(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->relative_location)::BaseType> relative_location_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::PointFDataView, send_validation>(
        in_relative_location,
        relative_location_fragment);

      fragment->relative_location.Set(
          relative_location_fragment.is_null() ? nullptr : relative_location_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->relative_location.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null relative_location in LocationData struct");

      decltype(Traits::root_location(input)) in_root_location = Traits::root_location(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->root_location)::BaseType> root_location_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::PointFDataView, send_validation>(
        in_root_location,
        root_location_fragment);

      fragment->root_location.Set(
          root_location_fragment.is_null() ? nullptr : root_location_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->root_location.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null root_location in LocationData struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::ui::mojom::GesturePinchDataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::ui::mojom::GesturePinchDataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::ui::mojom::internal::GesturePinchData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->scale = Traits::scale(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::ui::mojom::GestureSwipeDataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::ui::mojom::GestureSwipeDataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::ui::mojom::internal::GestureSwipeData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->left = Traits::left(input);

      fragment->right = Traits::right(input);

      fragment->up = Traits::up(input);

      fragment->down = Traits::down(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::ui::mojom::GestureDataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::ui::mojom::GestureDataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::ui::mojom::internal::GestureData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::location(input)) in_location = Traits::location(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->location)::BaseType> location_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::ui::mojom::LocationDataDataView, send_validation>(
        in_location,
        location_fragment);

      fragment->location.Set(
          location_fragment.is_null() ? nullptr : location_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->location.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null location in GestureData struct");

      
      mojo::internal::Serialize<::ui::mojom::GestureDeviceType>(
        Traits::device_type(input),
        &fragment->device_type);

      decltype(Traits::details(input)) in_details = Traits::details(input);
      mojo::internal::MessageFragment<decltype(fragment->details)>
          details_fragment(fragment.message());
      details_fragment.Claim(&fragment->details);
      
      mojo::internal::Serialize<::ui::mojom::GestureDataDetailsDataView, send_validation>(
        in_details,
        details_fragment,
        true);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::ui::mojom::ScrollDataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::ui::mojom::ScrollDataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::ui::mojom::internal::ScrollData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::location(input)) in_location = Traits::location(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->location)::BaseType> location_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::ui::mojom::LocationDataDataView, send_validation>(
        in_location,
        location_fragment);

      fragment->location.Set(
          location_fragment.is_null() ? nullptr : location_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->location.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null location in ScrollData struct");

      fragment->x_offset = Traits::x_offset(input);

      fragment->y_offset = Traits::y_offset(input);

      fragment->x_offset_ordinal = Traits::x_offset_ordinal(input);

      fragment->y_offset_ordinal = Traits::y_offset_ordinal(input);

      fragment->finger_count = Traits::finger_count(input);

      
      mojo::internal::Serialize<::ui::mojom::EventMomentumPhase>(
        Traits::momentum_phase(input),
        &fragment->momentum_phase);

      
      mojo::internal::Serialize<::ui::mojom::ScrollEventPhase>(
        Traits::scroll_event_phase(input),
        &fragment->scroll_event_phase);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::ui::mojom::PointerDetailsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::ui::mojom::PointerDetailsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::ui::mojom::internal::PointerDetails_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::ui::mojom::EventPointerType>(
        Traits::pointer_type(input),
        &fragment->pointer_type);

      fragment->radius_x = Traits::radius_x(input);

      fragment->radius_y = Traits::radius_y(input);

      fragment->force = Traits::force(input);

      fragment->tilt_x = Traits::tilt_x(input);

      fragment->tilt_y = Traits::tilt_y(input);

      fragment->tangential_pressure = Traits::tangential_pressure(input);

      fragment->twist = Traits::twist(input);

      fragment->id = Traits::id(input);

      fragment->offset_x = Traits::offset_x(input);

      fragment->offset_y = Traits::offset_y(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::ui::mojom::MouseDataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::ui::mojom::MouseDataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::ui::mojom::internal::MouseData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->changed_button_flags = Traits::changed_button_flags(input);

      decltype(Traits::location(input)) in_location = Traits::location(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->location)::BaseType> location_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::ui::mojom::LocationDataDataView, send_validation>(
        in_location,
        location_fragment);

      fragment->location.Set(
          location_fragment.is_null() ? nullptr : location_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->location.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null location in MouseData struct");

      decltype(Traits::pointer_details(input)) in_pointer_details = Traits::pointer_details(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->pointer_details)::BaseType> pointer_details_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::ui::mojom::PointerDetailsDataView, send_validation>(
        in_pointer_details,
        pointer_details_fragment);

      fragment->pointer_details.Set(
          pointer_details_fragment.is_null() ? nullptr : pointer_details_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->pointer_details.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null pointer_details in MouseData struct");

      decltype(Traits::wheel_offset(input)) in_wheel_offset = Traits::wheel_offset(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->wheel_offset)::BaseType> wheel_offset_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::Vector2dDataView, send_validation>(
        in_wheel_offset,
        wheel_offset_fragment);

      fragment->wheel_offset.Set(
          wheel_offset_fragment.is_null() ? nullptr : wheel_offset_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->wheel_offset.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null wheel_offset in MouseData struct");

      decltype(Traits::tick_120ths(input)) in_tick_120ths = Traits::tick_120ths(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->tick_120ths)::BaseType> tick_120ths_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::Vector2dDataView, send_validation>(
        in_tick_120ths,
        tick_120ths_fragment);

      fragment->tick_120ths.Set(
          tick_120ths_fragment.is_null() ? nullptr : tick_120ths_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->tick_120ths.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null tick_120ths in MouseData struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::ui::mojom::TouchDataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::ui::mojom::TouchDataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::ui::mojom::internal::TouchData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->may_cause_scrolling = Traits::may_cause_scrolling(input);

      fragment->hovering = Traits::hovering(input);

      decltype(Traits::location(input)) in_location = Traits::location(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->location)::BaseType> location_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::ui::mojom::LocationDataDataView, send_validation>(
        in_location,
        location_fragment);

      fragment->location.Set(
          location_fragment.is_null() ? nullptr : location_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->location.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null location in TouchData struct");

      decltype(Traits::pointer_details(input)) in_pointer_details = Traits::pointer_details(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->pointer_details)::BaseType> pointer_details_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::ui::mojom::PointerDetailsDataView, send_validation>(
        in_pointer_details,
        pointer_details_fragment);

      fragment->pointer_details.Set(
          pointer_details_fragment.is_null() ? nullptr : pointer_details_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->pointer_details.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null pointer_details in TouchData struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::ui::mojom::EventDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::ui::mojom::EventDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::ui::mojom::internal::Event_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::ui::mojom::EventType>(
        Traits::action(input),
        &fragment->action);

      fragment->flags = Traits::flags(input);

      decltype(Traits::time_stamp(input)) in_time_stamp = Traits::time_stamp(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->time_stamp)::BaseType> time_stamp_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView, send_validation>(
        in_time_stamp,
        time_stamp_fragment);

      fragment->time_stamp.Set(
          time_stamp_fragment.is_null() ? nullptr : time_stamp_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->time_stamp.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null time_stamp in Event struct");

      decltype(Traits::latency(input)) in_latency = Traits::latency(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->latency)::BaseType> latency_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::ui::mojom::LatencyInfoDataView, send_validation>(
        in_latency,
        latency_fragment);

      fragment->latency.Set(
          latency_fragment.is_null() ? nullptr : latency_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->latency.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null latency in Event struct");

      decltype(Traits::key_data(input)) in_key_data = Traits::key_data(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->key_data)::BaseType> key_data_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::ui::mojom::KeyDataDataView, send_validation>(
        in_key_data,
        key_data_fragment);

      fragment->key_data.Set(
          key_data_fragment.is_null() ? nullptr : key_data_fragment.data());

      decltype(Traits::gesture_data(input)) in_gesture_data = Traits::gesture_data(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->gesture_data)::BaseType> gesture_data_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::ui::mojom::GestureDataDataView, send_validation>(
        in_gesture_data,
        gesture_data_fragment);

      fragment->gesture_data.Set(
          gesture_data_fragment.is_null() ? nullptr : gesture_data_fragment.data());

      decltype(Traits::scroll_data(input)) in_scroll_data = Traits::scroll_data(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->scroll_data)::BaseType> scroll_data_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::ui::mojom::ScrollDataDataView, send_validation>(
        in_scroll_data,
        scroll_data_fragment);

      fragment->scroll_data.Set(
          scroll_data_fragment.is_null() ? nullptr : scroll_data_fragment.data());

      decltype(Traits::touch_data(input)) in_touch_data = Traits::touch_data(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->touch_data)::BaseType> touch_data_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::ui::mojom::TouchDataDataView, send_validation>(
        in_touch_data,
        touch_data_fragment);

      fragment->touch_data.Set(
          touch_data_fragment.is_null() ? nullptr : touch_data_fragment.data());

      decltype(Traits::mouse_data(input)) in_mouse_data = Traits::mouse_data(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->mouse_data)::BaseType> mouse_data_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::ui::mojom::MouseDataDataView, send_validation>(
        in_mouse_data,
        mouse_data_fragment);

      fragment->mouse_data.Set(
          mouse_data_fragment.is_null() ? nullptr : mouse_data_fragment.data());

      decltype(Traits::properties(input)) in_properties = Traits::properties(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->properties)::BaseType>
          properties_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& properties_validate_params =
          mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
      
      mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, mojo::ArrayDataView<uint8_t>>, send_validation>(
        in_properties,
        properties_fragment,
        &properties_validate_params);

      fragment->properties.Set(
          properties_fragment.is_null() ? nullptr : properties_fragment.data());
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::ui::mojom::GestureDataDetailsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::ui::mojom::GestureDataDetailsDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::ui::mojom::internal::GestureDataDetails_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::ui::mojom::GestureDataDetailsDataView::Tag::kPinch: {
    decltype(Traits::pinch(input))
    in_pinch = Traits::pinch(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_pinch)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::ui::mojom::GesturePinchDataDataView, send_validation>(
  in_pinch,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null pinch in GestureDataDetails union");
    fragment->data.f_pinch.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::ui::mojom::GestureDataDetailsDataView::Tag::kSwipe: {
    decltype(Traits::swipe(input))
    in_swipe = Traits::swipe(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_swipe)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::ui::mojom::GestureSwipeDataDataView, send_validation>(
  in_swipe,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null swipe in GestureDataDetails union");
    fragment->data.f_swipe.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }
};

}  // namespace mojo::internal

#endif  // UI_EVENTS_MOJOM_EVENT_MOJOM_SEND_VALIDATION_H_