// ui/display/mojom/screen_infos.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_DISPLAY_MOJOM_SCREEN_INFOS_MOJOM_SHARED_H_
#define UI_DISPLAY_MOJOM_SCREEN_INFOS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/display/mojom/screen_infos.mojom-shared-internal.h"
#include "ui/display/mojom/screen_info.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"




#include "ui/display/mojom/screen_infos.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::display::mojom::ScreenInfosDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::display::mojom::ScreenInfosDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::display::mojom::internal::ScreenInfos_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::screen_infos(input)) in_screen_infos = Traits::screen_infos(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->screen_infos)::BaseType>
        screen_infos_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& screen_infos_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::display::mojom::ScreenInfoDataView>>(
      in_screen_infos,
      screen_infos_fragment,
      &screen_infos_validate_params);

    fragment->screen_infos.Set(
        screen_infos_fragment.is_null() ? nullptr : screen_infos_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->screen_infos.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null screen_infos in ScreenInfos struct");

    fragment->current_display_id = Traits::current_display_id(input);

    decltype(Traits::system_cursor_size(input)) in_system_cursor_size = Traits::system_cursor_size(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->system_cursor_size)::BaseType> system_cursor_size_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
      in_system_cursor_size,
      system_cursor_size_fragment);

    fragment->system_cursor_size.Set(
        system_cursor_size_fragment.is_null() ? nullptr : system_cursor_size_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->system_cursor_size.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null system_cursor_size in ScreenInfos struct");
  }

  static bool Deserialize(::display::mojom::internal::ScreenInfos_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::display::mojom::ScreenInfosDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace display::mojom {

inline void ScreenInfosDataView::GetScreenInfosDataView(
    mojo::ArrayDataView<::display::mojom::ScreenInfoDataView>* output) {
  auto pointer = data_->screen_infos.Get();
  *output = mojo::ArrayDataView<::display::mojom::ScreenInfoDataView>(pointer, message_);
}
inline void ScreenInfosDataView::GetSystemCursorSizeDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->system_cursor_size.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, message_);
}



}  // display::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // UI_DISPLAY_MOJOM_SCREEN_INFOS_MOJOM_SHARED_H_