// ui/display/mojom/display_snapshot.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_DISPLAY_MOJOM_DISPLAY_SNAPSHOT_MOJOM_DATA_VIEW_H_
#define UI_DISPLAY_MOJOM_DISPLAY_SNAPSHOT_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "ui/display/mojom/display_snapshot.mojom-shared-internal.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "skia/public/mojom/skcolorspace_primaries.mojom-shared.h"
#include "ui/display/mojom/display_constants.mojom-shared.h"
#include "ui/display/mojom/display_mode.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/mojom/color_space.mojom-shared.h"
#include "ui/gfx/mojom/hdr_static_metadata.mojom-shared.h"


namespace display::mojom {
class DisplaySnapshotColorInfoDataView;

class DisplaySnapshotDataView;



}  // display::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::display::mojom::DisplaySnapshotColorInfoDataView> {
  using Data = ::display::mojom::internal::DisplaySnapshotColorInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::display::mojom::DisplaySnapshotDataView> {
  using Data = ::display::mojom::internal::DisplaySnapshot_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace display::mojom {


class DisplaySnapshotColorInfoDataView {
 public:
  DisplaySnapshotColorInfoDataView() = default;

  DisplaySnapshotColorInfoDataView(
      internal::DisplaySnapshotColorInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetColorSpaceDataView(
      ::gfx::mojom::ColorSpaceDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadColorSpace(UserType* output) {
    
    auto* pointer = data_->color_space.Get();
    return mojo::internal::Deserialize<::gfx::mojom::ColorSpaceDataView>(
        pointer, output, message_);
  }
  inline void GetEdidPrimariesDataView(
      ::skia::mojom::SkColorSpacePrimariesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEdidPrimaries(UserType* output) {
    
    auto* pointer = data_->edid_primaries.Get();
    return mojo::internal::Deserialize<::skia::mojom::SkColorSpacePrimariesDataView>(
        pointer, output, message_);
  }
  float edid_gamma() const {
    return data_->edid_gamma;
  }
  inline void GetHdrStaticMetadataDataView(
      ::gfx::mojom::HDRStaticMetadataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHdrStaticMetadata(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gfx::mojom::HDRStaticMetadataDataView, UserType>(),
    "Attempting to read the optional `hdr_static_metadata` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadHdrStaticMetadata` instead "
    "of `ReadHdrStaticMetadata if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->hdr_static_metadata.Get();
    return mojo::internal::Deserialize<::gfx::mojom::HDRStaticMetadataDataView>(
        pointer, output, message_);
  }
  bool supports_color_temperature_adjustment() const {
    return data_->supports_color_temperature_adjustment;
  }
  uint32_t bits_per_channel() const {
    return data_->bits_per_channel;
  }
 private:
  internal::DisplaySnapshotColorInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DisplaySnapshotDataView {
 public:
  DisplaySnapshotDataView() = default;

  DisplaySnapshotDataView(
      internal::DisplaySnapshot_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int64_t display_id() const {
    return data_->display_id;
  }
  int64_t port_display_id() const {
    return data_->port_display_id;
  }
  int64_t edid_display_id() const {
    return data_->edid_display_id;
  }
  uint16_t connector_index() const {
    return data_->connector_index;
  }
  inline void GetOriginDataView(
      ::gfx::mojom::PointDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOrigin(UserType* output) {
    
    auto* pointer = data_->origin.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointDataView>(
        pointer, output, message_);
  }
  inline void GetPhysicalSizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPhysicalSize(UserType* output) {
    
    auto* pointer = data_->physical_size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::display::mojom::DisplayConnectionType>(
        data_value, output);
  }
  ::display::mojom::DisplayConnectionType type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::display::mojom::DisplayConnectionType>(data_->type));
  }
  uint64_t base_connector_id() const {
    return data_->base_connector_id;
  }
  inline void GetPathTopologyDataView(
      mojo::ArrayDataView<uint64_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPathTopology(UserType* output) {
    
    auto* pointer = data_->path_topology.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint64_t>>(
        pointer, output, message_);
  }
  bool is_aspect_preserving_scaling() const {
    return data_->is_aspect_preserving_scaling;
  }
  bool has_overscan() const {
    return data_->has_overscan;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadPrivacyScreenState(UserType* output) const {
    auto data_value = data_->privacy_screen_state;
    return mojo::internal::Deserialize<::display::mojom::PrivacyScreenState>(
        data_value, output);
  }
  ::display::mojom::PrivacyScreenState privacy_screen_state() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::display::mojom::PrivacyScreenState>(data_->privacy_screen_state));
  }
  bool has_content_protection_key() const {
    return data_->has_content_protection_key;
  }
  inline void GetColorInfoDataView(
      DisplaySnapshotColorInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadColorInfo(UserType* output) {
    
    auto* pointer = data_->color_info.Get();
    return mojo::internal::Deserialize<::display::mojom::DisplaySnapshotColorInfoDataView>(
        pointer, output, message_);
  }
  inline void GetDisplayNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDisplayName(UserType* output) {
    
    auto* pointer = data_->display_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetSysPathDataView(
      ::mojo_base::mojom::FilePathDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSysPath(UserType* output) {
    
    auto* pointer = data_->sys_path.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FilePathDataView>(
        pointer, output, message_);
  }
  inline void GetModesDataView(
      mojo::ArrayDataView<::display::mojom::DisplayModeDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadModes(UserType* output) {
    
    auto* pointer = data_->modes.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::display::mojom::DisplayModeDataView>>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadPanelOrientation(UserType* output) const {
    auto data_value = data_->panel_orientation;
    return mojo::internal::Deserialize<::display::mojom::PanelOrientation>(
        data_value, output);
  }
  ::display::mojom::PanelOrientation panel_orientation() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::display::mojom::PanelOrientation>(data_->panel_orientation));
  }
  inline void GetEdidDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEdid(UserType* output) {
    
    auto* pointer = data_->edid.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
  uint64_t current_mode_index() const {
    return data_->current_mode_index;
  }
  bool has_current_mode() const {
    return data_->has_current_mode;
  }
  uint64_t native_mode_index() const {
    return data_->native_mode_index;
  }
  bool has_native_mode() const {
    return data_->has_native_mode;
  }
  int64_t product_code() const {
    return data_->product_code;
  }
  int32_t year_of_manufacture() const {
    return data_->year_of_manufacture;
  }
  inline void GetMaximumCursorSizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMaximumCursorSize(UserType* output) {
    
    auto* pointer = data_->maximum_cursor_size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadVariableRefreshRateState(UserType* output) const {
    auto data_value = data_->variable_refresh_rate_state;
    return mojo::internal::Deserialize<::display::mojom::VariableRefreshRateState>(
        data_value, output);
  }
  ::display::mojom::VariableRefreshRateState variable_refresh_rate_state() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::display::mojom::VariableRefreshRateState>(data_->variable_refresh_rate_state));
  }
 private:
  internal::DisplaySnapshot_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // display::mojom

#endif  // UI_DISPLAY_MOJOM_DISPLAY_SNAPSHOT_MOJOM_DATA_VIEW_H_