// ui/display/mojom/display_snapshot.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "ui/display/mojom/display_snapshot.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "ui/display/mojom/display_snapshot.mojom-params-data.h"
#include "ui/display/mojom/display_snapshot.mojom-shared-message-ids.h"

#include "ui/display/mojom/display_snapshot.mojom-blink-import-headers.h"
#include "ui/display/mojom/display_snapshot.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace display::mojom::blink {
DisplaySnapshotColorInfo::DisplaySnapshotColorInfo()
    : color_space(),
      edid_primaries(),
      edid_gamma(),
      hdr_static_metadata(),
      supports_color_temperature_adjustment(),
      bits_per_channel() {}

DisplaySnapshotColorInfo::DisplaySnapshotColorInfo(
    const ::gfx::ColorSpace& color_space_in,
    const ::SkColorSpacePrimaries& edid_primaries_in,
    float edid_gamma_in,
    const std::optional<::gfx::HDRStaticMetadata>& hdr_static_metadata_in,
    bool supports_color_temperature_adjustment_in,
    uint32_t bits_per_channel_in)
    : color_space(std::move(color_space_in)),
      edid_primaries(std::move(edid_primaries_in)),
      edid_gamma(std::move(edid_gamma_in)),
      hdr_static_metadata(std::move(hdr_static_metadata_in)),
      supports_color_temperature_adjustment(std::move(supports_color_temperature_adjustment_in)),
      bits_per_channel(std::move(bits_per_channel_in)) {}

DisplaySnapshotColorInfo::~DisplaySnapshotColorInfo() = default;

void DisplaySnapshotColorInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "color_space"), this->color_space,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::ColorSpace&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "edid_primaries"), this->edid_primaries,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::SkColorSpacePrimaries&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "edid_gamma"), this->edid_gamma,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "hdr_static_metadata"), this->hdr_static_metadata,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::gfx::HDRStaticMetadata>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "supports_color_temperature_adjustment"), this->supports_color_temperature_adjustment,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bits_per_channel"), this->bits_per_channel,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DisplaySnapshotColorInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DisplaySnapshot::DisplaySnapshot()
    : display_id(),
      port_display_id(),
      edid_display_id(),
      connector_index(),
      origin(),
      physical_size(),
      type(),
      base_connector_id(),
      path_topology(),
      is_aspect_preserving_scaling(),
      has_overscan(),
      privacy_screen_state(),
      has_content_protection_key(),
      color_info(),
      display_name(),
      sys_path(),
      modes(),
      panel_orientation(),
      edid(),
      current_mode_index(),
      has_current_mode(),
      native_mode_index(),
      has_native_mode(),
      product_code(),
      year_of_manufacture(),
      maximum_cursor_size(),
      variable_refresh_rate_state() {}

DisplaySnapshot::DisplaySnapshot(
    int64_t display_id_in,
    int64_t port_display_id_in,
    int64_t edid_display_id_in,
    uint16_t connector_index_in,
    const ::gfx::Point& origin_in,
    const ::gfx::Size& physical_size_in,
    ::display::mojom::blink::DisplayConnectionType type_in,
    uint64_t base_connector_id_in,
    ::blink::Vector<uint64_t> path_topology_in,
    bool is_aspect_preserving_scaling_in,
    bool has_overscan_in,
    ::display::mojom::blink::PrivacyScreenState privacy_screen_state_in,
    bool has_content_protection_key_in,
    DisplaySnapshotColorInfoPtr color_info_in,
    const ::blink::String& display_name_in,
    const ::base::FilePath& sys_path_in,
    ::blink::Vector<::display::mojom::blink::DisplayModePtr> modes_in,
    ::display::mojom::blink::PanelOrientation panel_orientation_in,
    ::blink::Vector<uint8_t> edid_in,
    uint64_t current_mode_index_in,
    bool has_current_mode_in,
    uint64_t native_mode_index_in,
    bool has_native_mode_in,
    int64_t product_code_in,
    int32_t year_of_manufacture_in,
    const ::gfx::Size& maximum_cursor_size_in,
    ::display::mojom::blink::VariableRefreshRateState variable_refresh_rate_state_in)
    : display_id(std::move(display_id_in)),
      port_display_id(std::move(port_display_id_in)),
      edid_display_id(std::move(edid_display_id_in)),
      connector_index(std::move(connector_index_in)),
      origin(std::move(origin_in)),
      physical_size(std::move(physical_size_in)),
      type(std::move(type_in)),
      base_connector_id(std::move(base_connector_id_in)),
      path_topology(std::move(path_topology_in)),
      is_aspect_preserving_scaling(std::move(is_aspect_preserving_scaling_in)),
      has_overscan(std::move(has_overscan_in)),
      privacy_screen_state(std::move(privacy_screen_state_in)),
      has_content_protection_key(std::move(has_content_protection_key_in)),
      color_info(std::move(color_info_in)),
      display_name(std::move(display_name_in)),
      sys_path(std::move(sys_path_in)),
      modes(std::move(modes_in)),
      panel_orientation(std::move(panel_orientation_in)),
      edid(std::move(edid_in)),
      current_mode_index(std::move(current_mode_index_in)),
      has_current_mode(std::move(has_current_mode_in)),
      native_mode_index(std::move(native_mode_index_in)),
      has_native_mode(std::move(has_native_mode_in)),
      product_code(std::move(product_code_in)),
      year_of_manufacture(std::move(year_of_manufacture_in)),
      maximum_cursor_size(std::move(maximum_cursor_size_in)),
      variable_refresh_rate_state(std::move(variable_refresh_rate_state_in)) {}

DisplaySnapshot::~DisplaySnapshot() = default;

void DisplaySnapshot::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "display_id"), this->display_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "port_display_id"), this->port_display_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "edid_display_id"), this->edid_display_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "connector_index"), this->connector_index,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint16_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "origin"), this->origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Point&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "physical_size"), this->physical_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "type"), this->type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::display::mojom::blink::DisplayConnectionType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "base_connector_id"), this->base_connector_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "path_topology"), this->path_topology,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<uint64_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_aspect_preserving_scaling"), this->is_aspect_preserving_scaling,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_overscan"), this->has_overscan,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "privacy_screen_state"), this->privacy_screen_state,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::display::mojom::blink::PrivacyScreenState>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_content_protection_key"), this->has_content_protection_key,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "color_info"), this->color_info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type DisplaySnapshotColorInfoPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "display_name"), this->display_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sys_path"), this->sys_path,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::base::FilePath&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "modes"), this->modes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::Vector<::display::mojom::blink::DisplayModePtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "panel_orientation"), this->panel_orientation,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::display::mojom::blink::PanelOrientation>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "edid"), this->edid,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "current_mode_index"), this->current_mode_index,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_current_mode"), this->has_current_mode,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "native_mode_index"), this->native_mode_index,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_native_mode"), this->has_native_mode,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "product_code"), this->product_code,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "year_of_manufacture"), this->year_of_manufacture,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "maximum_cursor_size"), this->maximum_cursor_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "variable_refresh_rate_state"), this->variable_refresh_rate_state,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::display::mojom::blink::VariableRefreshRateState>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DisplaySnapshot::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}


}  // display::mojom::blink


namespace mojo {


// static
bool StructTraits<::display::mojom::blink::DisplaySnapshotColorInfo::DataView, ::display::mojom::blink::DisplaySnapshotColorInfoPtr>::Read(
    ::display::mojom::blink::DisplaySnapshotColorInfo::DataView input,
    ::display::mojom::blink::DisplaySnapshotColorInfoPtr* output) {
  bool success = true;
  ::display::mojom::blink::DisplaySnapshotColorInfoPtr result(::display::mojom::blink::DisplaySnapshotColorInfo::New());
  
      if (success && !input.ReadColorSpace(&result->color_space))
        success = false;
      if (success && !input.ReadEdidPrimaries(&result->edid_primaries))
        success = false;
      if (success)
        result->edid_gamma = input.edid_gamma();
      if (success && !input.ReadHdrStaticMetadata(&result->hdr_static_metadata))
        success = false;
      if (success)
        result->supports_color_temperature_adjustment = input.supports_color_temperature_adjustment();
      if (success)
        result->bits_per_channel = input.bits_per_channel();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::display::mojom::blink::DisplaySnapshot::DataView, ::display::mojom::blink::DisplaySnapshotPtr>::Read(
    ::display::mojom::blink::DisplaySnapshot::DataView input,
    ::display::mojom::blink::DisplaySnapshotPtr* output) {
  bool success = true;
  ::display::mojom::blink::DisplaySnapshotPtr result(::display::mojom::blink::DisplaySnapshot::New());
  
      if (success)
        result->display_id = input.display_id();
      if (success)
        result->port_display_id = input.port_display_id();
      if (success)
        result->edid_display_id = input.edid_display_id();
      if (success)
        result->connector_index = input.connector_index();
      if (success && !input.ReadOrigin(&result->origin))
        success = false;
      if (success && !input.ReadPhysicalSize(&result->physical_size))
        success = false;
      if (success && !input.ReadType(&result->type))
        success = false;
      if (success)
        result->base_connector_id = input.base_connector_id();
      if (success && !input.ReadPathTopology(&result->path_topology))
        success = false;
      if (success)
        result->is_aspect_preserving_scaling = input.is_aspect_preserving_scaling();
      if (success)
        result->has_overscan = input.has_overscan();
      if (success && !input.ReadPrivacyScreenState(&result->privacy_screen_state))
        success = false;
      if (success)
        result->has_content_protection_key = input.has_content_protection_key();
      if (success && !input.ReadColorInfo(&result->color_info))
        success = false;
      if (success && !input.ReadDisplayName(&result->display_name))
        success = false;
      if (success && !input.ReadSysPath(&result->sys_path))
        success = false;
      if (success && !input.ReadModes(&result->modes))
        success = false;
      if (success && !input.ReadPanelOrientation(&result->panel_orientation))
        success = false;
      if (success && !input.ReadEdid(&result->edid))
        success = false;
      if (success)
        result->current_mode_index = input.current_mode_index();
      if (success)
        result->has_current_mode = input.has_current_mode();
      if (success)
        result->native_mode_index = input.native_mode_index();
      if (success)
        result->has_native_mode = input.has_native_mode();
      if (success)
        result->product_code = input.product_code();
      if (success)
        result->year_of_manufacture = input.year_of_manufacture();
      if (success && !input.ReadMaximumCursorSize(&result->maximum_cursor_size))
        success = false;
      if (success && !input.ReadVariableRefreshRateState(&result->variable_refresh_rate_state))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace display::mojom::blink {




}  // display::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif