// ui/display/mojom/display_layout.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_DISPLAY_MOJOM_DISPLAY_LAYOUT_MOJOM_H_
#define UI_DISPLAY_MOJOM_DISPLAY_LAYOUT_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/display/mojom/display_layout.mojom-features.h"  // IWYU pragma: export
#include "ui/display/mojom/display_layout.mojom-shared.h"  // IWYU pragma: export
#include "ui/display/mojom/display_layout.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>




#include "ui/display/mojom/display_layout_mojom_traits.h"




namespace display::mojom {









class  DisplayPlacement {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DisplayPlacement, T>::value>;
  using DataView = DisplayPlacementDataView;
  using Data_ = internal::DisplayPlacement_Data;

  template <typename... Args>
  static DisplayPlacementPtr New(Args&&... args) {
    return DisplayPlacementPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DisplayPlacementPtr From(const U& u) {
    return mojo::TypeConverter<DisplayPlacementPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DisplayPlacement>::Convert(*this);
  }


  DisplayPlacement();

  DisplayPlacement(
      int64_t display_id,
      int64_t parent_display_id,
      ::display::DisplayPlacement::Position position,
      int32_t offset,
      ::display::DisplayPlacement::OffsetReference offset_reference);


  ~DisplayPlacement();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DisplayPlacementPtr>
  DisplayPlacementPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DisplayPlacement::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DisplayPlacement::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DisplayPlacement::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DisplayPlacement::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DisplayPlacement::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DisplayPlacement::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DisplayPlacement_UnserializedMessageContext<
            UserType, DisplayPlacement::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DisplayPlacement::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DisplayPlacement::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DisplayPlacement_UnserializedMessageContext<
            UserType, DisplayPlacement::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DisplayPlacement::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int64_t display_id;
  
  int64_t parent_display_id;
  
  ::display::DisplayPlacement::Position position;
  
  int32_t offset;
  
  ::display::DisplayPlacement::OffsetReference offset_reference;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DisplayPlacement::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DisplayPlacement::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DisplayPlacement::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DisplayPlacement::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  DisplayLayout {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DisplayLayout, T>::value>;
  using DataView = DisplayLayoutDataView;
  using Data_ = internal::DisplayLayout_Data;

  template <typename... Args>
  static DisplayLayoutPtr New(Args&&... args) {
    return DisplayLayoutPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DisplayLayoutPtr From(const U& u) {
    return mojo::TypeConverter<DisplayLayoutPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DisplayLayout>::Convert(*this);
  }


  DisplayLayout();

  DisplayLayout(
      bool default_unified,
      int64_t primary_display_id,
      std::vector<::display::DisplayPlacement> placement_list);


  ~DisplayLayout();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DisplayLayoutPtr>
  DisplayLayoutPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DisplayLayout::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DisplayLayout::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DisplayLayout::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DisplayLayout::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DisplayLayout::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DisplayLayout::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DisplayLayout_UnserializedMessageContext<
            UserType, DisplayLayout::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DisplayLayout::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DisplayLayout::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DisplayLayout_UnserializedMessageContext<
            UserType, DisplayLayout::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DisplayLayout::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool default_unified;
  
  int64_t primary_display_id;
  
  std::vector<::display::DisplayPlacement> placement_list;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DisplayLayout::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DisplayLayout::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DisplayLayout::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DisplayLayout::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
DisplayPlacementPtr DisplayPlacement::Clone() const {
  return New(
      mojo::Clone(display_id),
      mojo::Clone(parent_display_id),
      mojo::Clone(position),
      mojo::Clone(offset),
      mojo::Clone(offset_reference)
  );
}

template <typename T, DisplayPlacement::EnableIfSame<T>*>
bool DisplayPlacement::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->display_id, other_struct.display_id))
    return false;
  if (!mojo::Equals(this->parent_display_id, other_struct.parent_display_id))
    return false;
  if (!mojo::Equals(this->position, other_struct.position))
    return false;
  if (!mojo::Equals(this->offset, other_struct.offset))
    return false;
  if (!mojo::Equals(this->offset_reference, other_struct.offset_reference))
    return false;
  return true;
}

template <typename T, DisplayPlacement::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.display_id < rhs.display_id)
    return true;
  if (rhs.display_id < lhs.display_id)
    return false;
  if (lhs.parent_display_id < rhs.parent_display_id)
    return true;
  if (rhs.parent_display_id < lhs.parent_display_id)
    return false;
  if (lhs.position < rhs.position)
    return true;
  if (rhs.position < lhs.position)
    return false;
  if (lhs.offset < rhs.offset)
    return true;
  if (rhs.offset < lhs.offset)
    return false;
  if (lhs.offset_reference < rhs.offset_reference)
    return true;
  if (rhs.offset_reference < lhs.offset_reference)
    return false;
  return false;
}
template <typename StructPtrType>
DisplayLayoutPtr DisplayLayout::Clone() const {
  return New(
      mojo::Clone(default_unified),
      mojo::Clone(primary_display_id),
      mojo::Clone(placement_list)
  );
}

template <typename T, DisplayLayout::EnableIfSame<T>*>
bool DisplayLayout::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->default_unified, other_struct.default_unified))
    return false;
  if (!mojo::Equals(this->primary_display_id, other_struct.primary_display_id))
    return false;
  if (!mojo::Equals(this->placement_list, other_struct.placement_list))
    return false;
  return true;
}

template <typename T, DisplayLayout::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.default_unified < rhs.default_unified)
    return true;
  if (rhs.default_unified < lhs.default_unified)
    return false;
  if (lhs.primary_display_id < rhs.primary_display_id)
    return true;
  if (rhs.primary_display_id < lhs.primary_display_id)
    return false;
  if (lhs.placement_list < rhs.placement_list)
    return true;
  if (rhs.placement_list < lhs.placement_list)
    return false;
  return false;
}


}  // display::mojom

namespace mojo {


template <>
struct  StructTraits<::display::mojom::DisplayPlacement::DataView,
                                         ::display::mojom::DisplayPlacementPtr> {
  static bool IsNull(const ::display::mojom::DisplayPlacementPtr& input) { return !input; }
  static void SetToNull(::display::mojom::DisplayPlacementPtr* output) { output->reset(); }

  static decltype(::display::mojom::DisplayPlacement::display_id) display_id(
      const ::display::mojom::DisplayPlacementPtr& input) {
    return input->display_id;
  }

  static decltype(::display::mojom::DisplayPlacement::parent_display_id) parent_display_id(
      const ::display::mojom::DisplayPlacementPtr& input) {
    return input->parent_display_id;
  }

  static decltype(::display::mojom::DisplayPlacement::position) position(
      const ::display::mojom::DisplayPlacementPtr& input) {
    return input->position;
  }

  static decltype(::display::mojom::DisplayPlacement::offset) offset(
      const ::display::mojom::DisplayPlacementPtr& input) {
    return input->offset;
  }

  static decltype(::display::mojom::DisplayPlacement::offset_reference) offset_reference(
      const ::display::mojom::DisplayPlacementPtr& input) {
    return input->offset_reference;
  }

  static bool Read(::display::mojom::DisplayPlacement::DataView input, ::display::mojom::DisplayPlacementPtr* output);
};


template <>
struct  StructTraits<::display::mojom::DisplayLayout::DataView,
                                         ::display::mojom::DisplayLayoutPtr> {
  static bool IsNull(const ::display::mojom::DisplayLayoutPtr& input) { return !input; }
  static void SetToNull(::display::mojom::DisplayLayoutPtr* output) { output->reset(); }

  static decltype(::display::mojom::DisplayLayout::default_unified) default_unified(
      const ::display::mojom::DisplayLayoutPtr& input) {
    return input->default_unified;
  }

  static decltype(::display::mojom::DisplayLayout::primary_display_id) primary_display_id(
      const ::display::mojom::DisplayLayoutPtr& input) {
    return input->primary_display_id;
  }

  static const decltype(::display::mojom::DisplayLayout::placement_list)& placement_list(
      const ::display::mojom::DisplayLayoutPtr& input) {
    return input->placement_list;
  }

  static bool Read(::display::mojom::DisplayLayout::DataView input, ::display::mojom::DisplayLayoutPtr* output);
};

}  // namespace mojo

#endif  // UI_DISPLAY_MOJOM_DISPLAY_LAYOUT_MOJOM_H_