// ui/display/mojom/display_layout.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_DISPLAY_MOJOM_DISPLAY_LAYOUT_MOJOM_DATA_VIEW_H_
#define UI_DISPLAY_MOJOM_DISPLAY_LAYOUT_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "ui/display/mojom/display_layout.mojom-shared-internal.h"


namespace display::mojom {
class DisplayPlacementDataView;

class DisplayLayoutDataView;



}  // display::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::display::mojom::DisplayPlacementDataView> {
  using Data = ::display::mojom::internal::DisplayPlacement_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::display::mojom::DisplayLayoutDataView> {
  using Data = ::display::mojom::internal::DisplayLayout_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace display::mojom {


enum class Position : int32_t {
  
  TOP = 0,
  
  RIGHT = 1,
  
  BOTTOM = 2,
  
  LEFT = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, Position value);
inline bool IsKnownEnumValue(Position value) {
  return internal::Position_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class OffsetReference : int32_t {
  
  TOP_LEFT = 0,
  
  BOTTOM_RIGHT = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, OffsetReference value);
inline bool IsKnownEnumValue(OffsetReference value) {
  return internal::OffsetReference_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class DisplayPlacementDataView {
 public:
  DisplayPlacementDataView() = default;

  DisplayPlacementDataView(
      internal::DisplayPlacement_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int64_t display_id() const {
    return data_->display_id;
  }
  int64_t parent_display_id() const {
    return data_->parent_display_id;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadPosition(UserType* output) const {
    auto data_value = data_->position;
    return mojo::internal::Deserialize<::display::mojom::Position>(
        data_value, output);
  }
  Position position() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::display::mojom::Position>(data_->position));
  }
  int32_t offset() const {
    return data_->offset;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadOffsetReference(UserType* output) const {
    auto data_value = data_->offset_reference;
    return mojo::internal::Deserialize<::display::mojom::OffsetReference>(
        data_value, output);
  }
  OffsetReference offset_reference() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::display::mojom::OffsetReference>(data_->offset_reference));
  }
 private:
  internal::DisplayPlacement_Data* data_ = nullptr;
};


class DisplayLayoutDataView {
 public:
  DisplayLayoutDataView() = default;

  DisplayLayoutDataView(
      internal::DisplayLayout_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  bool default_unified() const {
    return data_->default_unified;
  }
  int64_t primary_display_id() const {
    return data_->primary_display_id;
  }
  inline void GetPlacementListDataView(
      mojo::ArrayDataView<DisplayPlacementDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPlacementList(UserType* output) {
    
    auto* pointer = data_->placement_list.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::display::mojom::DisplayPlacementDataView>>(
        pointer, output, message_);
  }
 private:
  internal::DisplayLayout_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // display::mojom

#endif  // UI_DISPLAY_MOJOM_DISPLAY_LAYOUT_MOJOM_DATA_VIEW_H_