// ui/display/mojom/display_layout.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "ui/display/mojom/display_layout.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "ui/display/mojom/display_layout.mojom-params-data.h"
#include "ui/display/mojom/display_layout.mojom-shared-message-ids.h"

#include "ui/display/mojom/display_layout.mojom-blink-import-headers.h"
#include "ui/display/mojom/display_layout.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace display::mojom::blink {
DisplayPlacement::DisplayPlacement()
    : display_id(),
      parent_display_id(),
      position(),
      offset(),
      offset_reference() {}

DisplayPlacement::DisplayPlacement(
    int64_t display_id_in,
    int64_t parent_display_id_in,
    Position position_in,
    int32_t offset_in,
    OffsetReference offset_reference_in)
    : display_id(std::move(display_id_in)),
      parent_display_id(std::move(parent_display_id_in)),
      position(std::move(position_in)),
      offset(std::move(offset_in)),
      offset_reference(std::move(offset_reference_in)) {}

DisplayPlacement::~DisplayPlacement() = default;
size_t DisplayPlacement::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->display_id);
  seed = mojo::internal::WTFHash(seed, this->parent_display_id);
  seed = mojo::internal::WTFHash(seed, this->position);
  seed = mojo::internal::WTFHash(seed, this->offset);
  seed = mojo::internal::WTFHash(seed, this->offset_reference);
  return seed;
}

void DisplayPlacement::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "display_id"), this->display_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "parent_display_id"), this->parent_display_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "position"), this->position,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type Position>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "offset"), this->offset,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "offset_reference"), this->offset_reference,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type OffsetReference>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DisplayPlacement::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DisplayLayout::DisplayLayout()
    : default_unified(),
      primary_display_id(),
      placement_list() {}

DisplayLayout::DisplayLayout(
    bool default_unified_in,
    int64_t primary_display_id_in,
    ::blink::Vector<DisplayPlacementPtr> placement_list_in)
    : default_unified(std::move(default_unified_in)),
      primary_display_id(std::move(primary_display_id_in)),
      placement_list(std::move(placement_list_in)) {}

DisplayLayout::~DisplayLayout() = default;

void DisplayLayout::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "default_unified"), this->default_unified,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "primary_display_id"), this->primary_display_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "placement_list"), this->placement_list,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::Vector<DisplayPlacementPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DisplayLayout::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}


}  // display::mojom::blink


namespace mojo {


// static
bool StructTraits<::display::mojom::blink::DisplayPlacement::DataView, ::display::mojom::blink::DisplayPlacementPtr>::Read(
    ::display::mojom::blink::DisplayPlacement::DataView input,
    ::display::mojom::blink::DisplayPlacementPtr* output) {
  bool success = true;
  ::display::mojom::blink::DisplayPlacementPtr result(::display::mojom::blink::DisplayPlacement::New());
  
      if (success)
        result->display_id = input.display_id();
      if (success)
        result->parent_display_id = input.parent_display_id();
      if (success && !input.ReadPosition(&result->position))
        success = false;
      if (success)
        result->offset = input.offset();
      if (success && !input.ReadOffsetReference(&result->offset_reference))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::display::mojom::blink::DisplayLayout::DataView, ::display::mojom::blink::DisplayLayoutPtr>::Read(
    ::display::mojom::blink::DisplayLayout::DataView input,
    ::display::mojom::blink::DisplayLayoutPtr* output) {
  bool success = true;
  ::display::mojom::blink::DisplayLayoutPtr result(::display::mojom::blink::DisplayLayout::New());
  
      if (success)
        result->default_unified = input.default_unified();
      if (success)
        result->primary_display_id = input.primary_display_id();
      if (success && !input.ReadPlacementList(&result->placement_list))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace display::mojom::blink {




}  // display::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif