// ui/display/mojom/display_constants.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_DISPLAY_MOJOM_DISPLAY_CONSTANTS_MOJOM_H_
#define UI_DISPLAY_MOJOM_DISPLAY_CONSTANTS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/display/mojom/display_constants.mojom-features.h"  // IWYU pragma: export
#include "ui/display/mojom/display_constants.mojom-shared.h"  // IWYU pragma: export
#include "ui/display/mojom/display_constants.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>




#include "ui/display/mojom/display_constants_mojom_traits.h"




namespace display::mojom {





class  ModesetFlags {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ModesetFlags, T>::value>;
  using DataView = ModesetFlagsDataView;
  using Data_ = internal::ModesetFlags_Data;

  template <typename... Args>
  static ModesetFlagsPtr New(Args&&... args) {
    return ModesetFlagsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ModesetFlagsPtr From(const U& u) {
    return mojo::TypeConverter<ModesetFlagsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ModesetFlags>::Convert(*this);
  }


  ModesetFlags();

  explicit ModesetFlags(
      uint64_t bitmask);


  ~ModesetFlags();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ModesetFlagsPtr>
  ModesetFlagsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ModesetFlags::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ModesetFlags::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ModesetFlags::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ModesetFlags::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ModesetFlags::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ModesetFlags::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ModesetFlags_UnserializedMessageContext<
            UserType, ModesetFlags::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ModesetFlags::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ModesetFlags::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ModesetFlags_UnserializedMessageContext<
            UserType, ModesetFlags::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ModesetFlags::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint64_t bitmask;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ModesetFlags::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ModesetFlags::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ModesetFlags::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ModesetFlags::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}




template <typename StructPtrType>
ModesetFlagsPtr ModesetFlags::Clone() const {
  return New(
      mojo::Clone(bitmask)
  );
}

template <typename T, ModesetFlags::EnableIfSame<T>*>
bool ModesetFlags::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->bitmask, other_struct.bitmask))
    return false;
  return true;
}

template <typename T, ModesetFlags::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.bitmask < rhs.bitmask)
    return true;
  if (rhs.bitmask < lhs.bitmask)
    return false;
  return false;
}


}  // display::mojom

namespace mojo {


template <>
struct  StructTraits<::display::mojom::ModesetFlags::DataView,
                                         ::display::mojom::ModesetFlagsPtr> {
  static bool IsNull(const ::display::mojom::ModesetFlagsPtr& input) { return !input; }
  static void SetToNull(::display::mojom::ModesetFlagsPtr* output) { output->reset(); }

  static decltype(::display::mojom::ModesetFlags::bitmask) bitmask(
      const ::display::mojom::ModesetFlagsPtr& input) {
    return input->bitmask;
  }

  static bool Read(::display::mojom::ModesetFlags::DataView input, ::display::mojom::ModesetFlagsPtr* output);
};

}  // namespace mojo

#endif  // UI_DISPLAY_MOJOM_DISPLAY_CONSTANTS_MOJOM_H_