// ui/display/mojom/display_constants.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_DISPLAY_MOJOM_DISPLAY_CONSTANTS_MOJOM_DATA_VIEW_H_
#define UI_DISPLAY_MOJOM_DISPLAY_CONSTANTS_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "ui/display/mojom/display_constants.mojom-shared-internal.h"


namespace display::mojom {
class ModesetFlagsDataView;



}  // display::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::display::mojom::ModesetFlagsDataView> {
  using Data = ::display::mojom::internal::ModesetFlags_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace display::mojom {


enum class DisplayConnectionType : int32_t {
  
  DISPLAY_CONNECTION_TYPE_NONE = 0,
  
  DISPLAY_CONNECTION_TYPE_UNKNOWN = 1,
  
  DISPLAY_CONNECTION_TYPE_INTERNAL = 2,
  
  DISPLAY_CONNECTION_TYPE_VGA = 4,
  
  DISPLAY_CONNECTION_TYPE_HDMI = 8,
  
  DISPLAY_CONNECTION_TYPE_DVI = 16,
  
  DISPLAY_CONNECTION_TYPE_DISPLAYPORT = 32,
  
  DISPLAY_CONNECTION_TYPE_NETWORK = 64,
  kMinValue = 0,
  kMaxValue = 64,
};

 std::ostream& operator<<(std::ostream& os, DisplayConnectionType value);
inline bool IsKnownEnumValue(DisplayConnectionType value) {
  return internal::DisplayConnectionType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class HDCPState : int32_t {
  
  HDCP_STATE_UNDESIRED = 0,
  
  HDCP_STATE_DESIRED = 1,
  
  HDCP_STATE_ENABLED = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, HDCPState value);
inline bool IsKnownEnumValue(HDCPState value) {
  return internal::HDCPState_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ContentProtectionMethod : int32_t {
  
  CONTENT_PROTECTION_METHOD_NONE = 0,
  
  CONTENT_PROTECTION_METHOD_HDCP_TYPE_0 = 1,
  
  CONTENT_PROTECTION_METHOD_HDCP_TYPE_1 = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, ContentProtectionMethod value);
inline bool IsKnownEnumValue(ContentProtectionMethod value) {
  return internal::ContentProtectionMethod_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class PanelOrientation : int32_t {
  
  NORMAL = 0,
  
  BOTTOM_UP = 1,
  
  LEFT_UP = 2,
  
  RIGHT_UP = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, PanelOrientation value);
inline bool IsKnownEnumValue(PanelOrientation value) {
  return internal::PanelOrientation_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class PrivacyScreenState : int32_t {
  
  DISABLED = 0,
  
  ENABLED = 1,
  
  DISABLED_LOCKED = 2,
  
  ENABLED_LOCKED = 3,
  
  NOT_SUPPORTED = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

 std::ostream& operator<<(std::ostream& os, PrivacyScreenState value);
inline bool IsKnownEnumValue(PrivacyScreenState value) {
  return internal::PrivacyScreenState_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class VariableRefreshRateState : int32_t {
  
  kVrrDisabled = 0,
  
  kVrrEnabled = 1,
  
  kVrrNotCapable = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, VariableRefreshRateState value);
inline bool IsKnownEnumValue(VariableRefreshRateState value) {
  return internal::VariableRefreshRateState_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class ModesetFlagsDataView {
 public:
  ModesetFlagsDataView() = default;

  ModesetFlagsDataView(
      internal::ModesetFlags_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint64_t bitmask() const {
    return data_->bitmask;
  }
 private:
  internal::ModesetFlags_Data* data_ = nullptr;
};


}  // display::mojom

#endif  // UI_DISPLAY_MOJOM_DISPLAY_CONSTANTS_MOJOM_DATA_VIEW_H_