// ui/display/mojom/display_configuration_params.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "ui/display/mojom/display_configuration_params.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "ui/display/mojom/display_configuration_params.mojom-params-data.h"
#include "ui/display/mojom/display_configuration_params.mojom-shared-message-ids.h"

#include "ui/display/mojom/display_configuration_params.mojom-import-headers.h"
#include "ui/display/mojom/display_configuration_params.mojom-test-utils.h"


namespace display::mojom {
DisplayConfigurationParams::DisplayConfigurationParams()
    : id(),
      origin(),
      mode(),
      enable_vrr() {}

DisplayConfigurationParams::DisplayConfigurationParams(
    int64_t id_in,
    const ::gfx::Point& origin_in,
    ::std::unique_ptr<::display::DisplayMode> mode_in,
    bool enable_vrr_in)
    : id(std::move(id_in)),
      origin(std::move(origin_in)),
      mode(std::move(mode_in)),
      enable_vrr(std::move(enable_vrr_in)) {}

DisplayConfigurationParams::~DisplayConfigurationParams() = default;

void DisplayConfigurationParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "origin"), this->origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Point&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mode"), this->mode,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::std::unique_ptr<::display::DisplayMode>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_vrr"), this->enable_vrr,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DisplayConfigurationParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}


}  // display::mojom


namespace mojo {


// static
bool StructTraits<::display::mojom::DisplayConfigurationParams::DataView, ::display::mojom::DisplayConfigurationParamsPtr>::Read(
    ::display::mojom::DisplayConfigurationParams::DataView input,
    ::display::mojom::DisplayConfigurationParamsPtr* output) {
  bool success = true;
  ::display::mojom::DisplayConfigurationParamsPtr result(::display::mojom::DisplayConfigurationParams::New());
  
      if (success)
        result->id = input.id();
      if (success && !input.ReadOrigin(&result->origin))
        success = false;
      if (success && !input.ReadMode(&result->mode))
        success = false;
      if (success)
        result->enable_vrr = input.enable_vrr();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace display::mojom {




}  // display::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif