// ui/display/mojom/display_configuration_params.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_DISPLAY_MOJOM_DISPLAY_CONFIGURATION_PARAMS_MOJOM_SEND_VALIDATION_H_
#define UI_DISPLAY_MOJOM_DISPLAY_CONFIGURATION_PARAMS_MOJOM_SEND_VALIDATION_H_

#include "ui/display/mojom/display_configuration_params.mojom-shared-internal.h"
#include "ui/display/mojom/display_mode.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"

#include "ui/display/mojom/display_configuration_params.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::display::mojom::DisplayConfigurationParamsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::display::mojom::DisplayConfigurationParamsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::display::mojom::internal::DisplayConfigurationParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->id = Traits::id(input);

      decltype(Traits::origin(input)) in_origin = Traits::origin(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->origin)::BaseType> origin_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::PointDataView, send_validation>(
        in_origin,
        origin_fragment);

      fragment->origin.Set(
          origin_fragment.is_null() ? nullptr : origin_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->origin.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null origin in DisplayConfigurationParams struct");

      decltype(Traits::mode(input)) in_mode = Traits::mode(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->mode)::BaseType> mode_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::display::mojom::DisplayModeDataView, send_validation>(
        in_mode,
        mode_fragment);

      fragment->mode.Set(
          mode_fragment.is_null() ? nullptr : mode_fragment.data());

      fragment->enable_vrr = Traits::enable_vrr(input);
  }
};

}  // namespace mojo::internal

#endif  // UI_DISPLAY_MOJOM_DISPLAY_CONFIGURATION_PARAMS_MOJOM_SEND_VALIDATION_H_