// ui/display/mojom/display.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'ui/display/mojom/display.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('display.mojom');
  var geometry$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/geometry/mojom/geometry.mojom', '../../gfx/geometry/mojom/geometry.mojom.js');
  }
  var display_color_spaces$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/mojom/display_color_spaces.mojom', '../../gfx/mojom/display_color_spaces.mojom.js');
  }


  var Rotation = {};
  Rotation.VALUE_0 = 0;
  Rotation.VALUE_90 = 1;
  Rotation.VALUE_180 = 2;
  Rotation.VALUE_270 = 3;
  Rotation.MIN_VALUE = 0;
  Rotation.MAX_VALUE = 3;

  Rotation.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
      return true;
    }
    return false;
  };

  Rotation.toKnownEnumValue = function(value) {
    return value;
  };

  Rotation.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var TouchSupport = {};
  TouchSupport.UNKNOWN = 0;
  TouchSupport.AVAILABLE = 1;
  TouchSupport.UNAVAILABLE = 2;
  TouchSupport.MIN_VALUE = 0;
  TouchSupport.MAX_VALUE = 2;

  TouchSupport.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  TouchSupport.toKnownEnumValue = function(value) {
    return value;
  };

  TouchSupport.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var AccelerometerSupport = {};
  AccelerometerSupport.UNKNOWN = 0;
  AccelerometerSupport.AVAILABLE = 1;
  AccelerometerSupport.UNAVAILABLE = 2;
  AccelerometerSupport.MIN_VALUE = 0;
  AccelerometerSupport.MAX_VALUE = 2;

  AccelerometerSupport.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  AccelerometerSupport.toKnownEnumValue = function(value) {
    return value;
  };

  AccelerometerSupport.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function Display(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Display.prototype.initDefaults_ = function() {
    this.id = 0;
    this.bounds = null;
    this.sizeInPixels = null;
    this.nativeOrigin = null;
    this.workArea = null;
    this.deviceScaleFactor = 0;
    this.rotation = 0;
    this.touchSupport = 0;
    this.accelerometerSupport = 0;
    this.maximumCursorSize = null;
    this.colorSpaces = null;
    this.colorDepth = 0;
    this.depthPerComponent = 0;
    this.isMonochrome = false;
    this.displayFrequency = 0;
    this.label = null;
  };
  Display.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Display.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 104}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate Display.bounds
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, geometry$.Rect, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Display.sizeInPixels
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, geometry$.Size, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Display.nativeOrigin
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, geometry$.Point, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Display.workArea
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, geometry$.Rect, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate Display.rotation
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 44, Rotation);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Display.touchSupport
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 48, TouchSupport);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Display.accelerometerSupport
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 52, AccelerometerSupport);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Display.maximumCursorSize
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 56, geometry$.Size, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Display.colorSpaces
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 64, display_color_spaces$.DisplayColorSpaces, false);
    if (err !== validator.validationError.NONE)
        return err;






    // validate Display.label
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 88, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Display.encodedSize = codec.kStructHeaderSize + 96;

  Display.decode = function(decoder) {
    var packed;
    var val = new Display();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.id =
        decoder.decodeStruct(codec.Int64);
    val.bounds =
        decoder.decodeStructPointer(geometry$.Rect);
    val.sizeInPixels =
        decoder.decodeStructPointer(geometry$.Size);
    val.nativeOrigin =
        decoder.decodeStructPointer(geometry$.Point);
    val.workArea =
        decoder.decodeStructPointer(geometry$.Rect);
    val.deviceScaleFactor =
        decoder.decodeStruct(codec.Float);
    val.rotation =
        decoder.decodeStruct(new codec.Enum(Rotation));
    val.touchSupport =
        decoder.decodeStruct(new codec.Enum(TouchSupport));
    val.accelerometerSupport =
        decoder.decodeStruct(new codec.Enum(AccelerometerSupport));
    val.maximumCursorSize =
        decoder.decodeStructPointer(geometry$.Size);
    val.colorSpaces =
        decoder.decodeStructPointer(display_color_spaces$.DisplayColorSpaces);
    val.colorDepth =
        decoder.decodeStruct(codec.Int32);
    val.depthPerComponent =
        decoder.decodeStruct(codec.Int32);
    packed = decoder.readUint8();
    val.isMonochrome = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.displayFrequency =
        decoder.decodeStruct(codec.Float);
    val.label =
        decoder.decodeStruct(codec.String);
    return val;
  };

  Display.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Display.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int64, val.id);
    encoder.encodeStructPointer(geometry$.Rect, val.bounds);
    encoder.encodeStructPointer(geometry$.Size, val.sizeInPixels);
    encoder.encodeStructPointer(geometry$.Point, val.nativeOrigin);
    encoder.encodeStructPointer(geometry$.Rect, val.workArea);
    encoder.encodeStruct(codec.Float, val.deviceScaleFactor);
    encoder.encodeStruct(codec.Int32, val.rotation);
    encoder.encodeStruct(codec.Int32, val.touchSupport);
    encoder.encodeStruct(codec.Int32, val.accelerometerSupport);
    encoder.encodeStructPointer(geometry$.Size, val.maximumCursorSize);
    encoder.encodeStructPointer(display_color_spaces$.DisplayColorSpaces, val.colorSpaces);
    encoder.encodeStruct(codec.Int32, val.colorDepth);
    encoder.encodeStruct(codec.Int32, val.depthPerComponent);
    packed = 0;
    packed |= (val.isMonochrome & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Float, val.displayFrequency);
    encoder.encodeStruct(codec.String, val.label);
  };
  exports.Rotation = Rotation;
  exports.TouchSupport = TouchSupport;
  exports.AccelerometerSupport = AccelerometerSupport;
  exports.Display = Display;
})();