// ui/display/mojom/display.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_DISPLAY_MOJOM_DISPLAY_MOJOM_DATA_VIEW_H_
#define UI_DISPLAY_MOJOM_DISPLAY_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "ui/display/mojom/display.mojom-shared-internal.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/mojom/display_color_spaces.mojom-shared.h"


namespace display::mojom {
class DisplayDataView;



}  // display::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::display::mojom::DisplayDataView> {
  using Data = ::display::mojom::internal::Display_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace display::mojom {


enum class Rotation : int32_t {
  
  VALUE_0 = 0,
  
  VALUE_90 = 1,
  
  VALUE_180 = 2,
  
  VALUE_270 = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, Rotation value);
inline bool IsKnownEnumValue(Rotation value) {
  return internal::Rotation_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class TouchSupport : int32_t {
  
  UNKNOWN = 0,
  
  AVAILABLE = 1,
  
  UNAVAILABLE = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, TouchSupport value);
inline bool IsKnownEnumValue(TouchSupport value) {
  return internal::TouchSupport_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class AccelerometerSupport : int32_t {
  
  UNKNOWN = 0,
  
  AVAILABLE = 1,
  
  UNAVAILABLE = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, AccelerometerSupport value);
inline bool IsKnownEnumValue(AccelerometerSupport value) {
  return internal::AccelerometerSupport_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class DisplayDataView {
 public:
  DisplayDataView() = default;

  DisplayDataView(
      internal::Display_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int64_t id() const {
    return data_->id;
  }
  inline void GetBoundsDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBounds(UserType* output) {
    
    auto* pointer = data_->bounds.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
  inline void GetSizeInPixelsDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSizeInPixels(UserType* output) {
    
    auto* pointer = data_->size_in_pixels.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  inline void GetNativeOriginDataView(
      ::gfx::mojom::PointDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNativeOrigin(UserType* output) {
    
    auto* pointer = data_->native_origin.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointDataView>(
        pointer, output, message_);
  }
  inline void GetWorkAreaDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWorkArea(UserType* output) {
    
    auto* pointer = data_->work_area.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
  float device_scale_factor() const {
    return data_->device_scale_factor;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadRotation(UserType* output) const {
    auto data_value = data_->rotation;
    return mojo::internal::Deserialize<::display::mojom::Rotation>(
        data_value, output);
  }
  Rotation rotation() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::display::mojom::Rotation>(data_->rotation));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadTouchSupport(UserType* output) const {
    auto data_value = data_->touch_support;
    return mojo::internal::Deserialize<::display::mojom::TouchSupport>(
        data_value, output);
  }
  TouchSupport touch_support() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::display::mojom::TouchSupport>(data_->touch_support));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadAccelerometerSupport(UserType* output) const {
    auto data_value = data_->accelerometer_support;
    return mojo::internal::Deserialize<::display::mojom::AccelerometerSupport>(
        data_value, output);
  }
  AccelerometerSupport accelerometer_support() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::display::mojom::AccelerometerSupport>(data_->accelerometer_support));
  }
  inline void GetMaximumCursorSizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMaximumCursorSize(UserType* output) {
    
    auto* pointer = data_->maximum_cursor_size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  inline void GetColorSpacesDataView(
      ::gfx::mojom::DisplayColorSpacesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadColorSpaces(UserType* output) {
    
    auto* pointer = data_->color_spaces.Get();
    return mojo::internal::Deserialize<::gfx::mojom::DisplayColorSpacesDataView>(
        pointer, output, message_);
  }
  int32_t color_depth() const {
    return data_->color_depth;
  }
  int32_t depth_per_component() const {
    return data_->depth_per_component;
  }
  bool is_monochrome() const {
    return data_->is_monochrome;
  }
  float display_frequency() const {
    return data_->display_frequency;
  }
  inline void GetLabelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLabel(UserType* output) {
    
    auto* pointer = data_->label.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::Display_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // display::mojom

#endif  // UI_DISPLAY_MOJOM_DISPLAY_MOJOM_DATA_VIEW_H_