// ui/base/mojom/window_show_state.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "ui/base/mojom/window_show_state.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "ui/base/mojom/window_show_state.mojom-params-data.h"
namespace ui {
namespace mojom {

NOINLINE static const char* WindowShowStateToStringHelper(WindowShowState value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case WindowShowState::kDefault:
      return "kDefault";
    case WindowShowState::kNormal:
      return "kNormal";
    case WindowShowState::kMinimized:
      return "kMinimized";
    case WindowShowState::kMaximized:
      return "kMaximized";
    case WindowShowState::kInactive:
      return "kInactive";
    case WindowShowState::kFullscreen:
      return "kFullscreen";
    case WindowShowState::kEnd:
      return "kEnd";
    default:
      return nullptr;
  }
}

std::string WindowShowStateToString(WindowShowState value) {
  const char *str = WindowShowStateToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown WindowShowState value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, WindowShowState value) {
  return os << WindowShowStateToString(value);
}

namespace internal {

}  // namespace internal
}  // namespace mojom
}  // namespace ui

namespace perfetto {

// static
void TraceFormatTraits<::ui::mojom::WindowShowState>::WriteIntoTrace(
   perfetto::TracedValue context, ::ui::mojom::WindowShowState value) {
  return std::move(context).WriteString(::ui::mojom::WindowShowStateToString(value));
}

} // namespace perfetto