// ui/base/mojom/attributed_string.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_BASE_MOJOM_ATTRIBUTED_STRING_MOJOM_H_
#define UI_BASE_MOJOM_ATTRIBUTED_STRING_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/base/mojom/attributed_string.mojom-features.h"  // IWYU pragma: export
#include "ui/base/mojom/attributed_string.mojom-shared.h"  // IWYU pragma: export
#include "ui/base/mojom/attributed_string.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/string16.mojom.h"
#include "ui/gfx/range/mojom/range.mojom.h"
#include <string>
#include <vector>








namespace ui::mojom {









class  FontAttribute {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FontAttribute, T>::value>;
  using DataView = FontAttributeDataView;
  using Data_ = internal::FontAttribute_Data;

  template <typename... Args>
  static FontAttributePtr New(Args&&... args) {
    return FontAttributePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FontAttributePtr From(const U& u) {
    return mojo::TypeConverter<FontAttributePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FontAttribute>::Convert(*this);
  }


  FontAttribute();

  FontAttribute(
      const ::std::u16string& font_name,
      float font_point_size,
      const ::gfx::Range& effective_range);


  ~FontAttribute();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FontAttributePtr>
  FontAttributePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FontAttribute::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FontAttribute::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FontAttribute::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FontAttribute::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FontAttribute::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FontAttribute::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FontAttribute_UnserializedMessageContext<
            UserType, FontAttribute::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FontAttribute::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FontAttribute::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FontAttribute_UnserializedMessageContext<
            UserType, FontAttribute::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FontAttribute::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::std::u16string font_name;
  
  float font_point_size;
  
  ::gfx::Range effective_range;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FontAttribute::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FontAttribute::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FontAttribute::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FontAttribute::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  AttributedString {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AttributedString, T>::value>;
  using DataView = AttributedStringDataView;
  using Data_ = internal::AttributedString_Data;

  template <typename... Args>
  static AttributedStringPtr New(Args&&... args) {
    return AttributedStringPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AttributedStringPtr From(const U& u) {
    return mojo::TypeConverter<AttributedStringPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AttributedString>::Convert(*this);
  }


  AttributedString();

  AttributedString(
      const ::std::u16string& string,
      std::vector<FontAttributePtr> attributes);

AttributedString(const AttributedString&) = delete;
AttributedString& operator=(const AttributedString&) = delete;

  ~AttributedString();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AttributedStringPtr>
  AttributedStringPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AttributedString::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AttributedString::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AttributedString::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AttributedString::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AttributedString::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AttributedString::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AttributedString_UnserializedMessageContext<
            UserType, AttributedString::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AttributedString::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AttributedString::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AttributedString_UnserializedMessageContext<
            UserType, AttributedString::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AttributedString::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::std::u16string string;
  
  std::vector<FontAttributePtr> attributes;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AttributedString::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AttributedString::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AttributedString::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AttributedString::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
FontAttributePtr FontAttribute::Clone() const {
  return New(
      mojo::Clone(font_name),
      mojo::Clone(font_point_size),
      mojo::Clone(effective_range)
  );
}

template <typename T, FontAttribute::EnableIfSame<T>*>
bool FontAttribute::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->font_name, other_struct.font_name))
    return false;
  if (!mojo::Equals(this->font_point_size, other_struct.font_point_size))
    return false;
  if (!mojo::Equals(this->effective_range, other_struct.effective_range))
    return false;
  return true;
}

template <typename T, FontAttribute::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.font_name < rhs.font_name)
    return true;
  if (rhs.font_name < lhs.font_name)
    return false;
  if (lhs.font_point_size < rhs.font_point_size)
    return true;
  if (rhs.font_point_size < lhs.font_point_size)
    return false;
  if (lhs.effective_range < rhs.effective_range)
    return true;
  if (rhs.effective_range < lhs.effective_range)
    return false;
  return false;
}
template <typename StructPtrType>
AttributedStringPtr AttributedString::Clone() const {
  return New(
      mojo::Clone(string),
      mojo::Clone(attributes)
  );
}

template <typename T, AttributedString::EnableIfSame<T>*>
bool AttributedString::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->string, other_struct.string))
    return false;
  if (!mojo::Equals(this->attributes, other_struct.attributes))
    return false;
  return true;
}

template <typename T, AttributedString::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.string < rhs.string)
    return true;
  if (rhs.string < lhs.string)
    return false;
  if (lhs.attributes < rhs.attributes)
    return true;
  if (rhs.attributes < lhs.attributes)
    return false;
  return false;
}


}  // ui::mojom

namespace mojo {


template <>
struct  StructTraits<::ui::mojom::FontAttribute::DataView,
                                         ::ui::mojom::FontAttributePtr> {
  static bool IsNull(const ::ui::mojom::FontAttributePtr& input) { return !input; }
  static void SetToNull(::ui::mojom::FontAttributePtr* output) { output->reset(); }

  static const decltype(::ui::mojom::FontAttribute::font_name)& font_name(
      const ::ui::mojom::FontAttributePtr& input) {
    return input->font_name;
  }

  static decltype(::ui::mojom::FontAttribute::font_point_size) font_point_size(
      const ::ui::mojom::FontAttributePtr& input) {
    return input->font_point_size;
  }

  static const decltype(::ui::mojom::FontAttribute::effective_range)& effective_range(
      const ::ui::mojom::FontAttributePtr& input) {
    return input->effective_range;
  }

  static bool Read(::ui::mojom::FontAttribute::DataView input, ::ui::mojom::FontAttributePtr* output);
};


template <>
struct  StructTraits<::ui::mojom::AttributedString::DataView,
                                         ::ui::mojom::AttributedStringPtr> {
  static bool IsNull(const ::ui::mojom::AttributedStringPtr& input) { return !input; }
  static void SetToNull(::ui::mojom::AttributedStringPtr* output) { output->reset(); }

  static const decltype(::ui::mojom::AttributedString::string)& string(
      const ::ui::mojom::AttributedStringPtr& input) {
    return input->string;
  }

  static const decltype(::ui::mojom::AttributedString::attributes)& attributes(
      const ::ui::mojom::AttributedStringPtr& input) {
    return input->attributes;
  }

  static bool Read(::ui::mojom::AttributedString::DataView input, ::ui::mojom::AttributedStringPtr* output);
};

}  // namespace mojo

#endif  // UI_BASE_MOJOM_ATTRIBUTED_STRING_MOJOM_H_