// ui/base/mojom/attributed_string.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_BASE_MOJOM_ATTRIBUTED_STRING_MOJOM_DATA_VIEW_H_
#define UI_BASE_MOJOM_ATTRIBUTED_STRING_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "ui/base/mojom/attributed_string.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "ui/gfx/range/mojom/range.mojom-shared.h"


namespace ui::mojom {
class FontAttributeDataView;

class AttributedStringDataView;



}  // ui::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::ui::mojom::FontAttributeDataView> {
  using Data = ::ui::mojom::internal::FontAttribute_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::ui::mojom::AttributedStringDataView> {
  using Data = ::ui::mojom::internal::AttributedString_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace ui::mojom {


class FontAttributeDataView {
 public:
  FontAttributeDataView() = default;

  FontAttributeDataView(
      internal::FontAttribute_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetFontNameDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFontName(UserType* output) {
    
    auto* pointer = data_->font_name.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  float font_point_size() const {
    return data_->font_point_size;
  }
  inline void GetEffectiveRangeDataView(
      ::gfx::mojom::RangeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEffectiveRange(UserType* output) {
    
    auto* pointer = data_->effective_range.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RangeDataView>(
        pointer, output, message_);
  }
 private:
  internal::FontAttribute_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AttributedStringDataView {
 public:
  AttributedStringDataView() = default;

  AttributedStringDataView(
      internal::AttributedString_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetStringDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadString(UserType* output) {
    
    auto* pointer = data_->string.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetAttributesDataView(
      mojo::ArrayDataView<FontAttributeDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAttributes(UserType* output) {
    
    auto* pointer = data_->attributes.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::ui::mojom::FontAttributeDataView>>(
        pointer, output, message_);
  }
 private:
  internal::AttributedString_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // ui::mojom

#endif  // UI_BASE_MOJOM_ATTRIBUTED_STRING_MOJOM_DATA_VIEW_H_