// ui/base/ime/mojom/ime_types.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'ui/base/ime/mojom/ime_types.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('ui.mojom');


  var TextInputMode = {};
  TextInputMode.kDefault = 0;
  TextInputMode.kNone = 1;
  TextInputMode.kText = 2;
  TextInputMode.kTel = 3;
  TextInputMode.kUrl = 4;
  TextInputMode.kEmail = 5;
  TextInputMode.kNumeric = 6;
  TextInputMode.kDecimal = 7;
  TextInputMode.kSearch = 8;
  TextInputMode.MIN_VALUE = 0;
  TextInputMode.MAX_VALUE = 8;

  TextInputMode.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
      return true;
    }
    return false;
  };

  TextInputMode.toKnownEnumValue = function(value) {
    return value;
  };

  TextInputMode.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var TextInputAction = {};
  TextInputAction.kDefault = 0;
  TextInputAction.kEnter = 1;
  TextInputAction.kDone = 2;
  TextInputAction.kGo = 3;
  TextInputAction.kNext = 4;
  TextInputAction.kPrevious = 5;
  TextInputAction.kSearch = 6;
  TextInputAction.kSend = 7;
  TextInputAction.MIN_VALUE = 0;
  TextInputAction.MAX_VALUE = 7;

  TextInputAction.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
      return true;
    }
    return false;
  };

  TextInputAction.toKnownEnumValue = function(value) {
    return value;
  };

  TextInputAction.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var TextInputType = {};
  TextInputType.NONE = 0;
  TextInputType.TEXT = 1;
  TextInputType.PASSWORD = 2;
  TextInputType.SEARCH = 3;
  TextInputType.EMAIL = 4;
  TextInputType.NUMBER = 5;
  TextInputType.TELEPHONE = 6;
  TextInputType.URL = 7;
  TextInputType.DATE = 8;
  TextInputType.DATE_TIME = 9;
  TextInputType.DATE_TIME_LOCAL = 10;
  TextInputType.MONTH = 11;
  TextInputType.TIME = 12;
  TextInputType.WEEK = 13;
  TextInputType.TEXT_AREA = 14;
  TextInputType.CONTENT_EDITABLE = 15;
  TextInputType.DATE_TIME_FIELD = 16;
  TextInputType.TYPE_NULL = 17;
  TextInputType.MAX = 17;
  TextInputType.MIN_VALUE = 0;
  TextInputType.MAX_VALUE = 17;

  TextInputType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
    case 11:
    case 12:
    case 13:
    case 14:
    case 15:
    case 16:
    case 17:
      return true;
    }
    return false;
  };

  TextInputType.toKnownEnumValue = function(value) {
    return value;
  };

  TextInputType.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var ImeTextSpanType = {};
  ImeTextSpanType.kComposition = 0;
  ImeTextSpanType.kSuggestion = 1;
  ImeTextSpanType.kMisspellingSuggestion = 2;
  ImeTextSpanType.kAutocorrect = 3;
  ImeTextSpanType.kGrammarSuggestion = 4;
  ImeTextSpanType.MIN_VALUE = 0;
  ImeTextSpanType.MAX_VALUE = 4;

  ImeTextSpanType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
      return true;
    }
    return false;
  };

  ImeTextSpanType.toKnownEnumValue = function(value) {
    return value;
  };

  ImeTextSpanType.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var ImeTextSpanThickness = {};
  ImeTextSpanThickness.kNone = 0;
  ImeTextSpanThickness.kThin = 1;
  ImeTextSpanThickness.kThick = 2;
  ImeTextSpanThickness.MIN_VALUE = 0;
  ImeTextSpanThickness.MAX_VALUE = 2;

  ImeTextSpanThickness.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  ImeTextSpanThickness.toKnownEnumValue = function(value) {
    return value;
  };

  ImeTextSpanThickness.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var ImeTextSpanUnderlineStyle = {};
  ImeTextSpanUnderlineStyle.kNone = 0;
  ImeTextSpanUnderlineStyle.kSolid = 1;
  ImeTextSpanUnderlineStyle.kDot = 2;
  ImeTextSpanUnderlineStyle.kDash = 3;
  ImeTextSpanUnderlineStyle.kSquiggle = 4;
  ImeTextSpanUnderlineStyle.MIN_VALUE = 0;
  ImeTextSpanUnderlineStyle.MAX_VALUE = 4;

  ImeTextSpanUnderlineStyle.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
      return true;
    }
    return false;
  };

  ImeTextSpanUnderlineStyle.toKnownEnumValue = function(value) {
    return value;
  };

  ImeTextSpanUnderlineStyle.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function ImeTextSpan(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ImeTextSpan.prototype.initDefaults_ = function() {
    this.type = 0;
    this.startOffset = 0;
    this.endOffset = 0;
    this.underlineColor = 0;
    this.thickness = 0;
    this.underlineStyle = 0;
    this.textColor = 0;
    this.backgroundColor = 0;
    this.suggestionHighlightColor = 0;
    this.removeOnFinishComposing = false;
    this.interimCharSelection = false;
    this.shouldHideSuggestionMenu = false;
    this.suggestions = null;
  };
  ImeTextSpan.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ImeTextSpan.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 56}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ImeTextSpan.type
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, ImeTextSpanType);
    if (err !== validator.validationError.NONE)
        return err;





    // validate ImeTextSpan.thickness
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 16, ImeTextSpanThickness);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ImeTextSpan.underlineStyle
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 20, ImeTextSpanUnderlineStyle);
    if (err !== validator.validationError.NONE)
        return err;







    // validate ImeTextSpan.suggestions
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 40, 8, codec.String, false, [0, 0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  ImeTextSpan.encodedSize = codec.kStructHeaderSize + 48;

  ImeTextSpan.decode = function(decoder) {
    var packed;
    var val = new ImeTextSpan();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.type =
        decoder.decodeStruct(new codec.Enum(ImeTextSpanType));
    val.startOffset =
        decoder.decodeStruct(codec.Uint32);
    val.endOffset =
        decoder.decodeStruct(codec.Uint32);
    val.underlineColor =
        decoder.decodeStruct(codec.Uint32);
    val.thickness =
        decoder.decodeStruct(new codec.Enum(ImeTextSpanThickness));
    val.underlineStyle =
        decoder.decodeStruct(new codec.Enum(ImeTextSpanUnderlineStyle));
    val.textColor =
        decoder.decodeStruct(codec.Uint32);
    val.backgroundColor =
        decoder.decodeStruct(codec.Uint32);
    val.suggestionHighlightColor =
        decoder.decodeStruct(codec.Uint32);
    packed = decoder.readUint8();
    val.removeOnFinishComposing = (packed >> 0) & 1 ? true : false;
    val.interimCharSelection = (packed >> 1) & 1 ? true : false;
    val.shouldHideSuggestionMenu = (packed >> 2) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.suggestions =
        decoder.decodeArrayPointer(codec.String);
    return val;
  };

  ImeTextSpan.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ImeTextSpan.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.type);
    encoder.encodeStruct(codec.Uint32, val.startOffset);
    encoder.encodeStruct(codec.Uint32, val.endOffset);
    encoder.encodeStruct(codec.Uint32, val.underlineColor);
    encoder.encodeStruct(codec.Int32, val.thickness);
    encoder.encodeStruct(codec.Int32, val.underlineStyle);
    encoder.encodeStruct(codec.Uint32, val.textColor);
    encoder.encodeStruct(codec.Uint32, val.backgroundColor);
    encoder.encodeStruct(codec.Uint32, val.suggestionHighlightColor);
    packed = 0;
    packed |= (val.removeOnFinishComposing & 1) << 0
    packed |= (val.interimCharSelection & 1) << 1
    packed |= (val.shouldHideSuggestionMenu & 1) << 2
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeArrayPointer(codec.String, val.suggestions);
  };
  exports.TextInputMode = TextInputMode;
  exports.TextInputAction = TextInputAction;
  exports.TextInputType = TextInputType;
  exports.ImeTextSpanType = ImeTextSpanType;
  exports.ImeTextSpanThickness = ImeTextSpanThickness;
  exports.ImeTextSpanUnderlineStyle = ImeTextSpanUnderlineStyle;
  exports.ImeTextSpan = ImeTextSpan;
})();