// ui/base/ime/mojom/ime_types.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_BASE_IME_MOJOM_IME_TYPES_MOJOM_SEND_VALIDATION_H_
#define UI_BASE_IME_MOJOM_IME_TYPES_MOJOM_SEND_VALIDATION_H_

#include "ui/base/ime/mojom/ime_types.mojom-shared-internal.h"

#include "ui/base/ime/mojom/ime_types.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::ui::mojom::TextInputMode, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::ui::mojom::TextInputAction, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::ui::mojom::TextInputType, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::ui::mojom::ImeTextSpanType, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::ui::mojom::ImeTextSpanThickness, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::ui::mojom::ImeTextSpanUnderlineStyle, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::ui::mojom::ImeTextSpanDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::ui::mojom::ImeTextSpanDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::ui::mojom::internal::ImeTextSpan_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::ui::mojom::ImeTextSpanType>(
        Traits::type(input),
        &fragment->type);

      fragment->start_offset = Traits::start_offset(input);

      fragment->end_offset = Traits::end_offset(input);

      fragment->underline_color = Traits::underline_color(input);

      
      mojo::internal::Serialize<::ui::mojom::ImeTextSpanThickness>(
        Traits::thickness(input),
        &fragment->thickness);

      
      mojo::internal::Serialize<::ui::mojom::ImeTextSpanUnderlineStyle>(
        Traits::underline_style(input),
        &fragment->underline_style);

      fragment->text_color = Traits::text_color(input);

      fragment->background_color = Traits::background_color(input);

      fragment->suggestion_highlight_color = Traits::suggestion_highlight_color(input);

      fragment->remove_on_finish_composing = Traits::remove_on_finish_composing(input);

      fragment->interim_char_selection = Traits::interim_char_selection(input);

      decltype(Traits::suggestions(input)) in_suggestions = Traits::suggestions(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->suggestions)::BaseType>
          suggestions_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& suggestions_validate_params =
          mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>, send_validation>(
        in_suggestions,
        suggestions_fragment,
        &suggestions_validate_params);

      fragment->suggestions.Set(
          suggestions_fragment.is_null() ? nullptr : suggestions_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->suggestions.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null suggestions in ImeTextSpan struct");

      fragment->should_hide_suggestion_menu = Traits::should_hide_suggestion_menu(input);
  }
};

}  // namespace mojo::internal

#endif  // UI_BASE_IME_MOJOM_IME_TYPES_MOJOM_SEND_VALIDATION_H_